/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoEIHI;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestEIHI_Xupdates {
    public static void main(String[] arg) throws IOException {
        String input = MainTestEIHI_Xupdates.fileToPath("DB_Utility.txt");
        int min_utility = 30;
        int numberOfUpdates = 2;
        int linecount = MainTestEIHI_Xupdates.countLines(input);
        double addedratio = 1.0 / (double)numberOfUpdates;
        int linesForeEachUpdate = (int)(addedratio * (double)linecount);
        AlgoEIHI algo = new AlgoEIHI();
        int firstLine = 0;
        for (int i = 0; i < numberOfUpdates; ++i) {
            int lastLine = firstLine + linesForeEachUpdate;
            if (i == numberOfUpdates - 1) {
                System.out.println("" + i + ") Run the algorithm using line " + firstLine + " to before line " + linecount + " of the input database.");
                algo.runAlgorithm(input, min_utility, firstLine, linecount);
            } else {
                System.out.println("" + i + ") Run the algorithm using line " + firstLine + " to before line " + lastLine + " of the input database.");
                algo.runAlgorithm(input, min_utility, firstLine, lastLine);
            }
            algo.printStats();
            firstLine = lastLine;
        }
        int realHUICount = algo.getRealHUICount();
        System.out.println("NUMBER OF HUI FOUND: " + realHUICount);
        algo.printHUIs();
        String output = ".//output.txt";
        algo.writeHUIsToFile(output);
    }

    public static int countLines(String filepath) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filepath));
        while (reader.readLine() != null) {
        }
        int count = reader.getLineNumber();
        reader.close();
        return count;
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestEIHI_Xupdates.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

