/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.AssociationRuleIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.HashTableIT;
import ca.pfv.spmf.algorithms.frequentpatterns.itemsettree.ItemsetTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class MainTestItemsetTree {
    public static void main(String[] arg) throws IOException {
        String input = MainTestItemsetTree.fileToPath("contextItemsetTree.txt");
        ItemsetTree itemsetTree = new ItemsetTree();
        itemsetTree.buildTree(input);
        itemsetTree.printStatistics();
        System.out.println("THIS IS THE TREE:");
        itemsetTree.printTree();
        System.out.println("THIS IS THE TREE AFTER ADDING A NEW TRANSACTION {4,5}:");
        itemsetTree.addTransaction(new int[]{4, 5});
        itemsetTree.printTree();
        System.out.println("EXAMPLES QUERIES: FIND THE SUPPORT OF SOME ITEMSETS:");
        System.out.println("the support of 1 2 3 is : " + itemsetTree.getSupportOfItemset(new int[]{1, 2, 3}));
        System.out.println("the support of 2 is : " + itemsetTree.getSupportOfItemset(new int[]{2}));
        System.out.println("the support of 2 4 is : " + itemsetTree.getSupportOfItemset(new int[]{2, 4}));
        System.out.println("the support of 1 2 is : " + itemsetTree.getSupportOfItemset(new int[]{1, 2}));
        System.out.println("EXAMPLE QUERY: FIND ALL ITEMSETS THAT SUBSUME {1 2}");
        HashTableIT result = itemsetTree.getFrequentItemsetSubsuming(new int[]{1, 2});
        for (List<Itemset> list : result.table) {
            if (list == null) continue;
            for (Itemset itemset2 : list) {
                System.out.println("[" + itemset2.toString() + "]    supp:" + itemset2.support);
            }
        }
        System.out.println("EXAMPLE QUERY: FIND ALL ITEMSETS THAT SUBSUME {1} and minsup >= 2");
        int minsup = 2;
        HashTableIT result2 = itemsetTree.getFrequentItemsetSubsuming(new int[]{1}, minsup);
        for (List<Itemset> list : result2.table) {
            if (list == null) continue;
            for (Itemset itemset3 : list) {
                System.out.println("[" + itemset3.toString() + "]    supp:" + itemset3.support);
            }
        }
        System.out.println("EXAMPLE QUERY: FIND ALL ASSOCIATION RULE WITH AN ITEMSET {1} AS ANTECEDENT AND MINSUP >= 2 and minconf >= 0.1");
        minsup = 2;
        double minconf = 0.1;
        List rules = itemsetTree.generateRules(new int[]{1}, minsup, minconf);
        for (AssociationRuleIT rule : rules) {
            System.out.println(rule);
        }
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestItemsetTree.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

