/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.SequenceStatsGenerator;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.LZ78.LZ78Predictor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

public class MainTestLz78 {
    public static void main(String[] arg) throws IOException {
        Sequence sequence2;
        String inputPath = MainTestLz78.fileToPath("contextCPT.txt");
        SequenceDatabase trainingSet = new SequenceDatabase();
        trainingSet.loadFileSPMFFormat(inputPath, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        System.out.println("--- Training sequences ---");
        for (Sequence sequence2 : trainingSet.getSequences()) {
            System.out.println(sequence2.toString());
        }
        System.out.println();
        SequenceStatsGenerator.prinStats(trainingSet, " Statistics about training sequences ");
        LZ78Predictor predictionModel = new LZ78Predictor("LZ78");
        predictionModel.Train(trainingSet.getSequences());
        sequence2 = new Sequence(0);
        sequence2.addItem(new Item(1));
        sequence2.addItem(new Item(4));
        System.out.println("--- Prediction ---");
        Sequence thePrediction = predictionModel.Predict(sequence2);
        System.out.println("For the sequence <(1),(4)>, the prediction for the next symbol is: +" + thePrediction);
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestLz78.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

