/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.AlgoQCSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class MainTestQCSP_saveToMemory {
    public static void main(String[] arg) throws Exception {
        String input = MainTestQCSP_saveToMemory.fileToPath("contextQCSP.txt");
        boolean showDebugInformation = true;
        int minsup = 1;
        double alpha = 2.0;
        int maximumSequentialPatternLength = 3;
        int topK = 4;
        AlgoQCSP algorithm = new AlgoQCSP();
        algorithm.setDebug(showDebugInformation);
        List<Pair<SequentialPattern, Double>> patterns = algorithm.runAlgorithm(input, null, minsup, alpha, maximumSequentialPatternLength, topK);
        for (Pair<SequentialPattern, Double> pattern : patterns) {
            List<Integer> sp = pattern.getFirst().pattern;
            Double cohesion = pattern.getSecond();
            int support = algorithm.support(sp);
            String patternToString = String.format(">>>>%s\t#SUP: %d\t#QCOH: %.3f", sp, support, cohesion);
            System.out.println(patternToString);
        }
        algorithm.printStatistics();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestQCSP_saveToMemory.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

