/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.AlgoQCSP;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.SequentialPattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.qcsp.util.Pair;
import ca.pfv.spmf.test.MainTestQCSP_saveToMemory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MainTestQCSP_singleSequence {
    public static void main(String[] arg) throws Exception {
        String input = MainTestQCSP_singleSequence.fileToPath("moby_fragment.seq");
        String labelFile = MainTestQCSP_singleSequence.fileToPath("moby_fragment.lab");
        String output = "./output.txt";
        int minsup = 2;
        double alpha = 2.0;
        int maximumSequentialPatternLength = 10;
        int topK = 20;
        AlgoQCSP algorithm = new AlgoQCSP();
        algorithm.setDebug(true);
        algorithm.setLabelsFile(labelFile);
        List<Pair<SequentialPattern, Double>> patterns = algorithm.runAlgorithm(input, output, minsup, alpha, maximumSequentialPatternLength, topK);
        algorithm.printStatistics();
    }

    private static List<String> textFragmentToSequence(String tekstfragment) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(tekstfragment)));
        ArrayList<String> sentences = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            sentences.add(line);
            line = reader.readLine();
        }
        reader.close();
        ArrayList<Integer> sequence = new ArrayList<Integer>();
        TreeMap<String, Integer> labelDict = new TreeMap<String, Integer>();
        for (String sentence : sentences) {
            String[] words = MainTestQCSP_singleSequence.convertLine(sentence);
            for (int i = 0; i < words.length; ++i) {
                Integer key = (Integer)labelDict.get(words[i]);
                if (key == null) {
                    key = labelDict.size() + 1;
                    labelDict.put(words[i], key);
                }
                sequence.add(key);
            }
        }
        File outputSeq = new File("./moby_fragment.seq");
        File outputLabels = new File("./moby_fragment.lab");
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputSeq));
        Iterator i = sequence.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            writer.write(String.valueOf(i2));
            writer.write(" ");
        }
        writer.close();
        writer = new BufferedWriter(new FileWriter(outputLabels));
        ArrayList entries = new ArrayList();
        for (Map.Entry entry : labelDict.entrySet()) {
            entries.add(entry);
        }
        entries.sort((a, b) -> ((Integer)a.getValue()).compareTo((Integer)b.getValue()));
        for (Map.Entry entry : entries) {
            writer.write((String)entry.getKey());
            writer.write("\n");
        }
        writer.close();
        return Arrays.asList(outputSeq.getAbsolutePath(), outputLabels.getAbsolutePath());
    }

    public static String[] convertLine(String line) {
        line = line.replaceAll("[\\.,\\?!\\-\\\u00e2\u20ac\u201d\"\"'';\\|]+", " ");
        line = line.replaceAll("[^\\w+|\\d+|\\d+\\.\\d+|\\s+]", " ");
        line = line.toLowerCase().trim();
        line = line.replaceAll("\\d+|\\d+\\.\\d+", " ");
        line = line.replaceAll("\\s+", " ");
        String[] tokens = line.split("[^\\w+|\\d+|\\d\\.\\d+]");
        return tokens;
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestQCSP_saveToMemory.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

