/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.test;

import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import ca.pfv.spmf.algorithms.timeseries.split.AlgoSplitTimeSeries;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class MainTestSplitTimeSeriesByLength_FileToFile {
    public static void main(String[] arg) throws IOException {
        String input = MainTestSplitTimeSeriesByLength_FileToFile.fileToPath("contextSAX.txt");
        String output = "./output.txt";
        int sizeOfSegment = 3;
        String separator = ",";
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(input, separator);
        ArrayList<TimeSeries> allSplittedTimeSeries = new ArrayList<TimeSeries>(multipleTimeSeries.size() * 2);
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoSplitTimeSeries algorithm = new AlgoSplitTimeSeries();
            TimeSeries[] splittedTimeSeries = algorithm.runAlgorithm(timeSeries, sizeOfSegment);
            algorithm.printStats();
            for (TimeSeries series : splittedTimeSeries) {
                allSplittedTimeSeries.add(series);
            }
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(output, allSplittedTimeSeries, separator);
        algorithm2.printStats();
    }

    public static String fileToPath(String filename) throws UnsupportedEncodingException {
        URL url = MainTestSplitTimeSeriesByLength_FileToFile.class.getResource(filename);
        return URLDecoder.decode(url.getPath(), "UTF-8");
    }
}

