/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_converter;

import ca.pfv.spmf.tools.dataset_converter.Formats;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class SequenceDatabaseConverter {
    String input;
    String output;
    int lineCount = 0;
    BufferedWriter writer;

    public void convert(String input, String output, Formats inputFileformat, int lineCount, Charset charset) throws IOException {
        this.input = input;
        this.output = output;
        this.lineCount = lineCount;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        this.writer = new BufferedWriter(new FileWriter(output));
        if (inputFileformat.equals((Object)Formats.IBMGenerator)) {
            this.convertIBMGenerator();
        } else if (inputFileformat.equals((Object)Formats.Kosarak)) {
            this.convertKosarak(charset);
        } else if (inputFileformat.equals((Object)Formats.CSV_INTEGER)) {
            this.convertCSV(charset);
        } else if (inputFileformat.equals((Object)Formats.BMS)) {
            this.convertBMS(charset);
        } else if (inputFileformat.equals((Object)Formats.Snake)) {
            this.convertSnake(charset);
        } else if (inputFileformat.equals((Object)Formats.SPMF_TRANSACTION_DB)) {
            this.convertTransactionDB(charset);
        } else if (inputFileformat.equals((Object)Formats.TEXT)) {
            this.convertTEXT(false, charset);
        }
        this.writer.close();
    }

    private void convertTransactionDB(Charset charset) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split;
                for (String itemString : split = thisLine.split(" ")) {
                    int item = Integer.parseInt(itemString);
                    this.writer.write(item + " -1 ");
                }
                this.writer.write("-2");
                if (++count == this.lineCount) break;
                this.writer.newLine();
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertSnake(Charset charset) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.length() >= 11) {
                    for (int i = 0; i < thisLine.length(); ++i) {
                        int character = thisLine.toCharArray()[i] - 65;
                        this.writer.write(character + " -1 ");
                    }
                    this.writer.write("-2");
                }
                if (++count == this.lineCount) break;
                this.writer.newLine();
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertBMS(Charset charset) {
        BufferedReader myInput = null;
        try {
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            int lastId = 0;
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split = thisLine.split(" ");
                int id = Integer.parseInt(split[0]);
                int val = Integer.parseInt(split[1]);
                if (lastId != id) {
                    if (lastId != 0) {
                        ++count;
                        this.writer.write("-2");
                        this.writer.newLine();
                    }
                    lastId = id;
                }
                if (count == this.lineCount) break;
                this.writer.write(val + " -1 ");
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertCSV(Charset charset) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split;
                for (String value : split = thisLine.split(",")) {
                    Integer item = Integer.parseInt(value);
                    this.writer.write(item + " -1 ");
                }
                this.writer.write("-2");
                if (++count == this.lineCount) {
                    break;
                }
                this.writer.newLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertKosarak(Charset charset) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] split;
                for (String value : split = thisLine.split(" ")) {
                    Integer item = Integer.parseInt(value);
                    this.writer.write(item + " -1 ");
                }
                this.writer.write("-2");
                if (++count == this.lineCount) {
                    break;
                }
                this.writer.newLine();
            }
        }
    }

    private void convertIBMGenerator() {
        DataInputStream myInput = null;
        try {
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new DataInputStream(fin);
            boolean lastMinus1 = false;
            int count = 0;
            while (myInput.available() != 0) {
                int value = this.INT_little_endian_TO_big_endian(myInput.readInt());
                if (value == -1) {
                    this.writer.write("-1 ");
                    lastMinus1 = true;
                    continue;
                }
                if (value == -2) {
                    if (!lastMinus1) {
                        this.writer.write("-1 ");
                    }
                    this.writer.write("-2 ");
                    if (++count == this.lineCount) break;
                    this.writer.newLine();
                    continue;
                }
                this.writer.write(value + " ");
                lastMinus1 = false;
            }
            myInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    int INT_little_endian_TO_big_endian(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >> 24 & 0xFF);
    }

    public Map<Integer, String> convertTEXTandReturnMap(String inputFile, String outputFile, int lineCount, Charset charset) throws IOException {
        this.input = inputFile;
        this.output = outputFile;
        this.lineCount = lineCount;
        return this.convertTEXT(true, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> convertTEXT(boolean returnMapItemIDWord, Charset charset) throws IOException {
        HashMap<Integer, String> mapItemsIDToWords = null;
        if (returnMapItemIDWord) {
            mapItemsIDToWords = new HashMap<Integer, String>();
        }
        HashMap<String, Integer> mapWordsToItemIDs = new HashMap<String, Integer>();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), charset));
        writer.write("@CONVERTED_FROM_TEXT");
        writer.newLine();
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader((InputStream)fin, charset));
            boolean isFirstWordOfSentence = true;
            boolean someSentenceHasNotEndedYet = false;
            StringBuilder currentSentence = new StringBuilder();
            int nextItemID = 1;
            while ((thisLine = myInput.readLine()) != null) {
                String[] words;
                if (thisLine.length() < 1) continue;
                for (String word : words = thisLine.split(" ")) {
                    boolean isEndOfSentence = word.endsWith("?") || word.endsWith(".") || word.endsWith("!") || word.endsWith(".") || word.endsWith("\u3002") || word.endsWith("\uff01") || word.endsWith("?");
                    String cleanWord = word.replaceAll("[^\\p{L}\\p{N}]+", "").toLowerCase();
                    if (cleanWord.length() != 0) {
                        Integer item = (Integer)mapWordsToItemIDs.get(cleanWord);
                        if (item == null) {
                            item = nextItemID++;
                            mapWordsToItemIDs.put(cleanWord, item);
                            if (mapItemsIDToWords != null) {
                                mapItemsIDToWords.put(item, cleanWord);
                            }
                            writer.write("@ITEM=" + item + "=" + cleanWord);
                            writer.newLine();
                        }
                        if (isFirstWordOfSentence) {
                            isFirstWordOfSentence = false;
                        } else {
                            currentSentence.append(" ");
                        }
                        currentSentence.append(item);
                        currentSentence.append(" -1");
                    }
                    if (!isFirstWordOfSentence && isEndOfSentence) {
                        currentSentence.append(" -2");
                        isFirstWordOfSentence = true;
                        someSentenceHasNotEndedYet = false;
                        writer.write(currentSentence.toString());
                        writer.newLine();
                        currentSentence.setLength(0);
                        continue;
                    }
                    someSentenceHasNotEndedYet = true;
                }
            }
            if (someSentenceHasNotEndedYet) {
                currentSentence.append(" -2");
                isFirstWordOfSentence = true;
                someSentenceHasNotEndedYet = false;
                writer.write(currentSentence.toString());
                currentSentence.setLength(0);
            }
            writer.close();
        }
        return mapItemsIDToWords;
    }
}

