/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_stats;

import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SequenceStatsGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(String path) throws IOException {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        int maxItem = 0;
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int i = 0;
            while ((thisLine = myInput.readLine()) != null) {
                String[] tokens = thisLine.split(" ");
                Sequence sequence = new Sequence(i++);
                ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                for (String token : tokens) {
                    if (token.codePointAt(0) == 60) continue;
                    if (token.equals("-1")) {
                        sequence.addItemset(itemset2);
                        itemset2 = new ArrayList();
                        continue;
                    }
                    if (token.equals("-2")) {
                        sequences.add(sequence);
                        continue;
                    }
                    Integer n = Integer.parseInt(token);
                    if (n >= maxItem) {
                        maxItem = n;
                    }
                    itemset2.add(n);
                }
            }
        }
        System.out.println("============  SEQUENCE DATABASE STATS ==========");
        System.out.println("Number of sequences : " + sequences.size());
        HashSet<Integer> items = new HashSet<Integer>();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        ArrayList<Integer> itemsetsizes = new ArrayList<Integer>();
        ArrayList<Integer> differentitems = new ArrayList<Integer>();
        ArrayList<Integer> appearXtimesbySequence = new ArrayList<Integer>();
        for (Sequence sequence : sequences) {
            sizes.add(sequence.size());
            HashMap<Integer, Integer> mapIntegers = new HashMap<Integer, Integer>();
            for (List<Integer> list : sequence.getItemsets()) {
                itemsetsizes.add(list.size());
                for (Integer item : list) {
                    Integer count = (Integer)mapIntegers.get(item);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    mapIntegers.put(item, count);
                    items.add(item);
                }
            }
            differentitems.add(mapIntegers.entrySet().size());
            for (Map.Entry entry : mapIntegers.entrySet()) {
                appearXtimesbySequence.add((Integer)entry.getValue());
            }
        }
        System.out.println("File " + path);
        System.out.println("Number of distinct items: " + items.size());
        System.out.println("Largest item id: " + maxItem);
        System.out.println("Average number of itemsets per sequence : " + SequenceStatsGenerator.calculateMean(sizes) + " standard deviation: " + SequenceStatsGenerator.calculateStdDeviation(sizes) + " variance: " + SequenceStatsGenerator.calculateVariance(sizes));
        System.out.println("Average number of distinct item per sequence : " + SequenceStatsGenerator.calculateMean(differentitems) + " standard deviation: " + SequenceStatsGenerator.calculateStdDeviation(differentitems) + " variance: " + SequenceStatsGenerator.calculateVariance(differentitems));
        System.out.println("Average number of occurences in a sequence for each item appearing in a sequence : " + SequenceStatsGenerator.calculateMean(appearXtimesbySequence) + " standard deviation: " + SequenceStatsGenerator.calculateStdDeviation(appearXtimesbySequence) + " variance: " + SequenceStatsGenerator.calculateVariance(appearXtimesbySequence));
        System.out.println("Average number of items per itemset : " + SequenceStatsGenerator.calculateMean(itemsetsizes) + " standard deviation: " + SequenceStatsGenerator.calculateStdDeviation(itemsetsizes) + " variance: " + SequenceStatsGenerator.calculateVariance(itemsetsizes));
        System.out.println(items.size());
    }

    private static double calculateMean(List<Integer> list) {
        double sum = 0.0;
        for (Integer val : list) {
            sum += (double)val.intValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviation(List<Integer> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateMeanD(List<Double> list) {
        double sum = 0.0;
        for (Double val : list) {
            sum += val.doubleValue();
        }
        return sum / (double)list.size();
    }

    private static double calculateStdDeviationD(List<Double> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMeanD(list);
        for (Double val : list) {
            deviation += Math.pow(mean - val, 2.0);
        }
        return Math.sqrt(deviation / (double)list.size());
    }

    private static double calculateVariance(List<Integer> list) {
        double deviation = 0.0;
        double mean = SequenceStatsGenerator.calculateMean(list);
        for (Integer val : list) {
            deviation += Math.pow(mean - (double)val.intValue(), 2.0);
        }
        return Math.pow(Math.sqrt(deviation / (double)list.size()), 2.0);
    }

    private static int calculateMinValue(List<Integer> list) {
        int min = Integer.MIN_VALUE;
        for (Integer val : list) {
            if (val > min) continue;
            min = val;
        }
        return min;
    }

    private static int calculateMaxValue(List<Integer> list) {
        int max = 0;
        for (Integer val : list) {
            if (val < max) continue;
            max = val;
        }
        return max;
    }
}

