/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.welwindow;

import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.welwindow.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PluginManager {
    public static final String DEFAULT_PLUGIN_REPOSITORY = "http://www.philippe-fournier-viger.com/spmf/plugins/";
    protected static List<Plugin> listPlugin = new ArrayList<Plugin>();
    protected static List<String> pluginNames;
    protected static List<Plugin> listInstalledPlugins;

    private PluginManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Plugin getPluginInfoFromRepository(String pluginName) {
        String url = PreferencesManager.getInstance().getRepositoryURL() + pluginName + "/info.txt";
        String param = null;
        String encodingFormat = "UTF-8";
        BufferedReader read = null;
        Plugin p = new Plugin();
        try {
            String line;
            URL realurl = new URL(url + "?" + param);
            URLConnection connection = realurl.openConnection();
            connection.connect();
            read = new BufferedReader(new InputStreamReader(connection.getInputStream(), encodingFormat));
            while ((line = read.readLine()) != null) {
                String[] splitByComma;
                if (line.indexOf("#NAME") == 0) {
                    p.setName(line.substring(7));
                }
                if (line.indexOf("#IMPLEMENTATION_AUTHOR") == 0) {
                    p.setAuthor(line.substring(23));
                }
                if (line.indexOf("#CATEGORY") == 0) {
                    p.setCategory(line.substring(10));
                }
                if (line.indexOf("#PLUGIN_VERSION") == 0) {
                    p.setVersion(line.substring(17));
                }
                if (line.indexOf("#DESCRIPTION") == 0) {
                    p.setDescription(line.substring(14));
                }
                if (line.indexOf("#URL_OF_DOCUMENTATION") == 0) {
                    p.setUrlOfDocumentation(line.substring(23));
                }
                if (line.indexOf("#INPUT_FILE_TYPES") == 0) {
                    String lineInput = line.substring(18);
                    for (String type : splitByComma = lineInput.split(",")) {
                        type = type.substring(1, type.length() - 1);
                        p.getInputFileTypes().add(type);
                    }
                }
                if (line.indexOf("#OUTPUT_FILE_TYPES") == 0) {
                    String lineOutput = line.substring(18);
                    for (String type : splitByComma = lineOutput.split(",")) {
                        type = type.substring(1, type.length() - 1);
                        p.getOutputFileTypes().add(type);
                    }
                }
                if (line.indexOf("#NUMBER_OF_PARAMETERS") == 0) {
                    int count = Integer.parseInt(line.substring(23));
                    p.setParameterCount(count);
                }
                if (line.indexOf("#PARAMETER") != 0) continue;
                int position = line.indexOf(": ");
                String substring = line.substring(position + 2);
                String[] split = substring.split("\"");
                String name = split[1];
                String example = split[3];
                String rest = split[4];
                String[] restSplit = split[4].split(", ");
                String className = restSplit[1];
                String isOptionalSring = restSplit[2];
                Class parameterType = null;
                switch (className) {
                    case "INTEGER": {
                        parameterType = Integer.class;
                        break;
                    }
                    case "BOOLEAN": {
                        parameterType = Boolean.class;
                        break;
                    }
                    case "STRING": {
                        parameterType = String.class;
                        break;
                    }
                    case "FLOAT": {
                        parameterType = String.class;
                        break;
                    }
                    case "DOUBLE": {
                        parameterType = Double.class;
                        break;
                    }
                    case "LONG": {
                        parameterType = Long.class;
                    }
                }
                boolean isOptional = Boolean.parseBoolean(isOptionalSring);
                DescriptionOfParameter parameter = new DescriptionOfParameter(name, example, parameterType, isOptional);
                p.getParameters().add(parameter);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (read != null) {
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        p.setRepositoryURL(PreferencesManager.getInstance().getRepositoryURL());
        p.setRepositoryPluginFolder(pluginName);
        return p;
    }

    public static void pluginInit() throws UnsupportedEncodingException, IOException {
        String urlPluginNames = PreferencesManager.getInstance().getRepositoryURL() + "/list_of_plugins.txt";
        pluginNames = PluginManager.getPluginNamesFromRepository(urlPluginNames, "UTF8", null);
        listPlugin.clear();
        for (String pluginName : pluginNames) {
            Plugin plugin = PluginManager.getPluginInfoFromRepository(pluginName);
            listPlugin.add(plugin);
        }
    }

    private static List<String> getPluginNamesFromRepository(String url, String encodingFormat, String param) throws UnsupportedEncodingException, IOException {
        String line;
        ArrayList<String> pluginNames = new ArrayList<String>();
        BufferedReader read = null;
        URL realurl = new URL(url + "?" + param);
        URLConnection connection = realurl.openConnection();
        connection.connect();
        read = new BufferedReader(new InputStreamReader(connection.getInputStream(), encodingFormat));
        while ((line = read.readLine()) != null) {
            if (line.length() < 1) continue;
            pluginNames.add(line);
        }
        return pluginNames;
    }

    public static boolean checkIfURLisAPluginRepository(String urlName) {
        String urlPluginNames = urlName + "/list_of_plugins.txt";
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(urlPluginNames).openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void installPlugin(Plugin plugin) {
        listInstalledPlugins.add(plugin);
        PluginManager.saveListOfInstalledPluginsToFile();
    }

    public static void updatePlugin(Plugin newPlugin) {
        for (int i = 0; i < listInstalledPlugins.size(); ++i) {
            Plugin oldPlugin = listInstalledPlugins.get(i);
            if (!oldPlugin.getName().equals(newPlugin.getName())) continue;
            listInstalledPlugins.set(i, newPlugin);
        }
        PluginManager.saveListOfInstalledPluginsToFile();
    }

    public static void removePlugin(String pluginName) {
        String filename = PluginManager.getPluginFolderPath() + File.separator + pluginName + ".jar";
        File file = new File(filename);
        file.delete();
        Iterator<Plugin> iter = listInstalledPlugins.iterator();
        while (iter.hasNext()) {
            Plugin plugin = iter.next();
            if (!plugin.getName().equals(pluginName)) continue;
            iter.remove();
        }
        PluginManager.saveListOfInstalledPluginsToFile();
    }

    public static boolean isPluginInstalled(String pluginName) {
        for (Plugin plugin : listInstalledPlugins) {
            if (!plugin.getName().equals(pluginName)) continue;
            return true;
        }
        return false;
    }

    public static File getPluginFolderPath() {
        File path = new File(System.getProperty("user.dir"));
        return path;
    }

    public static void loadListOfInstalledPluginsFromFile() {
        String path = PluginManager.getPluginFolderPath() + File.separator + "SPMFInstalledPluginsInfo.ser";
        if (new File(path).exists()) {
            try {
                FileInputStream fileInStr = new FileInputStream(path);
                ObjectInputStream objInStr = new ObjectInputStream(fileInStr);
                listInstalledPlugins = (ArrayList)objInStr.readObject();
                objInStr.close();
                fileInStr.close();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        } else {
            listInstalledPlugins = new ArrayList<Plugin>();
        }
    }

    public static void saveListOfInstalledPluginsToFile() {
        String path = PluginManager.getPluginFolderPath() + File.separator + "SPMFInstalledPluginsInfo.ser";
        try {
            FileOutputStream fileOutStr = new FileOutputStream(path);
            ObjectOutputStream objOutStr = new ObjectOutputStream(fileOutStr);
            objOutStr.writeObject(listInstalledPlugins);
            objOutStr.close();
            fileOutStr.close();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    static Plugin getPluginByNameFromList(String name) {
        for (Plugin plugin : listPlugin) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    static Plugin getInstalledPluginByNameFromList(String name) {
        for (Plugin plugin : listInstalledPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    static {
        listInstalledPlugins = null;
        PluginManager.loadListOfInstalledPluginsFromFile();
    }
}

