/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.welwindow;

import ca.pfv.spmf.gui.PreferencesManager;
import ca.pfv.spmf.welwindow.DownloadWindow;
import ca.pfv.spmf.welwindow.Plugin;
import ca.pfv.spmf.welwindow.PluginManager;
import ca.pfv.spmf.welwindow.Welcome;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class PluginWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    JButton jButton2Install;
    private JButton jButton2Update;
    private JButton jButton3Remove;
    private JButton jButton5ConnectDefault;
    private JButton jButton5Connect;
    private JLabel jLabelRemoteRepository;
    private JLabel jLabelDescription;
    private JLabel jLabelDescriptionInstalled;
    private JLabel jLabelPlugins;
    private JLabel jLabelInstalledPlugins;
    private JLabel jLabelInstalledPluginsLocalComputer;
    private JPanel jPanel1;
    JTextArea jTextAreaDescription;
    JTextArea jTextAreaDescriptionInstalled;
    DefaultTableModel tableModelPlugins;
    JTable jTablePlugins;
    private JScrollPane jScrollPane1;
    DefaultTableModel tableModelInstalledPlugins;
    JTable jTableInstalledPlugins;
    private JScrollPane jScrollPaneInstalled;

    public PluginWindow(Welcome welcome) {
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("SPMF-V.2.42c-Plugin Manager");
        this.setLocation(400, 100);
        this.setSize(975, 619);
        this.setResizable(false);
        this.jLabelRemoteRepository = new JLabel();
        this.jLabelDescription = new JLabel();
        this.jLabelDescriptionInstalled = new JLabel();
        this.jLabelPlugins = new JLabel();
        this.jLabelInstalledPlugins = new JLabel();
        this.jLabelInstalledPluginsLocalComputer = new JLabel();
        this.jButton2Install = new JButton();
        this.jButton2Install.setIcon(new ImageIcon(PluginWindow.class.getResource("ico_down.gif")));
        this.jButton2Update = new JButton();
        this.jButton2Update.setIcon(new ImageIcon(PluginWindow.class.getResource("ico_update.gif")));
        this.jButton3Remove = new JButton();
        this.jButton3Remove.setIcon(new ImageIcon(PluginWindow.class.getResource("ico_remove.gif")));
        this.jButton5Connect = new JButton();
        this.jButton5ConnectDefault = new JButton();
        this.jTextAreaDescription = new JTextArea();
        this.jTextAreaDescription.setEnabled(true);
        this.jTextAreaDescription.setEditable(false);
        this.jTextAreaDescriptionInstalled = new JTextArea();
        this.jTextAreaDescriptionInstalled.setEnabled(true);
        this.jTextAreaDescriptionInstalled.setEditable(false);
        this.jPanel1 = new JPanel();
        this.tableModelPlugins = new DefaultTableModel();
        this.tableModelPlugins.addColumn("Name");
        this.tableModelPlugins.addColumn("Author");
        this.tableModelPlugins.addColumn("Category");
        this.tableModelPlugins.addColumn("Version");
        this.tableModelPlugins.addColumn("Documentation");
        this.jTablePlugins = new JTable(this.tableModelPlugins){
            private static final long serialVersionUID = 3834308709152773954L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 4;
            }
        };
        this.jTablePlugins.setAutoCreateRowSorter(true);
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.jTablePlugins);
        this.jTablePlugins.setSelectionMode(0);
        this.jTablePlugins.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (PluginWindow.this.jTablePlugins.getSelectedRow() != -1) {
                    String pluginName = (String)PluginWindow.this.jTablePlugins.getModel().getValueAt(PluginWindow.this.jTablePlugins.getSelectedRow(), 0);
                    Plugin plugin = PluginManager.getPluginByNameFromList(pluginName);
                    PluginWindow.this.jTextAreaDescription.setText(plugin.getDescription());
                    if (PluginManager.isPluginInstalled(plugin.getName())) {
                        PluginWindow.this.jButton2Install.setEnabled(false);
                    } else {
                        PluginWindow.this.jButton2Install.setEnabled(true);
                    }
                    PluginWindow.this.jTableInstalledPlugins.clearSelection();
                } else {
                    PluginWindow.this.jButton2Install.setEnabled(false);
                    PluginWindow.this.jTextAreaDescription.setText("");
                }
            }
        });
        this.jTablePlugins.getColumnModel().getColumn(4).setCellRenderer(new TableButtonRenderer());
        this.jTablePlugins.getColumnModel().getColumn(4).setCellEditor(new TableButtonEditor(new JCheckBox()));
        this.tableModelInstalledPlugins = new DefaultTableModel();
        this.tableModelInstalledPlugins.addColumn("Name");
        this.tableModelInstalledPlugins.addColumn("Author");
        this.tableModelInstalledPlugins.addColumn("Category");
        this.tableModelInstalledPlugins.addColumn("Version");
        this.tableModelInstalledPlugins.addColumn("Documentation");
        this.jTableInstalledPlugins = new JTable(this.tableModelInstalledPlugins){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 4;
            }
        };
        this.jTableInstalledPlugins.setAutoCreateRowSorter(true);
        this.fillInstalledPluginTable();
        this.jTableInstalledPlugins.setShowGrid(false);
        this.jScrollPaneInstalled = new JScrollPane();
        this.jScrollPaneInstalled.setViewportView(this.jTableInstalledPlugins);
        this.jTableInstalledPlugins.setSelectionMode(0);
        this.jTableInstalledPlugins.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PluginWindow.this.jTableInstalledPlugins.getSelectedRow() != -1) {
                    String pluginName = (String)PluginWindow.this.jTableInstalledPlugins.getModel().getValueAt(PluginWindow.this.jTableInstalledPlugins.getSelectedRow(), 0);
                    Plugin plugin = PluginManager.getInstalledPluginByNameFromList(pluginName);
                    PluginWindow.this.jTextAreaDescriptionInstalled.setText(plugin.getDescription());
                    PluginWindow.this.jButton2Update.setEnabled(true);
                    PluginWindow.this.jButton3Remove.setEnabled(true);
                    PluginWindow.this.jTablePlugins.clearSelection();
                } else {
                    PluginWindow.this.jButton3Remove.setEnabled(false);
                    PluginWindow.this.jButton2Update.setEnabled(false);
                    PluginWindow.this.jTextAreaDescriptionInstalled.setText("");
                }
            }
        });
        this.jTableInstalledPlugins.getColumnModel().getColumn(4).setCellRenderer(new TableButtonRenderer());
        this.jTableInstalledPlugins.getColumnModel().getColumn(4).setCellEditor(new TableButtonEditor(new JCheckBox()));
        this.jLabelRemoteRepository.setText("Plugin repository: ");
        this.jLabelDescription.setText("Selected plugin description:");
        this.jLabelDescriptionInstalled.setText("Selected plugin description:");
        this.jLabelPlugins.setText("Available plugins (that have not been installed):");
        this.jLabelInstalledPlugins.setText("Installed Plugins:");
        this.jLabelInstalledPluginsLocalComputer.setText("Local computer:");
        this.jTextAreaDescription.setLineWrap(true);
        this.jTextAreaDescriptionInstalled.setLineWrap(true);
        this.jButton2Install.setText("Install");
        this.jButton2Install.setEnabled(false);
        this.jButton2Install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginWindow.this.jButtonInstallActionPerformed(evt);
            }
        });
        this.jButton2Update.setText("Update");
        this.jButton2Update.setEnabled(false);
        this.jButton2Update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginWindow.this.jButtonUpdateActionPerformed(evt);
            }
        });
        this.jButton3Remove.setText("Remove");
        this.jButton3Remove.setEnabled(false);
        this.jButton3Remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PluginWindow.this.jButton3RemoveActionPerformed(evt);
            }
        });
        this.jButton5Connect.setText("other repository");
        this.jButton5Connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean succeed = PluginWindow.this.fillPluginTable(evt, false);
                if (succeed) {
                    PluginWindow.this.jButton5Connect.setVisible(false);
                    PluginWindow.this.jButton5ConnectDefault.setVisible(false);
                }
            }
        });
        this.jButton5ConnectDefault.setText("default repository");
        this.jButton5ConnectDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean succeed = PluginWindow.this.fillPluginTable(evt, true);
                if (succeed) {
                    PluginWindow.this.jButton5Connect.setVisible(false);
                    PluginWindow.this.jButton5ConnectDefault.setVisible(false);
                }
            }
        });
        this.jButton5Connect.setSize(200, 20);
        this.jButton5Connect.setLocation(360, 20);
        this.getContentPane().add(this.jButton5Connect);
        this.jButton5ConnectDefault.setSize(200, 20);
        this.jButton5ConnectDefault.setLocation(145, 20);
        this.getContentPane().add(this.jButton5ConnectDefault);
        this.jLabelRemoteRepository.setBounds(25, 20, 180, 20);
        this.getContentPane().add(this.jLabelRemoteRepository);
        this.jLabelDescription.setBounds(760, 70, 300, 20);
        this.getContentPane().add(this.jLabelDescription);
        this.jTextAreaDescription.setSize(200, 120);
        this.jTextAreaDescription.setLocation(755, 90);
        this.getContentPane().add(this.jTextAreaDescription);
        this.jLabelDescriptionInstalled.setBounds(760, 360, 300, 20);
        this.getContentPane().add(this.jLabelDescriptionInstalled);
        this.jTextAreaDescriptionInstalled.setSize(200, 120);
        this.jTextAreaDescriptionInstalled.setLocation(755, 380);
        this.getContentPane().add(this.jTextAreaDescriptionInstalled);
        this.jLabelPlugins.setBounds(40, 50, 300, 20);
        this.getContentPane().add(this.jLabelPlugins);
        this.jScrollPane1.setSize(700, 220);
        this.jScrollPane1.setLocation(40, 75);
        this.getContentPane().add(this.jScrollPane1);
        this.jButton2Install.setSize(140, 30);
        this.jButton2Install.setLocation(315, 300);
        this.getContentPane().add(this.jButton2Install);
        this.jLabelInstalledPluginsLocalComputer.setBounds(25, 320, 300, 20);
        this.getContentPane().add(this.jLabelInstalledPluginsLocalComputer);
        this.jLabelInstalledPlugins.setBounds(40, 340, 300, 20);
        this.getContentPane().add(this.jLabelInstalledPlugins);
        this.jScrollPaneInstalled.setSize(700, 180);
        this.jScrollPaneInstalled.setLocation(40, 360);
        this.getContentPane().add(this.jScrollPaneInstalled);
        this.jButton2Update.setSize(140, 30);
        this.jButton2Update.setLocation(410, 540);
        this.getContentPane().add(this.jButton2Update);
        this.jButton3Remove.setSize(140, 30);
        this.jButton3Remove.setLocation(260, 540);
        this.getContentPane().add(this.jButton3Remove);
        this.jLabelPlugins.setVisible(false);
        this.jScrollPane1.setVisible(false);
        this.jButton2Install.setVisible(false);
        this.jLabelDescription.setVisible(false);
        this.jTextAreaDescription.setVisible(false);
        this.getContentPane().add(this.jPanel1);
        this.setVisible(true);
    }

    void fillPluginTable() {
        try {
            PluginManager.pluginInit();
            if (this.tableModelPlugins.getRowCount() > 0) {
                int rowCount = this.tableModelPlugins.getRowCount();
                for (int i = rowCount - 1; i >= 0; --i) {
                    this.tableModelPlugins.removeRow(i);
                }
            }
            ArrayList<Plugin> notInstalledYet = new ArrayList<Plugin>();
            for (Plugin plugin : PluginManager.listPlugin) {
                if (PluginManager.isPluginInstalled(plugin.getName())) continue;
                notInstalledYet.add(plugin);
            }
            for (int i = 0; i < notInstalledYet.size(); ++i) {
                Object[] object = new Object[]{((Plugin)notInstalledYet.get(i)).getName(), ((Plugin)notInstalledYet.get(i)).getAuthor(), ((Plugin)notInstalledYet.get(i)).getCategory(), ((Plugin)notInstalledYet.get(i)).getVersion(), "Webpage"};
                this.tableModelPlugins.addRow(object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Network error : " + e.getMessage());
        }
    }

    void fillInstalledPluginTable() {
        for (int i = 0; i < PluginManager.listInstalledPlugins.size(); ++i) {
            Object[] object = new Object[]{PluginManager.listInstalledPlugins.get(i).getName(), PluginManager.listInstalledPlugins.get(i).getAuthor(), PluginManager.listInstalledPlugins.get(i).getCategory(), PluginManager.listInstalledPlugins.get(i).getVersion(), "Webpage"};
            this.tableModelInstalledPlugins.addRow(object);
        }
    }

    private void jButtonInstallActionPerformed(ActionEvent evt) {
        new DownloadWindow(PluginManager.getPluginFolderPath().getAbsolutePath(), false, this).setVisible(true);
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        new DownloadWindow(PluginManager.getPluginFolderPath().getAbsolutePath(), true, this).setVisible(true);
        this.jButton3Remove.setEnabled(false);
        this.jButton2Update.setEnabled(false);
    }

    private void jButton3RemoveActionPerformed(ActionEvent evt) {
        try {
            String pluginName = (String)this.jTableInstalledPlugins.getModel().getValueAt(this.jTableInstalledPlugins.getSelectedRow(), 0);
            PluginManager.removePlugin(pluginName);
            this.jButton3Remove.setEnabled(false);
            this.jButton2Update.setEnabled(false);
            this.tableModelInstalledPlugins.removeRow(this.jTableInstalledPlugins.getSelectedRow());
            Plugin pluginFromRepository = PluginManager.getPluginByNameFromList(pluginName);
            if (pluginFromRepository != null) {
                Object[] object = new Object[]{pluginFromRepository.getName(), pluginFromRepository.getAuthor(), pluginFromRepository.getCategory(), pluginFromRepository.getVersion(), "Webpage"};
                this.tableModelPlugins.addRow(object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage());
        }
    }

    private void jButton4WebpageActionPerformed(ActionEvent evt) {
        String pluginName = (String)this.jTablePlugins.getModel().getValueAt(this.jTablePlugins.getSelectedRow(), 0);
        Plugin plugin = PluginManager.getPluginByNameFromList(pluginName);
        String url2 = plugin.getUrlOfDocumentation();
        if (Desktop.isDesktopSupported()) {
            try {
                URI uri = URI.create(url2);
                Desktop dp = Desktop.getDesktop();
                if (dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(uri);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Null!");
        }
    }

    private boolean fillPluginTable(ActionEvent evt, boolean connectToDefault) {
        String choice = !connectToDefault ? JOptionPane.showInputDialog(this, "Enter the URL of a plugin repository.", "http://www.philippe-fournier-viger.com/spmf/plugins/") : "http://www.philippe-fournier-viger.com/spmf/plugins/";
        if (choice != null) {
            boolean isARepository = PluginManager.checkIfURLisAPluginRepository(choice);
            if (isARepository) {
                PreferencesManager.getInstance().setRepositoryURL(choice);
                this.fillPluginTable();
                this.jLabelPlugins.setVisible(true);
                this.jScrollPane1.setVisible(true);
                this.jButton2Install.setVisible(true);
                this.jLabelDescription.setVisible(true);
                this.jTextAreaDescription.setVisible(true);
                this.jButton5Connect.setEnabled(false);
                this.jButton5ConnectDefault.setEnabled(false);
                return true;
            }
            JOptionPane.showMessageDialog(this, "Cannot establish connection!");
            return false;
        }
        return false;
    }

    class TableButtonRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 2276033826743007852L;

        public TableButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.black);
            this.setBackground(UIManager.getColor("Button.background"));
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public class TableButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        private String label;
        private boolean clicked;
        private int row;
        private int col;
        private JTable table;

        public TableButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.table = table;
            this.row = row;
            this.col = column;
            this.button.setForeground(Color.black);
            this.button.setBackground(UIManager.getColor("Button.background"));
            this.label = value == null ? "" : value.toString();
            this.button.setText(this.label);
            this.clicked = true;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.clicked) {
                String pluginName = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 0);
                Plugin plugin = null;
                if (this.table == PluginWindow.this.jTablePlugins) {
                    plugin = PluginManager.getPluginByNameFromList(pluginName);
                } else if (this.table == PluginWindow.this.jTableInstalledPlugins) {
                    plugin = PluginManager.getInstalledPluginByNameFromList(pluginName);
                }
                String url2 = plugin.getUrlOfDocumentation();
                if (Desktop.isDesktopSupported()) {
                    try {
                        URI uri = URI.create(url2);
                        Desktop dp = Desktop.getDesktop();
                        if (dp.isSupported(Desktop.Action.BROWSE)) {
                            dp.browse(uri);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("Null!");
                }
            }
            this.clicked = false;
            return new String(this.label);
        }

        @Override
        public boolean stopCellEditing() {
            this.clicked = false;
            return super.stopCellEditing();
        }
    }
}

