/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres;

import com.clarkparsia.owlgres.DLLAnnotation;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.query.QueryAnnotationVisitor;
import com.clarkparsia.owlgres.util.TermFactory;

public class DLLAnnotationLiteral
extends DLLAnnotation {
    private String value;
    private Datatype datatype;
    private String language;
    private DLLLiteral literal;

    public DLLAnnotationLiteral(DLLLiteral literal) {
        this.literal = literal;
        this.value = literal.getValue();
    }

    public DLLAnnotationLiteral(String value) {
        this.value = value;
        this.literal = TermFactory.literal(value);
    }

    public DLLAnnotationLiteral(String value, Datatype datatype) {
        this.value = value;
        this.datatype = datatype;
        this.literal = TermFactory.literal(value, datatype);
    }

    public DLLAnnotationLiteral(String value, String language) {
        this(value);
        this.language = language;
        this.literal = TermFactory.literal(value, language);
    }

    public String getValue() {
        return this.value;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getLanguage() {
        return this.language;
    }

    public DLLLiteral getLiteral() {
        return this.literal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\"" + this.value + "\"");
        if (this.datatype != null) {
            buf.append("^^<" + this.datatype.getURI().toASCIIString() + ">");
        } else if (this.language != null) {
            buf.append("@" + this.language);
        }
        return buf.toString();
    }

    public void accept(QueryAnnotationVisitor v) {
        v.visit(this);
    }
}

