/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres;

import com.clarkparsia.owlgres.DLLContext;
import com.clarkparsia.owlgres.abox.DLLABox;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.optimize.QueryOptimizer;
import com.clarkparsia.owlgres.query.AnnotationReformulator;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Reformulator;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.QueryFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLLKB {
    public static final Log log = LogFactory.getLog(DLLKB.class);
    protected DLLABox abox;
    private Reformulator queryReformulator;
    private QueryOptimizer queryOptimizer;
    private AnnotationReformulator annotationReformulator;
    private DLLTBox tbox;

    public DLLKB(Store store) {
        if (store == null) {
            throw new NullPointerException();
        }
        this.tbox = new DLLTBox();
        this.abox = new DLLABox(store);
    }

    public void addAssertions(Collection<? extends DLLABoxAssertion> assertions) {
        this.abox.addAssertions(assertions);
    }

    public void addAssertions(DLLABoxAssertion ... assertions) {
        this.addAssertions(Arrays.asList(assertions));
    }

    public DLLTBox getTBox() {
        return this.tbox;
    }

    public void setTBox(DLLTBox tbox) {
        this.tbox = tbox;
    }

    public DLLABox getABox() {
        return this.abox;
    }

    public boolean isConsistent() {
        this.tbox.prepare();
        for (Map.Entry<DLLBasicConcept, Set<DLLBasicConcept>> e : this.tbox.getNegativeInclusions().entrySet()) {
            DLLBasicConcept lft = e.getKey();
            Variable x = QueryFactory.distVar("x");
            for (DLLBasicConcept rgt : e.getValue()) {
                ConjunctiveQuery q = QueryFactory.reformulateQuery(QueryFactory.atom(lft, x), QueryFactory.atom(rgt, x));
                QueryResultSet result = this.query(q, Collections.singleton(x));
                if (result.isEmpty()) continue;
                log.debug((Object)("Inconsistent : " + q + " " + result.next().get(x)));
                return false;
            }
        }
        return true;
    }

    public QueryResultSet query(ConjunctiveQuery query) {
        return this.query(query, query.getDistinguishedVars());
    }

    public QueryResultSet query(Query query) {
        return this.query(query, query.getDistinguishedVars());
    }

    public QueryResultSet query(ConjunctiveQuery query, Collection<Variable> resultVars) {
        return this.query(new Query(query), resultVars);
    }

    public QueryResultSet query(Query query, Collection<Variable> resultVars) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (resultVars == null) {
            throw new NullPointerException();
        }
        if (this.queryReformulator == null) {
            this.queryReformulator = new Reformulator();
        }
        if (this.queryOptimizer == null) {
            this.queryOptimizer = new QueryOptimizer(this.tbox);
        }
        if (this.annotationReformulator == null) {
            this.annotationReformulator = new AnnotationReformulator();
        }
        QueryResultSet ret = new QueryResultSet();
        Set<ConjunctiveQuery> optimized = null;
        ConjunctiveQuery conjunctiveQuery = query.getConjunctiveQuery();
        Set<ConjunctiveQuery> reformulated = this.queryReformulator.reformulate(this.tbox, conjunctiveQuery);
        log.debug((Object)("Query reformulation produced " + reformulated.size() + " queries"));
        if (DLLContext.optimize()) {
            optimized = this.queryOptimizer.optimize(reformulated);
            log.debug((Object)("Optimization reduced the set to " + optimized.size() + " queries"));
        } else {
            optimized = reformulated;
        }
        Set<ConjunctiveQuery> checked = this.annotationReformulator.reformulate(optimized);
        query.setReformulatedQueries(checked);
        query.setConstantAnnotationRoleAtoms(this.annotationReformulator.getExpandedAnnotationRoleAtoms());
        if (optimized.size() > 0) {
            ret = this.abox.query(query, resultVars);
        }
        return ret;
    }
}

