/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.abox;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLLABox {
    private StoreBase store;
    private WeakHashMap<String, DLLIndividual> uriToIndividual;

    public DLLABox(Store store) {
        if (store == null) {
            throw new NullPointerException();
        }
        this.store = (StoreBase)store;
        this.uriToIndividual = new WeakHashMap();
    }

    public void addAssertion(DLLABoxAssertion assertion) {
        if (assertion == null) {
            throw new NullPointerException();
        }
        this.store.addAssertions(Collections.singleton(assertion));
    }

    public void addAssertions(Collection<? extends DLLABoxAssertion> assertions) {
        if (assertions == null) {
            throw new NullPointerException();
        }
        this.store.addAssertions(assertions);
    }

    public DLLIndividual getIndividual(String name) {
        DLLIndividual ret = this.uriToIndividual.get(name);
        if (ret == null) {
            ret = new DLLIndividual(name);
            this.uriToIndividual.put(name, ret);
        }
        return ret;
    }

    public boolean isConsistent() {
        throw new UnsupportedOperationException("DLLABox.isConsitent not supported. Use DLLKB.isConsistent()");
    }

    public QueryResultSet query(Query query, Collection<Variable> resultVars) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (resultVars == null) {
            throw new NullPointerException();
        }
        return this.store.query(query, resultVars);
    }

    public long size() {
        return this.store.sizeABox();
    }

    public void clear() {
        this.store.clearABox();
    }
}

