/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.optimize;

import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuxiliaryRoleOptimizer {
    private DLLTBox tbox;
    private AuxiliaryRoleDetector optimizer;
    public static final Log log = LogFactory.getLog(AuxiliaryRoleOptimizer.class);

    public AuxiliaryRoleOptimizer(DLLTBox tbox) {
        this.tbox = tbox;
        this.optimizer = new AuxiliaryRoleDetector();
    }

    public Set<ConjunctiveQuery> optimize(Set<ConjunctiveQuery> qs) {
        int drops = 0;
        HashSet<ConjunctiveQuery> ret = new HashSet<ConjunctiveQuery>();
        for (ConjunctiveQuery q : qs) {
            if (this.hasAuxiliaryRole(q)) {
                ++drops;
                log.debug((Object)("Drop query with auxiliary role: " + q));
                continue;
            }
            ret.add(q);
        }
        if (drops > 0) {
            log.debug((Object)("Number of queries with auxiliary role: " + drops));
        }
        return ret;
    }

    private boolean hasAuxiliaryRole(ConjunctiveQuery q) {
        return this.optimizer.hasAuxiliaryRole(q);
    }

    private class AuxiliaryRoleDetector
    implements QueryAtomVisitor {
        boolean hasAuxiliaryRole;

        private AuxiliaryRoleDetector() {
        }

        public boolean hasAuxiliaryRole(ConjunctiveQuery q) {
            this.hasAuxiliaryRole = false;
            for (QueryAtom atom : q.getAtoms()) {
                atom.accept(this);
            }
            return this.hasAuxiliaryRole;
        }

        public void visit(AtomicAtom a) {
        }

        public void visit(ObjectRoleAtom a) {
            a.getRole().accept(new AuxiliaryObjectRoleDetector());
        }

        public void visit(DataRoleAtom a) {
        }

        public void visit(NegatedAtom a) {
            a.accept(this);
        }

        public void visit(AnnotationRoleAtom a) {
        }

        private class AuxiliaryObjectRoleDetector
        implements DLLObjectRoleVisitor {
            private AuxiliaryObjectRoleDetector() {
            }

            public void visit(DLLBasicObjectRole r) {
                if (AuxiliaryRoleOptimizer.this.tbox.getObjectRole(r.getName()).isAuxiliary()) {
                    AuxiliaryRoleDetector.this.hasAuxiliaryRole = true;
                    log.debug((Object)("Detected auxiliary role: " + r));
                }
            }

            public void visit(DLLInverseObjectRole r) {
                if (AuxiliaryRoleOptimizer.this.tbox.getObjectRole(r.getBasicRole().getName()).isAuxiliary()) {
                    AuxiliaryRoleDetector.this.hasAuxiliaryRole = true;
                    log.debug((Object)("Detected auxiliary role: " + r));
                }
            }
        }
    }
}

