/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.optimize;

import com.clarkparsia.owlgres.DLLNamedEntity;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectivityOptimizer {
    private StatisticsHandler statistics;
    private ZeroSelectivityDetector optimizer;
    public static final Log log = LogFactory.getLog(SelectivityOptimizer.class);

    public SelectivityOptimizer(DLLTBox tbox) {
        this.statistics = tbox.getStatisticsHandler();
        this.optimizer = new ZeroSelectivityDetector();
    }

    public Set<ConjunctiveQuery> optimize(Set<ConjunctiveQuery> qs) {
        int drops = 0;
        HashSet<ConjunctiveQuery> ret = new HashSet<ConjunctiveQuery>();
        for (ConjunctiveQuery q : qs) {
            if (this.hasZeroSelectivity(q)) {
                ++drops;
                log.debug((Object)("Drop query with zero selectivity: " + q));
                continue;
            }
            ret.add(q);
        }
        if (drops > 0) {
            log.debug((Object)("Number of queries with zero selectivity: " + drops));
        }
        return ret;
    }

    private boolean hasZeroSelectivity(ConjunctiveQuery q) {
        return this.optimizer.hasZeroSelectivity(q);
    }

    private class ZeroSelectivityDetector
    implements QueryAtomVisitor {
        boolean hasZeroSelectivity;

        private ZeroSelectivityDetector() {
        }

        public boolean hasZeroSelectivity(ConjunctiveQuery q) {
            this.hasZeroSelectivity = false;
            for (QueryAtom atom : q.getAtoms()) {
                atom.accept(this);
            }
            return this.hasZeroSelectivity;
        }

        public void visit(AtomicAtom a) {
            this.check(a.getAtomic());
        }

        public void visit(ObjectRoleAtom a) {
            this.check(a.getRole());
        }

        public void visit(DataRoleAtom a) {
            this.check(a.getRole());
        }

        public void visit(AnnotationRoleAtom a) {
            this.check(a.getRole());
        }

        public void visit(NegatedAtom a) {
            a.accept(this);
        }

        private void check(DLLNamedEntity e) {
            if (SelectivityOptimizer.this.statistics.hasZeroSelectivity(e)) {
                this.hasZeroSelectivity = true;
                log.debug((Object)("Detected zero selectivity atom with named entity: " + e));
            }
        }
    }
}

