/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.DLLAnnotationIndividual;
import com.clarkparsia.owlgres.DLLAnnotationLiteral;
import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAnnotationVisitor;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividualVisitor;
import com.clarkparsia.owlgres.query.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationReformulator {
    public static final Log log = LogFactory.getLog(AnnotationReformulator.class);
    private Set<ConjunctiveQuery> baseAnnotationRoleAtoms;
    private Set<ConjunctiveQuery> expandedAnnotationRoleAtoms;
    private Set<AnnotationRoleAtom> expand;
    private Set<QueryAtom> rest;

    public Set<ConjunctiveQuery> reformulate(Set<ConjunctiveQuery> scq) {
        Set<ConjunctiveQuery> ret = scq;
        this.baseAnnotationRoleAtoms = new HashSet<ConjunctiveQuery>();
        this.expandedAnnotationRoleAtoms = new HashSet<ConjunctiveQuery>();
        this.expand = new HashSet<AnnotationRoleAtom>();
        this.rest = new HashSet<QueryAtom>();
        for (ConjunctiveQuery cq : scq) {
            log.debug((Object)("Check annotation atoms in conjunctive query: " + cq));
            for (QueryAtom qa : cq.getAtoms()) {
                log.debug((Object)("Check if query atom is an annotation atom: " + qa));
                qa.accept(new AnnotationAtomVisitor(cq));
            }
            this.baseAnnotationRoleAtoms.add(cq);
            this.expandedAnnotationRoleAtoms.addAll(this.expand(this.expand, this.rest));
        }
        log.debug((Object)("CQs with base annotation role atoms: " + this.baseAnnotationRoleAtoms));
        log.debug((Object)("CQs with expanded annotation role atoms: " + this.expandedAnnotationRoleAtoms));
        return ret;
    }

    public Set<ConjunctiveQuery> getBaseAnnotationRoleAtoms() {
        return this.baseAnnotationRoleAtoms;
    }

    public Set<ConjunctiveQuery> getExpandedAnnotationRoleAtoms() {
        return this.expandedAnnotationRoleAtoms;
    }

    private Set<ConjunctiveQuery> expand(Set<AnnotationRoleAtom> expand, Set<QueryAtom> rest) {
        HashSet<ConjunctiveQuery> ret = new HashSet<ConjunctiveQuery>();
        int length = expand.size();
        ArrayList<AnnotationRoleAtom> annotationList = new ArrayList<AnnotationRoleAtom>();
        annotationList.addAll(expand);
        int i = 1;
        while (true) {
            Double d = new Double(length);
            if (!((double)i < Math.pow(2.0, d))) break;
            String binary = this.intToBinary(i, length);
            ConjunctiveQuery cq = new ConjunctiveQuery(rest);
            for (int j = 0; j < binary.length(); ++j) {
                AnnotationRoleAtom a = ((AnnotationRoleAtom)annotationList.get(j)).copy();
                if (binary.charAt(j) == '1') {
                    a.setIsConstant();
                } else {
                    a.setIsObject();
                }
                cq.add(a);
            }
            ret.add(cq);
            ++i;
        }
        return ret;
    }

    private String intToBinary(int i, int length) {
        String binary = Integer.toBinaryString(i);
        StringBuffer leading = new StringBuffer();
        for (int j = 0; j < length - binary.length(); ++j) {
            leading.append("0");
        }
        return leading.toString() + binary;
    }

    private class SubjectAtomVisitor
    implements QueryAtomVisitor {
        private boolean match = false;
        private Variable objectVariable;

        public SubjectAtomVisitor(Variable objectVariable) {
            this.objectVariable = objectVariable;
        }

        public boolean match() {
            return this.match;
        }

        public void visit(AnnotationRoleAtom a) {
        }

        public void visit(AtomicAtom a) {
            a.getIndividual().accept(new CheckIndividual(a, this.objectVariable));
        }

        public void visit(ObjectRoleAtom a) {
            a.getSubject().accept(new CheckIndividual(a, this.objectVariable));
        }

        public void visit(DataRoleAtom a) {
            a.getIndividual().accept(new CheckIndividual(a, this.objectVariable));
        }

        public void visit(NegatedAtom a) {
            a.accept(this);
        }

        private class CheckIndividual
        implements QueryIndividualVisitor {
            private QueryAtom atom;
            private Variable objectVariable;

            public CheckIndividual(QueryAtom atom, Variable objectVariable) {
                this.atom = atom;
                this.objectVariable = objectVariable;
            }

            public void visit(Variable v) {
                if (v.equals(this.objectVariable)) {
                    SubjectAtomVisitor.this.match = true;
                }
                log.debug((Object)("Object variable " + this.objectVariable + " of the untyped annotation atom matches subject variable of atom " + this.atom));
            }

            public void visit(DLLIndividual i) {
            }
        }
    }

    private class AnnotationAtomVisitor
    implements QueryAtomVisitor {
        private ConjunctiveQuery conjunctiveQuery;
        private Variable objectVariable;

        public AnnotationAtomVisitor(ConjunctiveQuery cq) {
            this.conjunctiveQuery = cq;
        }

        public void visit(AnnotationRoleAtom a) {
            if (!a.isObject() && !a.isConstant()) {
                a.getObject().accept(new QueryAnnotationVisitor(){

                    public void visit(Variable v) {
                        AnnotationAtomVisitor.this.objectVariable = v;
                    }

                    public void visit(DLLAnnotationIndividual i) {
                    }

                    public void visit(DLLAnnotationLiteral l) {
                    }
                });
                log.debug((Object)("Found untyped annotation atom " + a + " with object variable " + this.objectVariable));
                if (this.isJoined()) {
                    a.setIsObject();
                    AnnotationReformulator.this.rest.add(a);
                    log.debug((Object)("Mark untyped annotation atom " + a + " to be of type object (" + a.isObject() + ")"));
                } else {
                    AnnotationReformulator.this.expand.add(a.copy());
                    a.setIsObject();
                }
            } else {
                AnnotationReformulator.this.rest.add(a);
            }
        }

        public void visit(AtomicAtom a) {
            AnnotationReformulator.this.rest.add(a);
        }

        public void visit(ObjectRoleAtom a) {
            AnnotationReformulator.this.rest.add(a);
        }

        public void visit(DataRoleAtom a) {
            AnnotationReformulator.this.rest.add(a);
        }

        public void visit(NegatedAtom a) {
            AnnotationReformulator.this.rest.add(a);
        }

        private boolean isJoined() {
            for (QueryAtom qa : this.conjunctiveQuery.getAtoms(this.objectVariable)) {
                SubjectAtomVisitor visitor = new SubjectAtomVisitor(this.objectVariable);
                qa.accept(visitor);
                if (!visitor.match()) continue;
                return true;
            }
            return false;
        }
    }
}

