/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividualVisitor;
import com.clarkparsia.owlgres.query.QueryLiteralVisitor;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.util.QueryFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConjunctiveQuery {
    private Set<QueryAtom> atoms;
    private VariableCollector collector;
    private Set<Variable> distVars;
    private Set<Variable> nonDistVars;
    private Map<Variable, Set<QueryAtom>> varAtom;

    public ConjunctiveQuery(Collection<QueryAtom> atoms) {
        if (atoms == null) {
            throw new NullPointerException();
        }
        this.atoms = new HashSet<QueryAtom>(atoms.size());
        this.varAtom = new HashMap<Variable, Set<QueryAtom>>();
        this.distVars = new HashSet<Variable>();
        this.nonDistVars = new HashSet<Variable>();
        this.collector = new VariableCollector();
        for (QueryAtom a : atoms) {
            this.add(a);
        }
    }

    private ConjunctiveQuery(ConjunctiveQuery conjunctiveQuery) {
        this(conjunctiveQuery.getAtoms());
    }

    public ConjunctiveQuery(QueryAtom ... atoms) {
        this(Arrays.asList(atoms));
    }

    public void add(QueryAtom a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.atoms.add(a);
        Set<Variable> vs = this.collector.getVariables(a);
        for (Variable v : vs) {
            if (v.isDistinguished()) {
                this.distVars.add(v);
            } else {
                this.nonDistVars.add(v);
            }
            Set<QueryAtom> existing = this.varAtom.get(v);
            if (existing == null) {
                existing = new HashSet<QueryAtom>();
                this.varAtom.put(v, existing);
            }
            existing.add(a);
        }
    }

    public boolean contains(QueryAtom a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return this.atoms.contains(a);
    }

    public ConjunctiveQuery copy() {
        return new ConjunctiveQuery(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConjunctiveQuery) {
            ConjunctiveQuery other = (ConjunctiveQuery)obj;
            return ((Object)this.atoms).equals(other.getAtoms());
        }
        return false;
    }

    public Set<QueryAtom> getAtoms() {
        return Collections.unmodifiableSet(this.atoms);
    }

    public boolean hasAtoms() {
        return this.atoms.size() > 0;
    }

    public Set<QueryAtom> getAtoms(Variable v) {
        if (v == null) {
            throw new NullPointerException();
        }
        Set<QueryAtom> ret = this.varAtom.get(v);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<Variable> getDistinguishedVars() {
        return Collections.unmodifiableSet(this.distVars);
    }

    public Set<Variable> getNonDistinguishedVars() {
        return Collections.unmodifiableSet(this.nonDistVars);
    }

    public Set<Variable> getVars() {
        return Collections.unmodifiableSet(this.varAtom.keySet());
    }

    public int hashCode() {
        return ((Object)this.atoms).hashCode();
    }

    public boolean isBound(Variable v) {
        if (v.isDistinguished()) {
            return true;
        }
        if (v.equals(QueryFactory.theExistentialVar())) {
            return false;
        }
        Set<QueryAtom> atoms = this.varAtom.get(v);
        return atoms != null && atoms.size() > 1;
    }

    public boolean remove(QueryAtom a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return this.atoms.remove(a);
    }

    public String toString() {
        return this.atoms.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariableCollector
    implements QueryAtomVisitor,
    QueryIndividualVisitor,
    QueryLiteralVisitor {
        private Set<Variable> variables;

        private VariableCollector() {
        }

        public Set<Variable> getVariables(QueryAtom a) {
            this.variables = new HashSet<Variable>();
            a.accept(this);
            return this.variables;
        }

        @Override
        public void visit(AtomicAtom a) {
            a.getIndividual().accept(this);
        }

        @Override
        public void visit(DataRoleAtom a) {
            a.getIndividual().accept(this);
            a.getValue().accept(this);
        }

        @Override
        public void visit(DLLIndividual i) {
        }

        @Override
        public void visit(DLLLiteral l) {
        }

        @Override
        public void visit(DLLTypedLiteral l) {
        }

        @Override
        public void visit(DLLPlainLiteral l) {
        }

        @Override
        public void visit(NegatedAtom a) {
            a.getAtom().accept(this);
        }

        @Override
        public void visit(ObjectRoleAtom a) {
            a.getSubject().accept(this);
            a.getObject().accept(this);
        }

        @Override
        public void visit(Variable v) {
            this.variables.add(v);
        }

        @Override
        public void visit(AnnotationRoleAtom a) {
        }
    }
}

