/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.Constraint;
import com.clarkparsia.owlgres.query.OrderCondition;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private long limit = Long.MIN_VALUE;
    private long offset = Long.MIN_VALUE;
    private boolean distinct = false;
    private List<OrderCondition> orderBy = new ArrayList<OrderCondition>();
    private Set<Constraint> constraints = new HashSet<Constraint>();
    private ConjunctiveQuery reformulate;
    private Set<ConjunctiveQuery> reformulated;
    private Set<ConjunctiveQuery> constantAnnotationRoleAtoms;

    private Query(Query q) {
        this.limit = q.getLimit();
        this.offset = q.getOffset();
        this.distinct = q.isDistinct();
        this.orderBy = q.getOrderBy();
        this.reformulate = q.getConjunctiveQuery();
        this.reformulated = q.getReformulatedQueries();
        this.constraints = q.getConstraints();
    }

    public Query(Collection<QueryAtom> atoms) {
        this.reformulate = new ConjunctiveQuery(atoms);
    }

    public Query(ConjunctiveQuery reformulatedQuery) {
        this.reformulate = reformulatedQuery;
    }

    public Query(QueryAtom ... atoms) {
        this(Arrays.asList(atoms));
    }

    public ConjunctiveQuery getConjunctiveQuery() {
        return this.reformulate;
    }

    public Set<ConjunctiveQuery> getReformulatedQueries() {
        return this.reformulated;
    }

    public void setReformulatedQueries(Set<ConjunctiveQuery> reformulated) {
        this.reformulated = reformulated;
    }

    public Set<ConjunctiveQuery> getConstantAnnotationRoleAtoms() {
        return this.constantAnnotationRoleAtoms;
    }

    public void setConstantAnnotationRoleAtoms(Set<ConjunctiveQuery> constantAnnotationRoleAtoms) {
        this.constantAnnotationRoleAtoms = constantAnnotationRoleAtoms;
    }

    public void add(QueryAtom a) {
        this.reformulate.add(a);
    }

    public boolean contains(QueryAtom a) {
        return this.reformulate.contains(a);
    }

    public Set<Variable> getDistinguishedVars() {
        return this.reformulate.getDistinguishedVars();
    }

    public Set<Variable> getNonDistinguishedVars() {
        return this.reformulate.getNonDistinguishedVars();
    }

    public Set<Variable> getVars() {
        return this.reformulate.getVars();
    }

    public boolean isBound(Variable v) {
        return this.reformulate.isBound(v);
    }

    public Set<QueryAtom> getAtoms() {
        return this.reformulate.getAtoms();
    }

    public Set<QueryAtom> getAtoms(Variable v) {
        return this.reformulate.getAtoms(v);
    }

    public boolean equals(Object o) {
        Query other;
        return o instanceof Query && (other = (Query)o).getConjunctiveQuery().equals(this.reformulate) && other.getLimit() == this.limit && other.isDistinct() == this.distinct && ((Object)other.getOrderBy()).equals(this.orderBy) && other.getOffset() == this.offset && ((Object)other.getConstraints()).equals(this.constraints);
    }

    public Query copy() {
        return new Query(this);
    }

    public boolean remove(QueryAtom a) {
        return this.reformulate.remove(a);
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setOrderBy(List<OrderCondition> orderBy) {
        this.orderBy = orderBy;
    }

    public List<OrderCondition> getOrderBy() {
        return this.orderBy;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }
}

