/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.query.QuerySolution;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.util.TermFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultSet {
    private Map<Variable, String> variables;
    private Iterator<QuerySolution> iterator;
    private List<QuerySolution> solutions;
    public static final Log log = LogFactory.getLog(QueryResultSet.class);

    public QueryResultSet() {
        this.solutions = new ArrayList<QuerySolution>();
        this.iterator = this.solutions.iterator();
    }

    public QueryResultSet(ResultSet rs, Map<Variable, String> variables, Set<Variable> individuals) {
        this.variables = variables;
        this.solutions = new ArrayList<QuerySolution>();
        int count = 0;
        try {
            while (rs.next()) {
                QuerySolution solution = new QuerySolution();
                for (Map.Entry<Variable, String> entry : variables.entrySet()) {
                    boolean validURL;
                    Variable v = entry.getKey();
                    if (!v.isDistinguished()) continue;
                    String sqlV = entry.getValue();
                    String binding = rs.getString(sqlV);
                    try {
                        new URL(binding);
                        validURL = true;
                    }
                    catch (MalformedURLException e) {
                        validURL = false;
                    }
                    if (individuals.contains(v) && validURL) {
                        solution.add(v, TermFactory.individual(binding));
                        continue;
                    }
                    solution.add(v, TermFactory.literal(binding));
                }
                this.solutions.add(solution);
                ++count;
            }
            rs.close();
            log.debug((Object)("Result set size: " + count));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.iterator = this.solutions.iterator();
    }

    public Set<Variable> getVariables() {
        return this.variables.keySet();
    }

    public List<String> getColums() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Variable var : this.getVariables()) {
            columns.add(var.toString());
        }
        return columns;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public boolean isEmpty() {
        return this.solutions.isEmpty();
    }

    public QuerySolution next() {
        return this.iterator.next();
    }

    public int size() {
        return this.solutions.size();
    }
}

