/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.DLLContext;
import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLBasicConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLDataExistential;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryIndividualVisitor;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.query.QueryLiteralVisitor;
import com.clarkparsia.owlgres.query.Simplifier;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.QueryFactory;
import com.clarkparsia.owlgres.util.QueryUtils;
import com.clarkparsia.owlgres.util.ReformulateQueryPrinter;
import com.clarkparsia.owlgres.util.TermFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reformulator {
    private static QueryIndividualCaster individualCaster = new QueryIndividualCaster();
    private static QueryLiteralCaster literalCaster = new QueryLiteralCaster();
    public static final Log log = LogFactory.getLog(Reformulator.class);

    private static Variable asVariable(QueryIndividual i) {
        return individualCaster.asVariable(i);
    }

    private static DLLIndividual asIndividual(QueryIndividual i) {
        return individualCaster.asIndividual(i);
    }

    private static Variable asVariable(QueryLiteral l) {
        return literalCaster.asVariable(l);
    }

    private static DLLLiteral asLiteral(QueryLiteral l) {
        return literalCaster.asLiteral(l);
    }

    public Set<ConjunctiveQuery> reformulate(DLLTBox tbox, ConjunctiveQuery input) {
        QueryRewriter rewriter = new QueryRewriter(tbox);
        Simplifier simplifier = new Simplifier();
        HashSet<ConjunctiveQuery> current = new HashSet<ConjunctiveQuery>();
        input = QueryUtils.replaceAllUnbound(input);
        if (DLLContext.optimize()) {
            input = simplifier.simplify(tbox, input);
        }
        log.debug((Object)("Reformulating query: " + ReformulateQueryPrinter.toString(input)));
        current.add(input);
        boolean changed = true;
        while (changed) {
            HashSet<ConjunctiveQuery> reformulated = new HashSet<ConjunctiveQuery>();
            reformulated.addAll(current);
            for (ConjunctiveQuery q : current) {
                Set<ConjunctiveQuery> qs = rewriter.process(q);
                reformulated.addAll(qs);
            }
            if (log.isDebugEnabled()) {
                HashSet newQ = new HashSet(reformulated);
                newQ.removeAll(current);
                log.debug((Object)("Rewriting with TBox inclusions produced " + newQ.size() + " add'l queries"));
                for (ConjunctiveQuery q : newQ) {
                    log.debug((Object)("Additional query: " + ReformulateQueryPrinter.toString(q)));
                }
            }
            HashSet<ConjunctiveQuery> next = new HashSet<ConjunctiveQuery>();
            for (ConjunctiveQuery q : reformulated) {
                next.add(simplifier.simplify(tbox, q));
            }
            boolean bl = changed = !((Object)current).equals(next);
            if (changed && log.isDebugEnabled()) {
                log.debug((Object)("New query set: " + next));
            }
            current = next;
        }
        return current;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryRewriter
    implements QueryAtomVisitor {
        private ConjunctiveQuery q;
        private List<QueryAtom> replaceList;
        private DLLTBox tbox;

        public QueryRewriter(DLLTBox tbox) {
            this.tbox = tbox;
        }

        public Set<ConjunctiveQuery> process(ConjunctiveQuery q) {
            this.q = q;
            HashSet<ConjunctiveQuery> ret = new HashSet<ConjunctiveQuery>();
            for (QueryAtom g : q.getAtoms()) {
                this.replaceList = new ArrayList<QueryAtom>();
                g.accept(this);
                for (QueryAtom gr : this.replaceList) {
                    ret.add(QueryUtils.replaceAtom(q, g, gr));
                }
            }
            this.replaceList = null;
            return ret;
        }

        @Override
        public void visit(AtomicAtom a) {
            final QueryIndividual i = a.getIndividual();
            Set<DLLBasicConcept> subs = this.tbox.getReverseInclusions(a.getAtomic());
            for (DLLBasicConcept sub : subs) {
                sub.accept(new DLLBasicConceptVisitor(){

                    public void visit(DLLAtomic c) {
                        QueryRewriter.this.replaceList.add(QueryFactory.atom(c, i));
                    }

                    public void visit(DLLDataExistential c) {
                        QueryRewriter.this.replaceList.add(QueryFactory.atom(c.getRole(), i, QueryFactory.theExistentialVar()));
                    }

                    public void visit(DLLObjectExistential c) {
                        c.getRole().accept(new DLLObjectRoleVisitor(){

                            public void visit(DLLBasicObjectRole r) {
                                QueryRewriter.this.replaceList.add(QueryFactory.atom(r, i, QueryFactory.theExistentialVar()));
                            }

                            public void visit(DLLInverseObjectRole r) {
                                QueryRewriter.this.replaceList.add(QueryFactory.atom(r.getBasicRole(), (QueryIndividual)QueryFactory.theExistentialVar(), i));
                            }
                        });
                    }
                });
            }
        }

        @Override
        public void visit(DataRoleAtom a) {
            Variable s;
            DLLDataRole role = a.getRole();
            final QueryIndividual subject = a.getIndividual();
            QueryLiteral object = a.getValue();
            Set<DLLDataRole> subs = this.tbox.getReverseInclusions(role);
            for (DLLDataRole sub : subs) {
                this.replaceList.add(QueryFactory.atom(sub, subject, object));
            }
            Variable o = Reformulator.asVariable(object);
            if (o != null && !this.q.isBound(o)) {
                Set<DLLBasicConcept> subs2 = this.tbox.getReverseInclusions(TermFactory.existential(role));
                for (DLLBasicConcept sub : subs2) {
                    sub.accept(new DLLBasicConceptVisitor(){

                        public void visit(DLLAtomic c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c, subject));
                        }

                        public void visit(DLLDataExistential c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c.getRole(), subject, QueryFactory.theExistentialVar()));
                        }

                        public void visit(DLLObjectExistential c) {
                            c.getRole().accept(new DLLObjectRoleVisitor(){

                                public void visit(DLLBasicObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r, subject, QueryFactory.theExistentialVar()));
                                }

                                public void visit(DLLInverseObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r.getBasicRole(), (QueryIndividual)QueryFactory.theExistentialVar(), subject));
                                }
                            });
                        }
                    });
                }
            }
            if ((s = Reformulator.asVariable(subject)) != null && !this.q.isBound(s)) {
                throw new UnsupportedOperationException();
            }
        }

        @Override
        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(ObjectRoleAtom a) {
            Variable s;
            Set<DLLBasicConcept> subs;
            DLLBasicObjectRole role = a.getRole();
            final QueryIndividual subject = a.getSubject();
            final QueryIndividual object = a.getObject();
            Set<DLLObjectRole> subs2 = this.tbox.getReverseInclusions(role);
            for (DLLObjectRole sub : subs2) {
                this.replaceList.add(QueryFactory.atom(sub, subject, object));
            }
            Variable o = Reformulator.asVariable(object);
            if (o != null && !this.q.isBound(o)) {
                subs = this.tbox.getReverseInclusions(TermFactory.existential(role));
                for (DLLBasicConcept sub : subs) {
                    sub.accept(new DLLBasicConceptVisitor(){

                        public void visit(DLLAtomic c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c, subject));
                        }

                        public void visit(DLLDataExistential c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c.getRole(), subject, QueryFactory.theExistentialVar()));
                        }

                        public void visit(DLLObjectExistential c) {
                            c.getRole().accept(new DLLObjectRoleVisitor(){

                                public void visit(DLLBasicObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r, subject, QueryFactory.theExistentialVar()));
                                }

                                public void visit(DLLInverseObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r.getBasicRole(), (QueryIndividual)QueryFactory.theExistentialVar(), subject));
                                }
                            });
                        }
                    });
                }
            }
            if ((s = Reformulator.asVariable(subject)) != null && !this.q.isBound(s)) {
                subs = this.tbox.getReverseInclusions(TermFactory.existential(TermFactory.inverseOf(role)));
                for (DLLBasicConcept sub : subs) {
                    sub.accept(new DLLBasicConceptVisitor(){

                        public void visit(DLLAtomic c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c, object));
                        }

                        public void visit(DLLDataExistential c) {
                            QueryRewriter.this.replaceList.add(QueryFactory.atom(c.getRole(), object, QueryFactory.theExistentialVar()));
                        }

                        public void visit(DLLObjectExistential c) {
                            c.getRole().accept(new DLLObjectRoleVisitor(){

                                public void visit(DLLBasicObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r, object, QueryFactory.theExistentialVar()));
                                }

                                public void visit(DLLInverseObjectRole r) {
                                    QueryRewriter.this.replaceList.add(QueryFactory.atom(r.getBasicRole(), (QueryIndividual)QueryFactory.theExistentialVar(), object));
                                }
                            });
                        }
                    });
                }
            }
        }

        @Override
        public void visit(AnnotationRoleAtom a) {
        }
    }

    private static class QueryLiteralCaster
    implements QueryLiteralVisitor {
        private DLLLiteral l;
        private Variable v;

        private QueryLiteralCaster() {
        }

        public DLLLiteral asLiteral(QueryLiteral l) {
            this.l = null;
            l.accept(this);
            return this.l;
        }

        public Variable asVariable(QueryLiteral l) {
            this.v = null;
            l.accept(this);
            return this.v;
        }

        public void visit(DLLLiteral l) {
            this.l = l;
        }

        public void visit(Variable v) {
            this.v = v;
        }

        public void visit(DLLPlainLiteral l) {
            this.l = l;
        }

        public void visit(DLLTypedLiteral l) {
            this.l = l;
        }
    }

    private static class QueryIndividualCaster
    implements QueryIndividualVisitor {
        private DLLIndividual i;
        private Variable v;

        private QueryIndividualCaster() {
        }

        public DLLIndividual asIndividual(QueryIndividual i) {
            this.i = null;
            i.accept(this);
            return this.i;
        }

        public Variable asVariable(QueryIndividual i) {
            this.v = null;
            i.accept(this);
            return this.v;
        }

        public void visit(DLLIndividual i) {
            this.i = i;
        }

        public void visit(Variable v) {
            this.v = v;
        }
    }
}

