/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.query;

import com.clarkparsia.owlgres.DLLContext;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLBasicConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLDataExistential;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.QueryFactory;
import com.clarkparsia.owlgres.util.QueryUtils;
import com.clarkparsia.owlgres.util.TermFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simplifier {
    private AtomicOnlyFilter atomicFilter = new AtomicOnlyFilter();
    private DomainSimplifier domainSimplifier = new DomainSimplifier();
    private RangeSimplifier rangeSimplifier = new RangeSimplifier();
    private AtomReducer atomReducer = new AtomReducer();
    public static final Log log = LogFactory.getLog(Simplifier.class);

    private Set<DLLAtomic> getAtomicSupers(DLLTBox tbox, DLLBasicConcept c) {
        HashSet<DLLBasicConcept> supers = new HashSet<DLLBasicConcept>();
        Set<DLLBasicConcept> current = tbox.getPositiveInclusions(c);
        while (supers.addAll(current)) {
            current = new HashSet<DLLBasicConcept>();
            for (DLLBasicConcept sup : supers) {
                current.addAll(tbox.getPositiveInclusions(sup));
            }
        }
        Set<DLLAtomic> atomics = this.atomicFilter.filter(supers);
        return atomics;
    }

    public ConjunctiveQuery simplify(DLLTBox tbox, ConjunctiveQuery q) {
        ConjunctiveQuery initial;
        log.debug((Object)("Attempting to simplify query: " + q));
        ConjunctiveQuery simplified = q;
        do {
            initial = simplified;
            if (!DLLContext.optimize()) continue;
            simplified = this.domainSimplifier.simplify(tbox, simplified);
            simplified = this.rangeSimplifier.simplify(tbox, simplified);
        } while (!(simplified = this.atomReducer.simplify(simplified)).equals(initial));
        if (log.isDebugEnabled() && !simplified.equals(q)) {
            log.debug((Object)("Simplified query: " + simplified));
        }
        return simplified;
    }

    private class AtomReducer
    implements QueryAtomVisitor {
        private QueryIndividual subject;
        private QueryIndividual object;
        private QueryLiteral value;
        private DLLAtomic atomic;
        private DLLBasicObjectRole objectRole;
        private DLLDataRole dataRole;
        private boolean first;
        private AtomType firstType;
        private ConjunctiveQuery output;
        private ConjunctiveQuery input;
        private QueryAtom firstAtom;

        private AtomReducer() {
        }

        public ConjunctiveQuery simplify(ConjunctiveQuery q) {
            boolean change;
            this.output = q;
            do {
                change = false;
                this.input = this.output;
                QueryAtom[] atoms = this.input.getAtoms().toArray(new QueryAtom[0]);
                for (int i = 0; i < atoms.length - 1 && !change; ++i) {
                    for (int j = i + 1; j < atoms.length && !change; ++j) {
                        this.firstAtom = atoms[i];
                        this.first = true;
                        atoms[i].accept(this);
                        this.first = false;
                        atoms[j].accept(this);
                        this.output = QueryUtils.replaceAllUnbound(this.output);
                        change = !this.output.equals(this.input);
                    }
                }
            } while (change);
            return this.output;
        }

        public void visit(AtomicAtom a) {
            if (this.first) {
                this.firstType = AtomType.CONCEPT;
                this.atomic = a.getAtomic();
                this.subject = a.getIndividual();
            } else if (this.firstType == AtomType.CONCEPT && this.atomic.equals(a.getAtomic())) {
                if (this.subject.equals(QueryFactory.theExistentialVar())) {
                    this.output = QueryUtils.replaceAtom(this.input, this.firstAtom, a);
                } else if (a.getIndividual().equals(QueryFactory.theExistentialVar())) {
                    this.output = QueryUtils.replaceAtom(this.input, a, this.firstAtom);
                }
            }
        }

        public void visit(DataRoleAtom a) {
            if (this.first) {
                this.firstType = AtomType.DATA;
                this.dataRole = a.getRole();
                this.subject = a.getIndividual();
                this.value = a.getValue();
            } else if (this.firstType == AtomType.DATA && this.dataRole.equals(a.getRole())) {
                QueryIndividual secondInd = a.getIndividual();
                QueryLiteral secondValue = a.getValue();
                if (this.subject.equals(QueryFactory.theExistentialVar())) {
                    if (this.value.equals(QueryFactory.theExistentialVar()) || secondValue.equals(this.value)) {
                        this.output = QueryUtils.replaceAtom(this.input, this.firstAtom, a);
                    }
                } else if (this.subject.equals(secondInd)) {
                    if (this.value.equals(QueryFactory.theExistentialVar())) {
                        this.output = QueryUtils.replaceAtom(this.input, this.firstAtom, a);
                    } else if (secondValue.equals(QueryFactory.theExistentialVar())) {
                        this.output = QueryUtils.replaceAtom(this.input, a, this.firstAtom);
                    }
                } else if (secondInd.equals(QueryFactory.theExistentialVar()) && (secondValue.equals(QueryFactory.theExistentialVar()) || secondValue.equals(this.value))) {
                    this.output = QueryUtils.replaceAtom(this.input, a, this.firstAtom);
                }
            }
        }

        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        public void visit(ObjectRoleAtom a) {
            if (this.first) {
                this.firstType = AtomType.OBJECT;
                this.objectRole = a.getRole();
                this.subject = a.getSubject();
                this.object = a.getObject();
            } else if (this.firstType == AtomType.OBJECT && this.objectRole.equals(a.getRole())) {
                QueryIndividual secondSubj = a.getSubject();
                QueryIndividual secondObj = a.getObject();
                if (this.subject.equals(QueryFactory.theExistentialVar())) {
                    if (this.object.equals(QueryFactory.theExistentialVar()) || secondObj.equals(this.object)) {
                        this.output = QueryUtils.replaceAtom(this.input, this.firstAtom, a);
                    }
                } else if (this.subject.equals(secondSubj)) {
                    if (this.object.equals(QueryFactory.theExistentialVar())) {
                        this.output = QueryUtils.replaceAtom(this.input, this.firstAtom, a);
                    } else if (secondObj.equals(QueryFactory.theExistentialVar())) {
                        this.output = QueryUtils.replaceAtom(this.input, a, this.firstAtom);
                    }
                } else if (secondSubj.equals(QueryFactory.theExistentialVar()) && (secondObj.equals(QueryFactory.theExistentialVar()) || secondObj.equals(this.object))) {
                    this.output = QueryUtils.replaceAtom(this.input, a, this.firstAtom);
                }
            }
        }

        public void visit(AnnotationRoleAtom a) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AtomType {
        CONCEPT,
        DATA,
        OBJECT;

    }

    private class RangeSimplifier
    implements QueryAtomVisitor {
        private ConjunctiveQuery q;
        private DLLTBox tbox;

        private RangeSimplifier() {
        }

        public ConjunctiveQuery simplify(DLLTBox tbox, ConjunctiveQuery q) {
            QueryAtom[] view;
            this.tbox = tbox;
            this.q = q.copy();
            for (QueryAtom a : view = q.getAtoms().toArray(new QueryAtom[0])) {
                a.accept(this);
            }
            return QueryUtils.replaceAllUnbound(this.q);
        }

        public void visit(AtomicAtom a) {
        }

        public void visit(DataRoleAtom a) {
        }

        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        public void visit(ObjectRoleAtom a) {
            Set rangeSupers = Simplifier.this.getAtomicSupers(this.tbox, TermFactory.existential(TermFactory.inverseOf(a.getRole())));
            for (DLLAtomic atomic : rangeSupers) {
                this.q.remove(QueryFactory.atom(atomic, a.getObject()));
            }
        }

        public void visit(AnnotationRoleAtom a) {
        }
    }

    private class DomainSimplifier
    implements QueryAtomVisitor {
        private ConjunctiveQuery q;
        private DLLTBox tbox;

        private DomainSimplifier() {
        }

        public ConjunctiveQuery simplify(DLLTBox tbox, ConjunctiveQuery q) {
            QueryAtom[] view;
            this.tbox = tbox;
            this.q = q.copy();
            for (QueryAtom a : view = q.getAtoms().toArray(new QueryAtom[0])) {
                a.accept(this);
            }
            return QueryUtils.replaceAllUnbound(this.q);
        }

        public void visit(AtomicAtom a) {
        }

        public void visit(DataRoleAtom a) {
            Set domainSupers = Simplifier.this.getAtomicSupers(this.tbox, TermFactory.existential(a.getRole()));
            for (DLLAtomic atomic : domainSupers) {
                this.q.remove(QueryFactory.atom(atomic, a.getIndividual()));
            }
        }

        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        public void visit(ObjectRoleAtom a) {
            Set domainSupers = Simplifier.this.getAtomicSupers(this.tbox, TermFactory.existential(a.getRole()));
            for (DLLAtomic atomic : domainSupers) {
                this.q.remove(QueryFactory.atom(atomic, a.getSubject()));
            }
        }

        public void visit(AnnotationRoleAtom a) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AtomicOnlyFilter
    implements DLLBasicConceptVisitor {
        private Set<DLLAtomic> atomics;

        private AtomicOnlyFilter() {
        }

        public Set<DLLAtomic> filter(Set<DLLBasicConcept> concepts) {
            this.atomics = new HashSet<DLLAtomic>();
            for (DLLBasicConcept c : concepts) {
                c.accept(this);
            }
            return this.atomics;
        }

        @Override
        public void visit(DLLAtomic c) {
            this.atomics.add(c);
        }

        @Override
        public void visit(DLLDataExistential c) {
        }

        @Override
        public void visit(DLLObjectExistential c) {
        }
    }
}

