/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection;

import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.DatabaseType;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.StoreFormatter;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilder;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StoreConnection {
    public void connect();

    public Connection getSQLConnection();

    public DatabaseType getDatabaseType();

    public String getUrl();

    public String getHost();

    public String getDb();

    public String getUser();

    public String getPassword();

    public String getDriverClassName();

    public StoreFormatter getStoreFormatter();

    public ABoxAdditionProcessor getABoxAdditionProcessor();

    public SQLQueryBuilder getSQLQueryBuilder(Query var1, Collection<Variable> var2, Store var3);

    public void execute(String var1);

    public PreparedStatement prepareStatement(String var1);

    public Statement createStatement();

    public void clear();

    public void clearTBox();

    public void clearABox();

    public long sizeABox();

    public void close();

    public void dropIfExists(String var1);

    public void createTBoxRelations();

    public void createABoxRelations();

    public int addConceptAssertion(Integer var1, Integer var2);

    public int addObjectRoleAssertion(Integer var1, Integer var2, Integer var3);

    public int addDataRoleAssertion(Integer var1, Integer var2, String var3, String var4, String var5);

    public int addObjectAnnotationAssertion(Integer var1, Integer var2, Integer var3);

    public int addConstantAnnotationAssertion(Integer var1, Integer var2, String var3, String var4, String var5);

    public void beginTransaction();

    public void endTransaction();

    public void rollbackTransaction();

    public QueryResultSet query(Query var1, Collection<Variable> var2, Store var3);

    public void updateStatistics(Store var1);
}

