/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection;

import com.clarkparsia.owlgres.store.DatabaseType;
import com.clarkparsia.owlgres.store.StoreUnsupportedException;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionDerby;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionDerbySameAs;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionPostgreSQL;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionPostgreSQLSameAs;

public class StoreConnectionFactory {
    public static StoreConnection connect(DatabaseType databaseType, String host, String db, String user, String password) {
        if (databaseType.equals(DatabaseType.PostgreSQL)) {
            return StoreConnectionFactory.connectPostgreSQL(host, db, user, password);
        }
        if (databaseType.equals(DatabaseType.PostgreSQLSameAs)) {
            return StoreConnectionFactory.connectSameAsPostgreSQL(host, db, user, password);
        }
        if (databaseType.equals(DatabaseType.Derby)) {
            return StoreConnectionFactory.connectDerby(host, db, user, password);
        }
        if (databaseType.equals(DatabaseType.DerbySameAs)) {
            return StoreConnectionFactory.connectDerbySameAs(host, db, user, password);
        }
        throw new StoreUnsupportedException(databaseType);
    }

    private static StoreConnection connectPostgreSQL(String host, String db, String user, String password) {
        StoreConnectionPostgreSQL storeConnection = new StoreConnectionPostgreSQL(host, db, user, password);
        storeConnection.connect();
        return storeConnection;
    }

    private static StoreConnection connectSameAsPostgreSQL(String host, String db, String user, String password) {
        StoreConnectionPostgreSQLSameAs storeConnection = new StoreConnectionPostgreSQLSameAs(host, db, user, password);
        storeConnection.connect();
        return storeConnection;
    }

    private static StoreConnection connectDerby(String host, String db, String user, String password) {
        StoreConnectionDerby storeConnection = new StoreConnectionDerby(host, db, user, password);
        storeConnection.connect();
        return storeConnection;
    }

    private static StoreConnection connectDerbySameAs(String host, String db, String user, String password) {
        StoreConnectionDerbySameAs storeConnection = new StoreConnectionDerbySameAs(host, db, user, password);
        storeConnection.connect();
        return storeConnection;
    }
}

