/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.DLLAnnotationIndividual;
import com.clarkparsia.owlgres.DLLAnnotationLiteral;
import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.OrderCondition;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryAnnotation;
import com.clarkparsia.owlgres.query.QueryAnnotationVisitor;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryIndividualVisitor;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.query.QueryLiteralVisitor;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.impl.InclusionIdConverter;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryBuilder {
    protected StoreBase store;
    protected Query query;
    protected Set<ConjunctiveQuery> queries;
    protected Collection<Variable> resultVars;
    protected Set<Variable> individualNameAttributes;
    protected Map<Variable, String> varToSqlVar;
    protected Map<Variable, String> nameRelationAliases;
    protected long limit;
    protected long offset;
    protected boolean distinct;
    protected List<OrderCondition> orderBy;
    protected Set<String> sql;
    protected Set<SQLSingleQueryBuilder> unionSql;
    protected String INDIVIDUAL_NAME;
    protected String INDIVIDUAL_ID;

    public SQLQueryBuilder(Query query, Collection<Variable> resultVars, Store store) {
        this.query = query;
        this.queries = query.getReformulatedQueries();
        this.resultVars = new ArrayList<Variable>(resultVars);
        this.store = (StoreBase)store;
        if (this.queries == null) {
            throw new NullPointerException("Access KB.query() not ABox.query(), the KB does the reformulation");
        }
        this.sql = new HashSet<String>();
        this.varToSqlVar = new HashMap<Variable, String>();
        this.nameRelationAliases = new HashMap<Variable, String>();
        this.individualNameAttributes = new HashSet<Variable>();
        this.unionSql = new HashSet<SQLSingleQueryBuilder>();
        this.limit = query.getLimit();
        this.offset = query.getOffset();
        this.distinct = query.isDistinct();
        this.orderBy = query.getOrderBy();
        this.INDIVIDUAL_NAME = ".name";
        this.INDIVIDUAL_ID = ".id";
        this.init();
    }

    protected void init() {
        for (ConjunctiveQuery q : this.queries) {
            SQLSingleQueryBuilder builder = new SQLSingleQueryBuilder(q, this.resultVars, this.distinct);
            this.sql.add(builder.getSQL());
            this.individualNameAttributes.addAll(builder.getIndividualNameAttributes());
            this.varToSqlVar.putAll(builder.getVariableMap());
        }
        Set<ConjunctiveQuery> constantAnnotationRoleAtoms = this.query.getConstantAnnotationRoleAtoms();
        for (ConjunctiveQuery q : constantAnnotationRoleAtoms) {
            this.unionSql.add(new SQLSingleQueryBuilder(q, this.resultVars, this.distinct));
        }
    }

    public Set<Variable> getIndividualNameAttributes() {
        return this.individualNameAttributes;
    }

    public String getSQL() {
        boolean first = true;
        boolean subSelect = false;
        StringBuffer ret = new StringBuffer();
        if (this.individualNameAttributes.size() > 0) {
            first = true;
            subSelect = true;
            ret.append("SELECT ");
            if (this.distinct) {
                ret.append("DISTINCT ");
            }
            for (Variable v : this.varToSqlVar.keySet()) {
                if (!first) {
                    ret.append(", ");
                }
                first = false;
                if (this.individualNameAttributes.contains(v)) {
                    ret.append(this.getNameTableAlias(v) + this.INDIVIDUAL_NAME + " AS ");
                }
                ret.append(this.varToSqlVar.get(v));
            }
            ret.append("\nFROM (\n");
        }
        first = true;
        for (String s : this.sql) {
            if (!first) {
                ret.append("\nUNION \n");
            }
            ret.append(s);
            first = false;
        }
        if (subSelect) {
            first = true;
            ret.append("\n) as innerRel ");
            for (Variable v : this.nameRelationAliases.keySet()) {
                ret.append(", individual_name " + this.nameRelationAliases.get(v));
            }
            ret.append("\nWHERE ");
            for (Variable v : this.individualNameAttributes) {
                if (!first) {
                    ret.append("\nAND");
                }
                first = false;
                ret.append(" innerRel." + this.varToSqlVar.get(v) + "=");
                ret.append(this.nameRelationAliases.get(v) + this.INDIVIDUAL_ID + " ");
            }
        }
        for (SQLSingleQueryBuilder builder : this.unionSql) {
            subSelect = false;
            String sql = builder.getSQL();
            Set<Variable> individualNameAttributes = builder.getIndividualNameAttributes();
            Map<Variable, String> varToSqlVar = builder.getVariableMap();
            ret.append("\nUNION\n");
            if (individualNameAttributes.size() > 0) {
                first = true;
                subSelect = true;
                ret.append("SELECT ");
                if (this.distinct) {
                    ret.append("DISTINCT ");
                }
                for (Variable v : varToSqlVar.keySet()) {
                    if (!first) {
                        ret.append(", ");
                    }
                    first = false;
                    if (individualNameAttributes.contains(v)) {
                        ret.append(this.nameRelationAliases.get(v) + this.INDIVIDUAL_NAME + " AS ");
                    }
                    ret.append(varToSqlVar.get(v));
                }
                ret.append("\nFROM (\n");
            }
            ret.append(sql);
            if (!subSelect) continue;
            first = true;
            ret.append("\n) as innerRel ");
            for (Variable v : this.nameRelationAliases.keySet()) {
                ret.append(", individual_name " + this.nameRelationAliases.get(v));
            }
            ret.append("\nWHERE ");
            for (Variable v : individualNameAttributes) {
                if (!first) {
                    ret.append("\nAND");
                }
                first = false;
                ret.append(" innerRel." + varToSqlVar.get(v) + "=");
                ret.append(this.nameRelationAliases.get(v) + this.INDIVIDUAL_ID + " ");
            }
        }
        this.appendOrderBy(ret);
        this.appendLimit(ret);
        this.appendOffset(ret);
        return ret.toString();
    }

    public void appendOrderBy(StringBuffer buf) {
        if (this.orderBy != null && this.orderBy.size() > 0) {
            buf.append("\nORDER BY ");
            boolean first = true;
            for (OrderCondition condition : this.orderBy) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(this.varToSqlVar.get(condition.getVariable()) + " " + condition.getDirection());
            }
        }
    }

    public void appendLimit(StringBuffer buf) {
        if (this.limit >= 0L) {
            buf.append("\nLIMIT " + this.limit);
        }
    }

    public void appendOffset(StringBuffer buf) {
        if (this.offset >= 0L) {
            buf.append("\nOFFSET " + this.offset);
        }
    }

    public Map<Variable, String> getVariableMap() {
        return this.varToSqlVar;
    }

    private String getNameTableAlias(Variable v) {
        String ret = "name_" + this.nameRelationAliases.size();
        this.nameRelationAliases.put(v, ret);
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SQLSingleQueryBuilder
    implements QueryAtomVisitor {
        private Collection<String> conceptAssertionTableAliases;
        private Collection<String> constraints;
        private Collection<String> dataRoleAssertionTableAliases;
        private Collection<String> objectAnnotationTableAliases;
        private Collection<String> constantAnnotationTableAliases;
        private Collection<String> nameRelationAliases;
        private ConjunctiveQuery query;
        private Collection<Variable> resultVars;
        private Collection<String> roleAssertionTableAliases;
        private InclusionIdConverter toId;
        private Map<Variable, String> varABoxId;
        private Map<Variable, String> varColumnDescriptor;
        private int varCount;
        private Map<Variable, String> varToSqlVar;
        private Set<Variable> individualNameAttributes;
        private boolean distinct;
        protected String CONCEPT;
        protected String INDIVIDUAL;
        protected String VALUE;
        protected String DATATYPE;
        protected String LANGUAGE;
        protected String DATA_ROLE;
        protected String OBJECT_ROLE;
        protected String ANNOTATION_ROLE;
        protected String INDIVIDUAL_NAME;
        protected String INDIVIDUAL_ID;
        protected String INDIVIDUAL_A;
        protected String INDIVIDUAL_B;

        protected SQLSingleQueryBuilder(ConjunctiveQuery query, Collection<Variable> resultVars, boolean distinct) {
            this.query = query;
            this.resultVars = resultVars;
            this.distinct = distinct;
            this.varCount = 0;
            this.varToSqlVar = new HashMap<Variable, String>();
            this.varABoxId = new HashMap<Variable, String>();
            this.varColumnDescriptor = new HashMap<Variable, String>();
            this.conceptAssertionTableAliases = new ArrayList<String>();
            this.nameRelationAliases = new ArrayList<String>();
            this.roleAssertionTableAliases = new ArrayList<String>();
            this.dataRoleAssertionTableAliases = new ArrayList<String>();
            this.objectAnnotationTableAliases = new ArrayList<String>();
            this.constantAnnotationTableAliases = new ArrayList<String>();
            this.toId = new InclusionIdConverter(SQLQueryBuilder.this.store);
            this.constraints = new ArrayList<String>();
            this.individualNameAttributes = new HashSet<Variable>();
            this.CONCEPT = ".concept";
            this.INDIVIDUAL = ".individual";
            this.VALUE = ".value";
            this.DATATYPE = ".datatype";
            this.LANGUAGE = ".language";
            this.DATA_ROLE = ".data_role";
            this.OBJECT_ROLE = ".object_role";
            this.ANNOTATION_ROLE = ".annotation_role";
            this.INDIVIDUAL_NAME = ".name";
            this.INDIVIDUAL_ID = ".id";
            this.INDIVIDUAL_A = ".a";
            this.INDIVIDUAL_B = ".b";
        }

        protected void addIndividualVariableBinding(Variable v, String columnDescriptor) {
            String firstDescriptor = this.varABoxId.get(v);
            if (firstDescriptor == null) {
                this.varABoxId.put(v, columnDescriptor);
            } else {
                this.constraints.add(firstDescriptor + "=" + columnDescriptor);
            }
        }

        protected void addLiteralVariableBinding(Variable v, String columnDescriptor) {
            String firstDescriptor = this.varColumnDescriptor.get(v);
            if (firstDescriptor == null) {
                this.varColumnDescriptor.put(v, columnDescriptor);
            } else {
                this.constraints.add(firstDescriptor + "=" + columnDescriptor);
            }
        }

        protected void boundNameRelationJoin(DLLIndividual individual, String joinColumnDescriptor) {
            this.boundNameRelationJoin(this.INDIVIDUAL_ID, individual, joinColumnDescriptor);
        }

        protected void boundNameRelationJoin(String attribute, DLLIndividual individual, String joinColumnDescriptor) {
            String nameRelation = this.getNameTableAlias();
            this.constraints.add(nameRelation + this.INDIVIDUAL_NAME + "='" + StringEscapeUtils.escapeSql((String)individual.toString()) + "'");
            this.constraints.add(nameRelation + attribute + "=" + joinColumnDescriptor);
        }

        protected String getConceptAssertionTableAlias() {
            String ret = "ca_" + this.conceptAssertionTableAliases.size();
            this.conceptAssertionTableAliases.add(ret);
            return ret;
        }

        protected String getDataRoleAssertionTableAlias() {
            String ret = "dra_" + this.dataRoleAssertionTableAliases.size();
            this.dataRoleAssertionTableAliases.add(ret);
            return ret;
        }

        public String getNameTableAlias() {
            String ret = "name_" + this.nameRelationAliases.size();
            this.nameRelationAliases.add(ret);
            return ret;
        }

        public Set<Variable> getIndividualNameAttributes() {
            return this.individualNameAttributes;
        }

        private String getObjectRoleAssertionTableAlias() {
            String ret = "ora_" + this.roleAssertionTableAliases.size();
            this.roleAssertionTableAliases.add(ret);
            return ret;
        }

        private String getObjectAnnotationAssertionTableAlias() {
            String ret = "oaa_" + this.objectAnnotationTableAliases.size();
            this.objectAnnotationTableAliases.add(ret);
            return ret;
        }

        private String getConstantAnnotationAssertionTableAlias() {
            String ret = "caa_" + this.constantAnnotationTableAliases.size();
            this.constantAnnotationTableAliases.add(ret);
            return ret;
        }

        public String getSQL() {
            for (QueryAtom a : this.query.getAtoms()) {
                a.accept(this);
            }
            StringBuffer buf = new StringBuffer("SELECT ");
            if (this.distinct) {
                buf.append("DISTINCT ");
            }
            boolean first = true;
            for (Variable v : this.resultVars) {
                String columnDescriptor = this.varColumnDescriptor.get(v);
                if (columnDescriptor == null && this.varABoxId.containsKey(v)) {
                    columnDescriptor = this.variableNameRelationJoin(v);
                }
                if (columnDescriptor == null) {
                    throw new RuntimeException("Result variable with no binding: " + v);
                }
                String alias = this.sqlNameFor(v);
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(columnDescriptor);
                buf.append(" AS ");
                buf.append(alias);
            }
            buf.append("\nFROM ");
            first = true;
            for (String a : this.conceptAssertionTableAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" concept_assertion ");
                buf.append(a);
            }
            for (String a : this.roleAssertionTableAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" object_role_assertion ");
                buf.append(a);
            }
            for (String a : this.dataRoleAssertionTableAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" data_role_assertion ");
                buf.append(a);
            }
            for (String a : this.nameRelationAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" individual_name ");
                buf.append(a);
            }
            for (String a : this.constantAnnotationTableAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" annotation_to_literal ");
                buf.append(a);
            }
            for (String a : this.objectAnnotationTableAliases) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(" annotation_to_resource ");
                buf.append(a);
            }
            buf.append("\nWHERE ");
            first = true;
            for (String s : this.constraints) {
                if (!first) {
                    buf.append("\nAND ");
                } else {
                    first = false;
                }
                buf.append(s);
            }
            return buf.toString();
        }

        public Map<Variable, String> getVariableMap() {
            return this.varToSqlVar;
        }

        protected String sqlNameFor(Variable v) {
            assert (!v.isDistinguished()) : "Non-distinguished var shouldn't be named in SQL";
            String name = this.varToSqlVar.get(v);
            if (name == null) {
                name = "x" + ++this.varCount;
                this.varToSqlVar.put(v, name);
            }
            return name;
        }

        protected String variableNameRelationJoin(Variable v) {
            String columnDescriptor = this.varABoxId.get(v);
            assert (columnDescriptor != null) : "Attempt to join for name on unbound variable";
            this.individualNameAttributes.add(v);
            return columnDescriptor;
        }

        @Override
        public void visit(AtomicAtom a) {
            DLLAtomic c = a.getAtomic();
            QueryIndividual i = a.getIndividual();
            Integer cId = this.toId.getId(c);
            String conceptRelation = this.getConceptAssertionTableAlias();
            this.constraints.add(conceptRelation + this.CONCEPT + "=" + cId);
            final String individualId = conceptRelation + this.INDIVIDUAL;
            i.accept(new QueryIndividualVisitor(){

                public void visit(DLLIndividual i) {
                    SQLSingleQueryBuilder.this.boundNameRelationJoin(i, individualId);
                }

                public void visit(Variable v) {
                    if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                        SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, individualId);
                    }
                }
            });
        }

        @Override
        public void visit(DataRoleAtom a) {
            DLLDataRole r = a.getRole();
            QueryIndividual s = a.getIndividual();
            QueryLiteral o = a.getValue();
            Integer rId = this.toId.getId(r);
            String roleRelation = this.getDataRoleAssertionTableAlias();
            final String individualId = roleRelation + this.INDIVIDUAL;
            final String literalValueCol = roleRelation + this.VALUE;
            final String literalDatatypeCol = roleRelation + this.DATATYPE;
            final String literalLanguageCol = roleRelation + this.LANGUAGE;
            this.constraints.add(roleRelation + this.DATA_ROLE + "=" + rId);
            s.accept(new QueryIndividualVisitor(){

                public void visit(DLLIndividual i) {
                    SQLSingleQueryBuilder.this.boundNameRelationJoin(i, individualId);
                }

                public void visit(Variable v) {
                    if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                        SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, individualId);
                    }
                }
            });
            o.accept(new QueryLiteralVisitor(){

                public void visit(DLLLiteral l) {
                    SQLSingleQueryBuilder.this.constraints.add(literalValueCol + "='" + StringEscapeUtils.escapeSql((String)l.getValue()) + "'");
                }

                public void visit(DLLPlainLiteral l) {
                    String language = l.getLanguage();
                    SQLSingleQueryBuilder.this.constraints.add(literalValueCol + "='" + StringEscapeUtils.escapeSql((String)l.getValue()) + "'");
                    if (language.length() > 0) {
                        SQLSingleQueryBuilder.this.constraints.add(literalLanguageCol + "='" + language + "'");
                    }
                }

                public void visit(DLLTypedLiteral l) {
                    String type = l.getDatatype().getURI().toASCIIString();
                    SQLSingleQueryBuilder.this.constraints.add(literalValueCol + "='" + StringEscapeUtils.escapeSql((String)l.getValue()) + "'");
                    SQLSingleQueryBuilder.this.constraints.add(literalDatatypeCol + "='" + type + "'");
                }

                public void visit(Variable v) {
                    if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                        SQLSingleQueryBuilder.this.addLiteralVariableBinding(v, literalValueCol);
                    }
                }
            });
        }

        @Override
        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(ObjectRoleAtom a) {
            DLLBasicObjectRole r = a.getRole();
            QueryIndividual s = a.getSubject();
            QueryIndividual o = a.getObject();
            Integer rId = this.toId.getId(r);
            String roleRelation = this.getObjectRoleAssertionTableAlias();
            this.constraints.add(roleRelation + this.OBJECT_ROLE + "=" + rId);
            final String subjectId = roleRelation + this.INDIVIDUAL_A;
            final String objectId = roleRelation + this.INDIVIDUAL_B;
            s.accept(new QueryIndividualVisitor(){

                public void visit(DLLIndividual i) {
                    SQLSingleQueryBuilder.this.boundNameRelationJoin(i, subjectId);
                }

                public void visit(Variable v) {
                    if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                        SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, subjectId);
                    }
                }
            });
            o.accept(new QueryIndividualVisitor(){

                public void visit(DLLIndividual i) {
                    SQLSingleQueryBuilder.this.boundNameRelationJoin(i, objectId);
                }

                public void visit(Variable v) {
                    if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                        SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, objectId);
                    }
                }
            });
        }

        @Override
        public void visit(AnnotationRoleAtom a) {
            String languageId;
            String datatypeId;
            String objectId;
            String subjectId;
            boolean isObject = false;
            boolean isConstant = false;
            DLLAnnotationRoleBase r = a.getRole();
            QueryIndividual s = a.getSubject();
            QueryAnnotation o = a.getObject();
            Integer rId = this.toId.getId(r);
            if (a.isObject()) {
                isObject = true;
                String roleRelation = this.getObjectAnnotationAssertionTableAlias();
                this.constraints.add(roleRelation + this.ANNOTATION_ROLE + "=" + rId);
                subjectId = roleRelation + ".a";
                objectId = roleRelation + ".b";
                datatypeId = null;
                languageId = null;
            } else if (a.isConstant()) {
                isConstant = true;
                String roleRelation = this.getConstantAnnotationAssertionTableAlias();
                this.constraints.add(roleRelation + this.ANNOTATION_ROLE + "=" + rId);
                subjectId = roleRelation + ".individual";
                objectId = roleRelation + ".value";
                datatypeId = roleRelation + ".datatype";
                languageId = roleRelation + ".language";
            } else {
                throw new RuntimeException("Error on identifying the role type (object or constant) of the annotation role atom: " + a);
            }
            s.accept(new SubjectVisitor(subjectId));
            o.accept(new ObjectVisitor(objectId, languageId, datatypeId, isObject, isConstant));
        }

        private class ObjectVisitor
        implements QueryAnnotationVisitor {
            private String objectId;
            private String languageId;
            private String datatypeId;
            private boolean isObject;
            private boolean isConstant;

            public ObjectVisitor(String objectId, String languageId, String datatypeId, boolean isObject, boolean isConstant) {
                this.objectId = objectId;
                this.languageId = languageId;
                this.datatypeId = datatypeId;
                this.isObject = isObject;
                this.isConstant = isConstant;
            }

            public void visit(DLLAnnotationIndividual i) {
                SQLSingleQueryBuilder.this.boundNameRelationJoin(i.getIndividual(), this.objectId);
            }

            public void visit(DLLAnnotationLiteral l) {
                l.getLiteral().accept(new QueryLiteralVisitor(){

                    public void visit(DLLLiteral l) {
                        SQLSingleQueryBuilder.this.constraints.add(ObjectVisitor.this.objectId + "='" + StringEscapeUtils.escapeSql((String)l.getValue()) + "'");
                    }

                    public void visit(DLLPlainLiteral l) {
                        String language = l.getLanguage();
                        if (language.length() > 0) {
                            SQLSingleQueryBuilder.this.constraints.add(ObjectVisitor.this.languageId + "='" + language + "'");
                        }
                    }

                    public void visit(DLLTypedLiteral l) {
                        String type = l.getDatatype().getURI().toASCIIString();
                        SQLSingleQueryBuilder.this.constraints.add(ObjectVisitor.this.datatypeId + "='" + type + "'");
                    }

                    public void visit(Variable v) {
                        if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                            SQLSingleQueryBuilder.this.addLiteralVariableBinding(v, ObjectVisitor.this.objectId);
                        }
                    }
                });
            }

            public void visit(Variable v) {
                if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                    if (this.isObject) {
                        SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, this.objectId);
                    } else if (this.isConstant) {
                        SQLSingleQueryBuilder.this.addLiteralVariableBinding(v, this.objectId);
                    }
                }
            }
        }

        private class SubjectVisitor
        implements QueryIndividualVisitor {
            private String subjectId;

            public SubjectVisitor(String subjectId) {
                this.subjectId = subjectId;
            }

            public void visit(DLLIndividual i) {
                SQLSingleQueryBuilder.this.boundNameRelationJoin(".id", i, this.subjectId);
            }

            public void visit(Variable v) {
                if (SQLSingleQueryBuilder.this.query.isBound(v)) {
                    SQLSingleQueryBuilder.this.addIndividualVariableBinding(v, this.subjectId);
                }
            }
        }
    }
}

