/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.DLLNamedEntity;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.role.DLLAnnotationRole;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.StoreFormatter;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilder;
import com.clarkparsia.owlgres.store.formatter.impl.StoreFormatterImpl;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessor;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreConnectionBase
implements StoreConnection {
    protected String host;
    protected String db;
    protected String user;
    protected String password;
    protected Connection connection;
    protected StoreFormatter formatter;
    protected ABoxAdditionProcessor additionProcessor;
    public static final Log log = LogFactory.getLog(StoreConnectionBase.class);

    public StoreConnectionBase(String host, String db, String user, String password) {
        if (host == null) {
            host = "localhost";
        }
        if (db == null) {
            throw new NullPointerException("Database name can't be null");
        }
        this.host = host;
        this.db = db;
        this.user = user;
        this.password = password;
        this.formatter = new StoreFormatterImpl(this);
        this.additionProcessor = new ABoxAdditionProcessor();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Connection getSQLConnection() {
        return this.connection;
    }

    @Override
    public StoreFormatter getStoreFormatter() {
        return this.formatter;
    }

    @Override
    public ABoxAdditionProcessor getABoxAdditionProcessor() {
        return this.additionProcessor;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Statement createStatement() {
        try {
            return this.connection.createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void execute(String sql) {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.execute(sql);
            stmt.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryResultSet query(Query query, Collection<Variable> resultVars, Store store) {
        QueryResultSet rs;
        if (query == null) {
            throw new NullPointerException();
        }
        if (store == null) {
            throw new NullPointerException();
        }
        log.debug((Object)("Executing UNION of set of queries: " + query.getReformulatedQueries()));
        SQLQueryBuilder builder = this.getSQLQueryBuilder(query, resultVars, store);
        String select = builder.getSQL();
        ResultSet rset = null;
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            long t1 = System.currentTimeMillis();
            log.debug((Object)("SQL query executing: " + select));
            rset = stmt.executeQuery(select);
            log.debug((Object)("Query execution complete: " + (System.currentTimeMillis() - t1) + " ms"));
            rs = new QueryResultSet(rset, builder.getVariableMap(), builder.getIndividualNameAttributes());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return rs;
    }

    @Override
    public SQLQueryBuilder getSQLQueryBuilder(Query query, Collection<Variable> resultVars, Store store) {
        return new SQLQueryBuilder(query, resultVars, store);
    }

    @Override
    public void updateStatistics(Store store) {
        if (store == null) {
            throw new NullPointerException();
        }
        try {
            boolean prevAutoCommit = this.connection.getAutoCommit();
            try {
                this.connection.setAutoCommit(false);
                StatisticsHandler statistics = store.getKB().getTBox().getStatisticsHandler();
                String sql = "UPDATE tbox_name SET frequency = ? WHERE id = ?";
                PreparedStatement stmt = this.connection.prepareStatement("UPDATE tbox_name SET frequency = ? WHERE id = ?");
                Iterator<DLLNamedEntity> entityIter = statistics.entities();
                while (entityIter.hasNext()) {
                    Integer id;
                    DLLNamedEntity entity = entityIter.next();
                    if (entity instanceof DLLAtomic) {
                        id = ((StoreBase)store).getAtomicIds().get(entity);
                    } else if (entity instanceof DLLBasicObjectRole) {
                        id = ((StoreBase)store).getObjectRoleIds().get(entity);
                    } else if (entity instanceof DLLDataRole) {
                        id = ((StoreBase)store).getDataRoleIds().get(entity);
                    } else if (entity instanceof DLLAnnotationRole) {
                        id = ((StoreBase)store).getAnnotationRoleIds().get(entity);
                    } else {
                        throw new RuntimeException("Id not found for entity: " + entity);
                    }
                    stmt.setInt(1, statistics.selectivity(entity));
                    stmt.setInt(2, id);
                    try {
                        if (stmt.executeUpdate() == 1) continue;
                        throw new RuntimeException();
                    }
                    catch (SQLException e) {
                        log.error((Object)("Unable update statistics for entity: " + entity));
                        throw e;
                    }
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw new RuntimeException(e);
            }
            finally {
                this.connection.setAutoCommit(prevAutoCommit);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIfExists(String relation) {
        block13: {
            try {
                DatabaseMetaData md = this.connection.getMetaData();
                ResultSet exists = null;
                try {
                    exists = md.getTables(null, null, relation, null);
                    if (!exists.next()) break block13;
                    ResultSet refd = null;
                    try {
                        refd = md.getExportedKeys(null, null, relation);
                        if (refd.next()) {
                            throw new RuntimeException("Referenced relation: " + relation);
                        }
                        Statement stmt = this.connection.createStatement();
                        stmt.execute("DROP TABLE " + relation);
                        stmt.close();
                    }
                    finally {
                        if (refd != null) {
                            refd.close();
                        }
                    }
                    return;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (exists != null) {
                        exists.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void beginTransaction() {
        try {
            this.connection.setAutoCommit(false);
            this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        this.clearABox();
        this.clearTBox();
    }

    @Override
    public void clearTBox() {
        this.clearABox();
        this.execute("DELETE FROM tbox_concept_inclusion");
        this.execute("DELETE FROM tbox_object_role_inclusion");
        this.execute("DELETE FROM tbox_data_role_inclusion");
        this.execute("DELETE FROM tbox_name");
    }

    @Override
    public void clearABox() {
        this.execute("DELETE FROM concept_assertion");
        this.execute("DELETE FROM data_role_assertion");
        this.execute("DELETE FROM object_role_assertion");
        this.execute("DELETE FROM annotation_to_resource");
        this.execute("DELETE FROM annotation_to_literal");
        this.execute("DELETE FROM individual_name");
    }

    @Override
    public long sizeABox() {
        int size = 0;
        try {
            ResultSet rs = null;
            Statement stmt = this.connection.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM concept_assertion");
            if (rs.next()) {
                size += rs.getInt(1);
            }
            rs.close();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM data_role_assertion");
            if (rs.next()) {
                size += rs.getInt(1);
            }
            rs.close();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM object_role_assertion");
            if (rs.next()) {
                size += rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error on closing connection: " + this.getUrl()));
            throw new RuntimeException(e);
        }
    }
}

