/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.store.DatabaseType;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionBase;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoreConnectionDerby
extends StoreConnectionBase {
    private String url;
    private String driverClassName;

    public StoreConnectionDerby(String host, String db, String user, String password) {
        super(host, db, user, password);
        this.url = "jdbc:derby:" + this.db + ";create=true";
        this.driverClassName = "org.apache.derby.jdbc.EmbeddedDriver";
    }

    public void connect() {
        try {
            Class.forName(this.driverClassName);
            this.connection = DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.Derby;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int addConceptAssertion(Integer conceptId, Integer individualId) {
        try {
            String selSql = "SELECT individual FROM concept_assertion WHERE concept = ? AND individual = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT individual FROM concept_assertion WHERE concept = ? AND individual = ?");
            selStmt.setInt(1, conceptId);
            selStmt.setInt(2, individualId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO concept_assertion (concept, individual) VALUES (?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO concept_assertion (concept, individual) VALUES (?,?)");
            insStmt.setInt(1, conceptId);
            insStmt.setInt(2, individualId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addObjectRoleAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String selSql = "SELECT object_role FROM object_role_assertion WHERE object_role = ? AND a = ? AND b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT object_role FROM object_role_assertion WHERE object_role = ? AND a = ? AND b = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setInt(3, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO object_role_assertion (object_role, a, b) VALUES (?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO object_role_assertion (object_role, a, b) VALUES (?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, bId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addDataRoleAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String selSql = "SELECT data_role FROM data_role_assertion WHERE data_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT data_role FROM data_role_assertion WHERE data_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setString(3, value);
            selStmt.setString(4, datatype);
            selStmt.setString(5, language);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO data_role_assertion (data_role, individual, value, datatype, language) VALUES (?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO data_role_assertion (data_role, individual, value, datatype, language) VALUES (?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setString(3, value);
            insStmt.setString(4, datatype);
            insStmt.setString(5, language);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addObjectAnnotationAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setInt(3, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, bId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addConstantAnnotationAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setString(3, value);
            selStmt.setString(4, datatype);
            selStmt.setString(5, language);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setString(3, value);
            insStmt.setString(4, datatype);
            insStmt.setString(5, language);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void createTBoxRelations() {
        this.execute("CREATE TABLE tbox_name (id INTEGER NOT NULL, type SMALLINT NOT NULL, auxiliary SMALLINT NOT NULL, frequency INTEGER NOT NULL, name VARCHAR(4096) NOT NULL)");
        this.execute("CREATE TABLE tbox_concept_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL, positive SMALLINT NOT NULL)");
        this.execute("CREATE TABLE tbox_data_role_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL)");
        this.execute("CREATE TABLE tbox_object_role_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL)");
    }

    public void createABoxRelations() {
        this.execute("CREATE TABLE individual_name (id INTEGER NOT NULL, name VARCHAR(4096) NOT NULL)");
        this.execute("CREATE TABLE concept_assertion (concept INTEGER NOT NULL, individual INTEGER NOT NULL)");
        this.execute("CREATE TABLE object_role_assertion (object_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE data_role_assertion (data_role INTEGER NOT NULL, individual INTEGER NOT NULL, value VARCHAR(4096) NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
        this.execute("CREATE TABLE annotation_to_resource (annotation_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_literal (annotation_role INTEGER NOT NULL, individual INTEGER NOT NULL, value VARCHAR(4096) NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
    }

    public void dropIfExists(String relation) {
        super.dropIfExists(relation.toUpperCase());
    }

    public void close() {
        boolean success;
        block5: {
            success = false;
            try {
                DriverManager.getConnection("jdbc:derby:" + this.db + ";shutdown=true");
            }
            catch (SQLException e) {
                String state = e.getSQLState();
                if (state == null) {
                    throw new RuntimeException("Database shutdown failed: ", e);
                }
                if (state.equals("XJ015")) {
                    success = true;
                }
                if (!state.equals("08006")) break block5;
                success = true;
            }
        }
        if (!success) {
            throw new RuntimeException("Database shutdown failed");
        }
    }
}

