/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnectionSameAs;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilder;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilderSameAs;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionDerby;
import com.clarkparsia.owlgres.store.formatter.impl.StoreFormatterImplSameAs;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessorSameAs;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreConnectionDerbySameAs
extends StoreConnectionDerby
implements StoreConnectionSameAs {
    public static final Log log = LogFactory.getLog(StoreConnectionDerbySameAs.class);

    public StoreConnectionDerbySameAs(String host, String db, String user, String password) {
        super(host, db, user, password);
        this.formatter = new StoreFormatterImplSameAs(this);
        this.additionProcessor = new ABoxAdditionProcessorSameAs();
    }

    @Override
    public SQLQueryBuilder getSQLQueryBuilder(Query query, Collection<Variable> resultVars, Store store) {
        return new SQLQueryBuilderSameAs(query, resultVars, store);
    }

    @Override
    public int addConceptAssertion(Integer conceptId, Integer aId, Integer caId) {
        try {
            String selSql = "SELECT asserted_individual FROM concept_assertion WHERE concept = ? AND asserted_individual = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT asserted_individual FROM concept_assertion WHERE concept = ? AND asserted_individual = ?");
            selStmt.setInt(1, conceptId);
            selStmt.setInt(2, aId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO concept_assertion (concept, asserted_individual, canonical_individual) VALUES (?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO concept_assertion (concept, asserted_individual, canonical_individual) VALUES (?,?,?)");
            insStmt.setInt(1, conceptId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, caId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addObjectRoleAssertion(Integer roleId, Integer aId, Integer bId, Integer caId, Integer cbId) {
        try {
            String selSql = "SELECT object_role FROM object_role_assertion WHERE object_role = ? AND asserted_a = ? AND asserted_b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT object_role FROM object_role_assertion WHERE object_role = ? AND asserted_a = ? AND asserted_b = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setInt(3, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO object_role_assertion (object_role, asserted_a, asserted_b, canonical_a, canonical_b) VALUES (?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO object_role_assertion (object_role, asserted_a, asserted_b, canonical_a, canonical_b) VALUES (?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, bId);
            insStmt.setInt(4, caId);
            insStmt.setInt(5, cbId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addDataRoleAssertion(Integer roleId, Integer aId, Integer caId, String value, String datatype, String language) {
        try {
            String selSql = "SELECT data_role FROM data_role_assertion WHERE data_role = ? AND asserted_individual = ? AND value = ? AND datatype = ? AND language = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT data_role FROM data_role_assertion WHERE data_role = ? AND asserted_individual = ? AND value = ? AND datatype = ? AND language = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setString(3, value);
            selStmt.setString(4, datatype);
            selStmt.setString(5, language);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO data_role_assertion (data_role, asserted_individual, canonical_individual, value, datatype, language) VALUES (?,?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO data_role_assertion (data_role, asserted_individual, canonical_individual, value, datatype, language) VALUES (?,?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, caId);
            insStmt.setString(4, value);
            insStmt.setString(5, datatype);
            insStmt.setString(6, language);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addObjectAnnotationAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setInt(3, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, bId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addConstantAnnotationAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setString(3, value);
            selStmt.setString(4, datatype);
            selStmt.setString(5, language);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setString(3, value);
            insStmt.setString(4, datatype);
            insStmt.setString(5, language);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addSameIndividualAssertion(Integer aId, Integer bId) {
        try {
            String selSql = "SELECT a, b FROM same_as WHERE a = ? AND b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT a, b FROM same_as WHERE a = ? AND b = ?");
            selStmt.setInt(1, aId);
            selStmt.setInt(2, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO same_as (a, b) VALUES (?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO same_as (a, b) VALUES (?,?)");
            insStmt.setInt(1, aId);
            insStmt.setInt(2, bId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createABoxRelations() {
        this.execute("CREATE TABLE individual_name (id INTEGER NOT NULL, canonical_id INTEGER NOT NULL, name VARCHAR(4096) NOT NULL)");
        this.execute("CREATE TABLE concept_assertion (concept INTEGER NOT NULL, asserted_individual INTEGER NOT NULL, canonical_individual INTEGER NOT NULL)");
        this.execute("CREATE TABLE object_role_assertion (object_role INTEGER NOT NULL, asserted_a INTEGER NOT NULL, asserted_b INTEGER NOT NULL, canonical_a INTEGER NOT NULL, canonical_b INTEGER NOT NULL)");
        this.execute("CREATE TABLE data_role_assertion (data_role INTEGER NOT NULL, asserted_individual INTEGER NOT NULL, canonical_individual INTEGER NOT NULL, value VARCHAR(4096) NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
        this.execute("CREATE TABLE same_as (a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_resource (annotation_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_literal (annotation_role INTEGER NOT NULL, individual INTEGER NOT NULL, value VARCHAR(4096) NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
    }

    @Override
    public void clearABox() {
        this.execute("DELETE FROM same_as");
        super.clearABox();
    }
}

