/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.store.DatabaseType;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionBase;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreConnectionPostgreSQL
extends StoreConnectionBase {
    private String url;
    private String driverClassName;
    public static final Log log = LogFactory.getLog(StoreConnectionPostgreSQL.class);

    public StoreConnectionPostgreSQL(String host, String db, String user, String password) {
        super(host, db, user, password);
        this.url = "jdbc:postgresql://" + this.host + "/" + this.db;
        this.driverClassName = "org.postgresql.Driver";
    }

    public void connect() {
        try {
            Class.forName(this.getDriverClassName());
            this.connection = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            log.error((Object)("Error on connecting to database: " + this.url + ", " + this.user + ", " + this.password));
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Please set the required driver to the classpath: " + this.url));
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public DatabaseType getDatabaseType() {
        return DatabaseType.PostgreSQL;
    }

    public int addConceptAssertion(Integer conceptId, Integer aId) {
        try {
            String sql = "INSERT INTO concept_assertion (concept, individual) SELECT ?, ? WHERE NOT EXISTS (SELECT concept, individual FROM concept_assertion WHERE concept=? AND individual=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO concept_assertion (concept, individual) SELECT ?, ? WHERE NOT EXISTS (SELECT concept, individual FROM concept_assertion WHERE concept=? AND individual=?)");
            stmt.setInt(1, conceptId);
            stmt.setInt(2, aId);
            stmt.setInt(3, conceptId);
            stmt.setInt(4, aId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addObjectRoleAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String sql = "INSERT INTO object_role_assertion (object_role, a, b) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT object_role, a, b FROM object_role_assertion WHERE object_role=? AND a=? AND b=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO object_role_assertion (object_role, a, b) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT object_role, a, b FROM object_role_assertion WHERE object_role=? AND a=? AND b=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setInt(3, bId);
            stmt.setInt(4, roleId);
            stmt.setInt(5, aId);
            stmt.setInt(6, bId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addDataRoleAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String sql = "INSERT INTO data_role_assertion (data_role, individual, value, datatype, language) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT data_role, individual, value, datatype, language FROM data_role_assertion WHERE data_role=? AND individual=? AND value=? AND datatype=? AND language=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO data_role_assertion (data_role, individual, value, datatype, language) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT data_role, individual, value, datatype, language FROM data_role_assertion WHERE data_role=? AND individual=? AND value=? AND datatype=? AND language=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setString(3, value);
            stmt.setString(4, datatype);
            stmt.setString(5, language);
            stmt.setInt(6, roleId);
            stmt.setInt(7, aId);
            stmt.setString(8, value);
            stmt.setString(9, datatype);
            stmt.setString(10, language);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addObjectAnnotationAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String sql = "INSERT INTO annotation_to_resource (annotation_role, a, b) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT annotation_role, a, b FROM annotation_to_resource WHERE annotation_role=? AND a=? AND b=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO annotation_to_resource (annotation_role, a, b) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT annotation_role, a, b FROM annotation_to_resource WHERE annotation_role=? AND a=? AND b=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setInt(3, bId);
            stmt.setInt(4, roleId);
            stmt.setInt(5, aId);
            stmt.setInt(6, bId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int addConstantAnnotationAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String sql = "INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT annotation_role, individual, value, datatype, language FROM annotation_to_literal WHERE annotation_role=? AND individual=? AND value=? AND datatype=? AND language=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT annotation_role, individual, value, datatype, language FROM annotation_to_literal WHERE annotation_role=? AND individual=? AND value=? AND datatype=? AND language=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setString(3, value);
            stmt.setString(4, datatype);
            stmt.setString(5, language);
            stmt.setInt(6, roleId);
            stmt.setInt(7, aId);
            stmt.setString(8, value);
            stmt.setString(9, datatype);
            stmt.setString(10, language);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void createTBoxRelations() {
        this.execute("CREATE TABLE tbox_name (id INTEGER NOT NULL, type SMALLINT NOT NULL, auxiliary BOOLEAN NOT NULL, frequency INTEGER NOT NULL, name TEXT NOT NULL)");
        this.execute("CREATE TABLE tbox_concept_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL, positive BOOLEAN NOT NULL)");
        this.execute("CREATE TABLE tbox_data_role_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL)");
        this.execute("CREATE TABLE tbox_object_role_inclusion (sub INTEGER NOT NULL, super INTEGER NOT NULL)");
    }

    public void createABoxRelations() {
        this.execute("CREATE TABLE individual_name (id INTEGER NOT NULL, name TEXT NOT NULL)");
        this.execute("CREATE TABLE concept_assertion (concept INTEGER NOT NULL,individual INTEGER NOT NULL)");
        this.execute("CREATE TABLE object_role_assertion (object_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE data_role_assertion (data_role INTEGER NOT NULL, individual INTEGER NOT NULL, value TEXT NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL )");
        this.execute("CREATE TABLE annotation_to_resource (annotation_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_literal (annotation_role INTEGER NOT NULL, individual INTEGER NOT NULL, value TEXT NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
    }
}

