/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.connection.impl;

import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnectionSameAs;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilder;
import com.clarkparsia.owlgres.store.connection.impl.SQLQueryBuilderSameAs;
import com.clarkparsia.owlgres.store.connection.impl.StoreConnectionPostgreSQL;
import com.clarkparsia.owlgres.store.formatter.impl.StoreFormatterImplSameAs;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessorSameAs;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreConnectionPostgreSQLSameAs
extends StoreConnectionPostgreSQL
implements StoreConnectionSameAs {
    public static final Log log = LogFactory.getLog(StoreConnectionPostgreSQLSameAs.class);

    public StoreConnectionPostgreSQLSameAs(String host, String db, String user, String password) {
        super(host, db, user, password);
        this.formatter = new StoreFormatterImplSameAs(this);
        this.additionProcessor = new ABoxAdditionProcessorSameAs();
    }

    @Override
    public SQLQueryBuilder getSQLQueryBuilder(Query query, Collection<Variable> resultVars, Store store) {
        return new SQLQueryBuilderSameAs(query, resultVars, store);
    }

    @Override
    public int addConceptAssertion(Integer conceptId, Integer aId, Integer caId) {
        try {
            String sql = "INSERT INTO concept_assertion (concept, asserted_individual, canonical_individual) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT concept, asserted_individual, canonical_individual FROM concept_assertion WHERE concept=? AND asserted_individual=? AND canonical_individual=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO concept_assertion (concept, asserted_individual, canonical_individual) SELECT ?, ?, ? WHERE NOT EXISTS (SELECT concept, asserted_individual, canonical_individual FROM concept_assertion WHERE concept=? AND asserted_individual=? AND canonical_individual=?)");
            stmt.setInt(1, conceptId);
            stmt.setInt(2, aId);
            stmt.setInt(3, caId);
            stmt.setInt(4, conceptId);
            stmt.setInt(5, aId);
            stmt.setInt(6, caId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addObjectRoleAssertion(Integer roleId, Integer aId, Integer bId, Integer caId, Integer cbId) {
        try {
            String sql = "INSERT INTO object_role_assertion (object_role, asserted_a, asserted_b, canonical_a, canonical_b) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT object_role, asserted_a, asserted_b, canonical_a, canonical_b FROM object_role_assertion WHERE object_role=? AND asserted_a=? AND asserted_b=? AND canonical_a=? AND canonical_b=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO object_role_assertion (object_role, asserted_a, asserted_b, canonical_a, canonical_b) SELECT ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT object_role, asserted_a, asserted_b, canonical_a, canonical_b FROM object_role_assertion WHERE object_role=? AND asserted_a=? AND asserted_b=? AND canonical_a=? AND canonical_b=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setInt(3, bId);
            stmt.setInt(4, caId);
            stmt.setInt(5, cbId);
            stmt.setInt(6, roleId);
            stmt.setInt(7, aId);
            stmt.setInt(8, bId);
            stmt.setInt(9, caId);
            stmt.setInt(10, cbId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addDataRoleAssertion(Integer roleId, Integer aId, Integer caId, String value, String datatype, String language) {
        try {
            String insSql = "INSERT INTO data_role_assertion (data_role, asserted_individual, canonical_individual, value, datatype, language) SELECT ?, ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT data_role, asserted_individual, value, datatype, language FROM data_role_assertion WHERE data_role=? AND asserted_individual=? AND canonical_individual=? AND value=? AND datatype=? AND language=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO data_role_assertion (data_role, asserted_individual, canonical_individual, value, datatype, language) SELECT ?, ?, ?, ?, ?, ? WHERE NOT EXISTS (SELECT data_role, asserted_individual, value, datatype, language FROM data_role_assertion WHERE data_role=? AND asserted_individual=? AND canonical_individual=? AND value=? AND datatype=? AND language=?)");
            stmt.setInt(1, roleId);
            stmt.setInt(2, aId);
            stmt.setInt(3, caId);
            stmt.setString(4, value);
            stmt.setString(5, datatype);
            stmt.setString(6, language);
            stmt.setInt(7, roleId);
            stmt.setInt(8, aId);
            stmt.setInt(9, caId);
            stmt.setString(10, value);
            stmt.setString(11, datatype);
            stmt.setString(12, language);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addObjectAnnotationAssertion(Integer roleId, Integer aId, Integer bId) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_resource WHERE annotation_role = ? AND a = ? AND b = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setInt(3, bId);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_resource (annotation_role, a, b) VALUES (?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setInt(3, bId);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addConstantAnnotationAssertion(Integer roleId, Integer aId, String value, String datatype, String language) {
        try {
            String selSql = "SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?";
            PreparedStatement selStmt = this.connection.prepareStatement("SELECT annotation_role FROM annotation_to_literal WHERE annotation_role = ? AND individual = ? AND value = ? AND datatype = ? AND language = ?");
            selStmt.setInt(1, roleId);
            selStmt.setInt(2, aId);
            selStmt.setString(3, value);
            selStmt.setString(4, datatype);
            selStmt.setString(5, language);
            ResultSet selRset = selStmt.executeQuery();
            if (selRset.next()) {
                return 0;
            }
            String insSql = "INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)";
            PreparedStatement insStmt = this.connection.prepareStatement("INSERT INTO annotation_to_literal (annotation_role, individual, value, datatype, language) VALUES (?,?,?,?,?)");
            insStmt.setInt(1, roleId);
            insStmt.setInt(2, aId);
            insStmt.setString(3, value);
            insStmt.setString(4, datatype);
            insStmt.setString(5, language);
            return insStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int addSameIndividualAssertion(Integer aId, Integer bId) {
        try {
            String sql = "INSERT INTO same_as (a, b) SELECT ?, ? WHERE NOT EXISTS (SELECT a, b FROM same_as WHERE a=? AND b=?)";
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO same_as (a, b) SELECT ?, ? WHERE NOT EXISTS (SELECT a, b FROM same_as WHERE a=? AND b=?)");
            stmt.setInt(1, aId);
            stmt.setInt(2, bId);
            stmt.setInt(3, aId);
            stmt.setInt(4, bId);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createABoxRelations() {
        this.execute("CREATE TABLE individual_name (id INTEGER NOT NULL, canonical_id INTEGER NOT NULL, name TEXT NOT NULL)");
        this.execute("CREATE TABLE concept_assertion (concept INTEGER NOT NULL, asserted_individual INTEGER NOT NULL, canonical_individual INTEGER NOT NULL)");
        this.execute("CREATE TABLE object_role_assertion (object_role INTEGER NOT NULL, asserted_a INTEGER NOT NULL, asserted_b INTEGER NOT NULL, canonical_a INTEGER NOT NULL, canonical_b INTEGER NOT NULL)");
        this.execute("CREATE TABLE data_role_assertion (data_role INTEGER NOT NULL, asserted_individual INTEGER NOT NULL, canonical_individual INTEGER NOT NULL, value TEXT NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
        this.execute("CREATE TABLE same_as (a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_resource (annotation_role INTEGER NOT NULL, a INTEGER NOT NULL, b INTEGER NOT NULL)");
        this.execute("CREATE TABLE annotation_to_literal (annotation_role INTEGER NOT NULL, individual INTEGER NOT NULL, value TEXT NOT NULL, datatype VARCHAR(255) NOT NULL, language VARCHAR(10) NOT NULL)");
    }

    @Override
    public void clearABox() {
        this.execute("DELETE FROM same_as");
        super.clearABox();
    }
}

