/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.formatter.impl;

import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.formatter.impl.FormatterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormatterABox
extends FormatterBase {
    public static final Log log = LogFactory.getLog(FormatterABox.class);

    public FormatterABox(StoreConnection storeConnection) {
        super(storeConnection);
    }

    public void drop() {
        log.debug((Object)"Drop ABox relations");
        this.storeConnection.dropIfExists("concept_assertion");
        this.storeConnection.dropIfExists("data_role_assertion");
        this.storeConnection.dropIfExists("object_role_assertion");
        this.storeConnection.dropIfExists("annotation_to_resource");
        this.storeConnection.dropIfExists("annotation_to_literal");
        this.storeConnection.dropIfExists("individual_name");
    }

    public void create() {
        log.debug((Object)"Create ABox relations");
        this.storeConnection.createABoxRelations();
        this.addKeys();
        this.addIndexes();
    }

    public void addKeys() {
        log.debug((Object)"Add ABox keys");
        this.storeConnection.execute("ALTER TABLE individual_name ADD PRIMARY KEY (id)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD PRIMARY KEY (concept, individual)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD FOREIGN KEY (concept) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD FOREIGN KEY (individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD PRIMARY KEY (object_role, a, b)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (object_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (b) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD PRIMARY KEY (data_role, individual, value, datatype, language)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD FOREIGN KEY (data_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD FOREIGN KEY (individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD PRIMARY KEY (annotation_role, a, b)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (annotation_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (b) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD PRIMARY KEY (annotation_role, individual, value, datatype, language)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD FOREIGN KEY (annotation_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD FOREIGN KEY (individual) REFERENCES individual_name (id)");
    }

    public void dropKeys() {
        log.debug((Object)"Drop ABox keys");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_pkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_annotation_role_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_individual_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_pkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_annotation_role_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_a_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_b_fkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_data_role_fkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_individual_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_object_role_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_a_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_b_fkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_concept_fkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_individual_fkey");
        this.storeConnection.execute("ALTER TABLE individual_name DROP CONSTRAINT individual_name_pkey");
    }

    public void addIndexes() {
        log.debug((Object)"Add ABox indexes");
        this.storeConnection.execute("CREATE UNIQUE INDEX individual_name_name_idx ON individual_name (name)");
        this.storeConnection.execute("CREATE INDEX concept_assertion_concept_idx ON concept_assertion (concept)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_role_idx ON object_role_assertion (object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_a_role_idx ON object_role_assertion (a, object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_b_role_idx ON object_role_assertion (b, object_role)");
        this.storeConnection.execute("CREATE INDEX data_role_assertion_role_idx ON data_role_assertion (data_role)");
        this.storeConnection.execute("CREATE INDEX data_role_assertion_individual_role_idx ON data_role_assertion (individual, data_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_resource_a_role_idx ON annotation_to_resource (a, annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_resource_b_role_idx ON annotation_to_resource (b, annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_literal_role_idx ON annotation_to_literal (annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_literal_individual_role_idx ON annotation_to_literal (individual, annotation_role)");
    }

    public void dropIndexes() {
        log.debug((Object)"Drop ABox indexes");
        this.storeConnection.execute("DROP INDEX annotation_to_literal_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_literal_individual_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_resource_a_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_resource_b_role_idx");
        this.storeConnection.execute("DROP INDEX data_role_assertion_role_idx");
        this.storeConnection.execute("DROP INDEX data_role_assertion_individual_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_a_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_b_role_idx");
        this.storeConnection.execute("DROP INDEX concept_assertion_concept_idx");
        this.storeConnection.execute("DROP INDEX individual_name_name_idx");
    }
}

