/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.formatter.impl;

import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.formatter.impl.FormatterABox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormatterABoxSameAs
extends FormatterABox {
    public static final Log log = LogFactory.getLog(FormatterABoxSameAs.class);

    public FormatterABoxSameAs(StoreConnection storeConnection) {
        super(storeConnection);
    }

    public void drop() {
        log.debug((Object)"Drop ABox relations");
        this.storeConnection.dropIfExists("same_as");
        super.drop();
    }

    public void addKeys() {
        log.debug((Object)"Add ABox keys");
        this.storeConnection.execute("ALTER TABLE individual_name ADD PRIMARY KEY (id)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD PRIMARY KEY (concept, asserted_individual)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD FOREIGN KEY (concept) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD FOREIGN KEY (asserted_individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE concept_assertion ADD FOREIGN KEY (canonical_individual) REFERENCES individual_name( id) ");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD PRIMARY KEY (object_role, asserted_a, asserted_b)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (object_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (asserted_a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (asserted_b) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (canonical_a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE object_role_assertion ADD FOREIGN KEY (canonical_b) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD PRIMARY KEY (data_role, asserted_individual, value, datatype, language)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD FOREIGN KEY (data_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD FOREIGN KEY (asserted_individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE data_role_assertion ADD FOREIGN KEY (canonical_individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD PRIMARY KEY (annotation_role, a, b)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (annotation_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource ADD FOREIGN KEY (b) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD PRIMARY KEY (annotation_role, individual, value, datatype, language)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD FOREIGN KEY (annotation_role) REFERENCES tbox_name (id)");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal ADD FOREIGN KEY (individual) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE same_as ADD PRIMARY KEY (a,b)");
        this.storeConnection.execute("ALTER TABLE same_as ADD FOREIGN KEY (a) REFERENCES individual_name (id)");
        this.storeConnection.execute("ALTER TABLE same_as ADD FOREIGN KEY (b) REFERENCES individual_name (id)");
    }

    public void dropKeys() {
        log.debug((Object)"Drop ABox keys");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_pkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_annotation_role_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_literal DROP CONSTRAINT annotation_to_literal_individual_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_pkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_annotation_role_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_a_fkey");
        this.storeConnection.execute("ALTER TABLE annotation_to_resource DROP CONSTRAINT annotation_to_resource_b_fkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_concept_fkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_asserted_individual_fkey");
        this.storeConnection.execute("ALTER TABLE concept_assertion DROP CONSTRAINT concept_assertion_canonical_individual_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_object_role_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_asserted_a_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_asserted_b_fkey");
        this.storeConnection.execute("ALTER TALBE object_role_assertion DROP CONSTRAINT object_role_assertion_canonical_a_fkey");
        this.storeConnection.execute("ALTER TABLE object_role_assertion DROP CONSTRAINT object_role_assertion_canonical_b_fkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_pkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_data_role_fkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_asserted_individual_fkey");
        this.storeConnection.execute("ALTER TABLE data_role_assertion DROP CONSTRAINT data_role_assertion_canonical_individual_fkey");
        this.storeConnection.execute("ALTER TABLE individual_name DROP CONSTRAINT individual_name_pkey");
        this.storeConnection.execute("ALTER TABLE same_as DROP CONSTRAINT same_as_a_fkey");
        this.storeConnection.execute("ALTER TABLE same_as DROP CONSTRAINT same_as_b_fkey");
    }

    public void addIndexes() {
        log.debug((Object)"Add ABox indexes");
        this.storeConnection.execute("CREATE UNIQUE INDEX individual_name_name_idx ON individual_name (name)");
        this.storeConnection.execute("CREATE INDEX concept_assertion_concept_idx ON concept_assertion (concept)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_role_idx ON object_role_assertion (object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_asserted_a_role_idx ON object_role_assertion (asserted_a, object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_asserted_b_role_idx ON object_role_assertion (asserted_b, object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_canonical_a_role_idx ON object_role_assertion (canonical_a, object_role)");
        this.storeConnection.execute("CREATE INDEX object_role_assertion_canonical_b_role_idx ON object_role_assertion(canonical_b, object_role)");
        this.storeConnection.execute("CREATE INDEX data_role_assertion_role_idx ON data_role_assertion (data_role)");
        this.storeConnection.execute("CREATE INDEX data_role_assertion_asserted_individual_role_idx ON data_role_assertion (asserted_individual, data_role)");
        this.storeConnection.execute("CREATE INDEX data_role_assertion_canonical_individual_role_idx ON data_role_assertion (canonical_individual, data_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_resource_a_role_idx ON annotation_to_resource (a, annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_resource_b_role_idx ON annotation_to_resource (b, annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_literal_role_idx ON annotation_to_literal (annotation_role)");
        this.storeConnection.execute("CREATE INDEX annotation_to_literal_individual_role_idx ON annotation_to_literal (individual, annotation_role)");
        this.storeConnection.execute("CREATE INDEX same_as_a_idx ON same_as (a)");
        this.storeConnection.execute("CREATE INDEX same_as_a_b_idx ON same_as (a,b)");
        this.storeConnection.execute("CREATE INDEX same_as_b_a_idx ON same_as (b,a)");
    }

    public void dropIndexes() {
        log.debug((Object)"Drop ABox indexes");
        this.storeConnection.execute("DROP INDEX annotation_to_literal_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_literal_individual_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_resource_a_role_idx");
        this.storeConnection.execute("DROP INDEX annotation_to_resource_b_role_idx");
        this.storeConnection.execute("DROP INDEX data_role_assertion_role_idx");
        this.storeConnection.execute("DROP INDEX data_role_assertion_asserted_individual_role_idx");
        this.storeConnection.execute("DROP INDEX data_role_assertion_canonical_individual_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_asserted_a_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_asserted_b_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_canonical_a_role_idx");
        this.storeConnection.execute("DROP INDEX object_role_assertion_canonical_b_role_idx");
        this.storeConnection.execute("DROP INDEX concept_assertion_concept_idx");
        this.storeConnection.execute("DROP INDEX individual_name_name_idx");
        this.storeConnection.execute("DROP INDEX same_as_a_idx");
        this.storeConnection.execute("DROP INDEX same_as_a_b_idx");
        this.storeConnection.execute("DROP INDEX same_as_b_a_idx");
    }
}

