/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.abox.DLLABoxAssertionVisitor;
import com.clarkparsia.owlgres.abox.DLLConceptAssertion;
import com.clarkparsia.owlgres.abox.DLLConstantAnnotationAssertion;
import com.clarkparsia.owlgres.abox.DLLDataRoleAssertion;
import com.clarkparsia.owlgres.abox.DLLObjectAnnotationAssertion;
import com.clarkparsia.owlgres.abox.DLLObjectRoleAssertion;
import com.clarkparsia.owlgres.abox.DLLSameIndividualAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.WeakHashMap;

public class ABoxAdditionProcessor
implements DLLABoxAssertionVisitor {
    private StoreBase store;
    protected int maxIndividualId;
    protected DLLTBox tbox;
    protected Map<DLLAtomic, Integer> atomicIds;
    protected Map<DLLDataRole, Integer> dataRoleIds;
    protected Map<DLLBasicObjectRole, Integer> objectRoleIds;
    protected Map<DLLAnnotationRoleBase, Integer> basicAnnotationRoleIds;
    protected StoreConnection storeConnection;
    protected WeakHashMap<DLLIndividual, Integer> individualIds;

    public void add(DLLABoxAssertion assertion, Store store) {
        this.store = (StoreBase)store;
        this.storeConnection = this.store.getStoreConnection();
        this.tbox = this.store.getTBox();
        this.atomicIds = this.store.getAtomicIds();
        this.dataRoleIds = this.store.getDataRoleIds();
        this.objectRoleIds = this.store.getObjectRoleIds();
        this.basicAnnotationRoleIds = this.store.getAnnotationRoleIds();
        this.individualIds = this.store.getIndividualIds();
        this.maxIndividualId = 0;
        assertion.accept(this);
    }

    public void visit(DLLConceptAssertion a) {
        this.addConceptAssertion(a.getAtomic(), a.getIndividual());
    }

    public void visit(DLLDataRoleAssertion a) {
        this.addDataRoleAssertion(a.getRole(), a.getSubject(), a.getObject());
    }

    public void visit(DLLObjectRoleAssertion a) {
        this.addObjectRoleAssertion(a.getRole(), a.getSubject(), a.getObject());
    }

    public void visit(DLLSameIndividualAssertion a) {
        throw new UnsupportedOperationException("This ABox processor for assertions does not support OWL sameAs");
    }

    public void visit(DLLObjectAnnotationAssertion a) {
        this.addObjectAnnotationAssertion(a.getRole(), a.getSubject(), (DLLIndividual)a.getObject());
    }

    public void visit(DLLConstantAnnotationAssertion a) {
        this.addConstantAnnotationAssertion(a.getRole(), a.getSubject(), (DLLLiteral)a.getObject());
    }

    protected void addConceptAssertion(DLLAtomic a, DLLIndividual i) {
        Integer conceptId = this.atomicIds.get(a);
        if (conceptId == null) {
            throw new NullPointerException("The concept in the assertion could not be found in the TBox: " + a);
        }
        try {
            Integer aId = this.idForIndividual(i);
            if (this.storeConnection.addConceptAssertion(conceptId, aId) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(a);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addDataRoleAssertion(DLLDataRole r, DLLIndividual i, DLLLiteral v) {
        Integer roleId = this.dataRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The data role in the assertion could not be found in the TBox: " + r);
        }
        try {
            String language;
            String datatype;
            Integer aId = this.idForIndividual(i);
            String value = v.getValue();
            if (value.length() > 2000) {
                value = value.substring(0, 2000);
            }
            if (this.storeConnection.addDataRoleAssertion(roleId, aId, value, datatype = v.isTyped() ? ((DLLTypedLiteral)v).getDatatype().getURI().toASCIIString() : new String(), language = v.isPlain() ? ((DLLPlainLiteral)v).getLanguage() : new String()) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addObjectRoleAssertion(DLLBasicObjectRole r, DLLIndividual a, DLLIndividual b) {
        Integer roleId = this.objectRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The object role in the assertion could not be found in the TBox: " + r);
        }
        try {
            Integer aId = this.idForIndividual(a);
            Integer bId = this.idForIndividual(b);
            if (this.storeConnection.addObjectRoleAssertion(roleId, aId, bId) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addObjectAnnotationAssertion(DLLAnnotationRoleBase r, DLLIndividual a, DLLIndividual b) {
        Integer roleId = this.basicAnnotationRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The annotation role in the assertion could not be found in the TBox: " + r);
        }
        try {
            Integer aId = this.idForIndividual(a);
            Integer bId = this.idForIndividual(b);
            if (this.storeConnection.addObjectAnnotationAssertion(roleId, aId, bId) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addConstantAnnotationAssertion(DLLAnnotationRoleBase r, DLLIndividual i, DLLLiteral l) {
        Integer roleId = this.basicAnnotationRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The annotation role in the assertion could not be found in the TBox: " + r);
        }
        try {
            String language;
            String datatype;
            String value = l.getValue();
            Integer aId = this.idForIndividual(i);
            if (value.length() > 2000) {
                value = value.substring(0, 2000);
            }
            if (this.storeConnection.addConstantAnnotationAssertion(roleId, aId, value, datatype = l.isTyped() ? ((DLLTypedLiteral)l).getDatatype().getURI().toASCIIString() : new String(), language = l.isPlain() ? ((DLLPlainLiteral)l).getLanguage() : new String()) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Integer idForIndividual(DLLIndividual i) throws SQLException {
        Integer individualId = this.individualIds.get(i);
        if (individualId == null) {
            String idSql = "SELECT id FROM individual_name WHERE name = ?";
            PreparedStatement idStmt = this.storeConnection.prepareStatement("SELECT id FROM individual_name WHERE name = ?");
            idStmt.setString(1, i.getName());
            ResultSet idRset = idStmt.executeQuery();
            if (idRset.next()) {
                individualId = idRset.getInt(1);
            } else {
                if (this.maxIndividualId == 0) {
                    String maxSql = "SELECT max(id) FROM individual_name";
                    ResultSet maxRset = this.storeConnection.prepareStatement("SELECT max(id) FROM individual_name").executeQuery();
                    if (maxRset.next()) {
                        this.maxIndividualId = maxRset.getInt(1);
                    }
                }
                individualId = ++this.maxIndividualId;
                String insSql = "INSERT INTO individual_name (name, id) VALUES (?,?)";
                PreparedStatement insStmt = this.storeConnection.prepareStatement("INSERT INTO individual_name (name, id) VALUES (?,?)");
                insStmt.setString(1, i.getName());
                insStmt.setInt(2, individualId);
                if (insStmt.executeUpdate() != 1) {
                    throw new RuntimeException();
                }
            }
            this.individualIds.put(i, individualId);
        }
        return individualId;
    }
}

