/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.abox.DLLSameIndividualAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnectionSameAs;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessor;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ABoxAdditionProcessorSameAs
extends ABoxAdditionProcessor {
    private StoreConnectionSameAs storeConnectionSameAs;

    public void add(DLLABoxAssertion assertion, Store store) {
        this.storeConnection = ((StoreBase)store).getStoreConnection();
        if (!(this.storeConnection instanceof StoreConnectionSameAs)) {
            throw new UnsupportedOperationException("The store does not support OWL sameAs");
        }
        this.storeConnectionSameAs = (StoreConnectionSameAs)this.storeConnection;
        super.add(assertion, store);
    }

    public void visit(DLLSameIndividualAssertion a) {
        this.addSameIndividualAssertion(a.getSubject(), a.getObject());
    }

    protected void addConceptAssertion(DLLAtomic a, DLLIndividual i) {
        Integer conceptId = (Integer)this.atomicIds.get(a);
        if (conceptId == null) {
            throw new NullPointerException("The concept in the assertion could not be found in the TBox: " + a);
        }
        try {
            Integer aId = this.idForIndividual(i);
            Integer caId = this.findCanonicalId(aId);
            this.updateCanonicalIndividual(aId, caId);
            if (this.storeConnectionSameAs.addConceptAssertion(conceptId, aId, caId) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(a);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addDataRoleAssertion(DLLDataRole r, DLLIndividual i, DLLLiteral v) {
        Integer roleId = (Integer)this.dataRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The data role in the assertion could not be found in the TBox: " + r);
        }
        try {
            String language;
            String datatype;
            Integer aId = this.idForIndividual(i);
            Integer caId = this.findCanonicalId(aId);
            this.updateCanonicalIndividual(aId, caId);
            String value = v.getValue();
            if (value.length() > 2000) {
                value = value.substring(0, 2000);
            }
            if (this.storeConnectionSameAs.addDataRoleAssertion(roleId, aId, caId, value, datatype = v.isTyped() ? ((DLLTypedLiteral)v).getDatatype().getURI().toASCIIString() : new String(), language = v.isPlain() ? ((DLLPlainLiteral)v).getLanguage() : new String()) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addObjectRoleAssertion(DLLBasicObjectRole r, DLLIndividual a, DLLIndividual b) {
        Integer roleId = (Integer)this.objectRoleIds.get(r);
        if (roleId == null) {
            throw new NullPointerException("The object role in the assertion could not be found in the TBox: " + r);
        }
        try {
            Integer aId = this.idForIndividual(a);
            Integer bId = this.idForIndividual(b);
            Integer caId = this.findCanonicalId(aId);
            Integer cbId = this.findCanonicalId(bId);
            this.updateCanonicalIndividual(aId, caId);
            this.updateCanonicalIndividual(bId, cbId);
            if (this.storeConnectionSameAs.addObjectRoleAssertion(roleId, aId, bId, caId, cbId) == 1) {
                StatisticsHandler statistics = this.tbox.getStatisticsHandler();
                statistics.increment(r);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addSameIndividualAssertion(DLLIndividual a, DLLIndividual b) {
        try {
            Integer aId = this.idForIndividual(a);
            Integer bId = this.idForIndividual(b);
            this.storeConnectionSameAs.addSameIndividualAssertion(aId, bId);
            this.computeSameAsClosure();
            this.updateIndividuals();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Integer idForIndividual(DLLIndividual i) throws SQLException {
        Integer individualId = (Integer)this.individualIds.get(i);
        if (individualId == null) {
            String idSql = "SELECT id FROM individual_name WHERE name = ?";
            PreparedStatement idStmt = this.storeConnectionSameAs.prepareStatement("SELECT id FROM individual_name WHERE name = ?");
            idStmt.setString(1, i.getName());
            ResultSet idRset = idStmt.executeQuery();
            if (idRset.next()) {
                individualId = idRset.getInt(1);
            } else {
                if (this.maxIndividualId == 0) {
                    String maxSql = "SELECT max(id) FROM individual_name";
                    ResultSet maxRset = this.storeConnectionSameAs.prepareStatement("SELECT max(id) FROM individual_name").executeQuery();
                    if (maxRset.next()) {
                        this.maxIndividualId = maxRset.getInt(1);
                    }
                }
                individualId = ++this.maxIndividualId;
                String insSql = "INSERT INTO individual_name (name, id, canonical_id) VALUES (?,?,?)";
                PreparedStatement insStmt = this.storeConnectionSameAs.prepareStatement("INSERT INTO individual_name (name, id, canonical_id) VALUES (?,?,?)");
                insStmt.setString(1, i.getName());
                insStmt.setInt(2, individualId);
                insStmt.setInt(3, 0);
                if (insStmt.executeUpdate() != 1) {
                    throw new RuntimeException();
                }
            }
            this.individualIds.put(i, individualId);
        }
        return individualId;
    }

    private void updateIndividuals() {
        try {
            String sql = "SELECT id, canonical_id FROM individual_name";
            Statement stmt = this.storeConnectionSameAs.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id, canonical_id FROM individual_name");
            while (rs.next()) {
                Integer ncid;
                Integer id = rs.getInt(1);
                Integer cid = rs.getInt(2);
                if (cid == (ncid = this.findCanonicalId(id))) continue;
                String psql = "UPDATE individual_name SET canonical_id = ? WHERE id = ?";
                PreparedStatement pstmt = this.storeConnectionSameAs.prepareStatement("UPDATE individual_name SET canonical_id = ? WHERE id = ?");
                pstmt.setInt(1, ncid);
                pstmt.setInt(2, id);
                pstmt.executeUpdate();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void computeSameAsClosure() {
        boolean run = true;
        while (run) {
            int updates = 0;
            updates += this.process("SELECT DISTINCT sa1.b AS a, sa2.b AS b FROM same_as sa1, same_as sa2 WHERE sa1.a = sa2.a");
            updates += this.process("SELECT DISTINCT sa1.b AS a, sa2.a AS b FROM same_as sa1, same_as sa2 WHERE sa1.a = sa2.b");
            updates += this.process("SELECT DISTINCT sa1.a AS a, sa2.b AS b FROM same_as sa1, same_as sa2 WHERE sa1.b = sa2.a");
            if ((updates += this.process("SELECT DISTINCT sa1.a AS a, sa2.a AS b FROM same_as sa1, same_as sa2 WHERE sa1.b = sa2.b")) != 0) continue;
            run = false;
        }
    }

    private int process(String sql) {
        int updates = 0;
        try {
            Statement stmt = this.storeConnectionSameAs.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Integer aId = rs.getInt(1);
                Integer bId = rs.getInt(2);
                updates += this.storeConnectionSameAs.addSameIndividualAssertion(aId, bId);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return updates;
    }

    private Integer findCanonicalId(Integer id) {
        try {
            Integer cId = id;
            String sql = "SELECT b FROM same_as WHERE a = ?";
            PreparedStatement stmt = this.storeConnectionSameAs.prepareStatement("SELECT b FROM same_as WHERE a = ?");
            stmt.setInt(1, id);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                Integer bId = rs.getInt(1);
                if (bId >= cId) continue;
                cId = bId;
            }
            return cId;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCanonicalIndividual(Integer id, Integer cid) {
        try {
            String sql = "UPDATE individual_name SET canonical_id = ? WHERE id = ?";
            PreparedStatement stmt = this.storeConnectionSameAs.prepareStatement("UPDATE individual_name SET canonical_id = ? WHERE id = ?");
            stmt.setInt(1, cid);
            stmt.setInt(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

