/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLBasicConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLDataExistential;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import java.util.Map;

public class InclusionIdConverter
implements DLLBasicConceptVisitor,
DLLObjectRoleVisitor {
    private Integer id;
    private StoreBase store;
    protected Map<DLLAtomic, Integer> atomicIds;
    protected Map<DLLDataRole, Integer> dataRoleIds;
    protected Map<DLLBasicObjectRole, Integer> objectRoleIds;
    protected Map<DLLAnnotationRoleBase, Integer> annotationRoleIds;

    public InclusionIdConverter(Store store) {
        this.store = (StoreBase)store;
        this.atomicIds = this.store.getAtomicIds();
        this.dataRoleIds = this.store.getDataRoleIds();
        this.objectRoleIds = this.store.getObjectRoleIds();
        this.annotationRoleIds = this.store.getAnnotationRoleIds();
    }

    public int getId(DLLBasicConcept c) {
        this.id = null;
        c.accept(this);
        return this.id;
    }

    public int getId(DLLDataRole r) {
        this.id = this.dataRoleIds.get(r);
        return this.id;
    }

    public int getId(DLLObjectRole r) {
        this.id = null;
        r.accept(this);
        return this.id;
    }

    public int getId(DLLAnnotationRoleBase r) {
        this.id = this.annotationRoleIds.get(r);
        return this.id;
    }

    public void visit(DLLAtomic c) {
        this.id = this.atomicIds.get(c);
    }

    public void visit(DLLBasicObjectRole r) {
        this.id = this.objectRoleIds.get(r);
    }

    public void visit(DLLDataExistential c) {
        this.id = this.dataRoleIds.get(c.getRole());
    }

    public void visit(DLLInverseObjectRole r) {
        this.id = -this.objectRoleIds.get(r.getBasicRole()).intValue();
    }

    public void visit(DLLObjectExistential c) {
        DLLObjectRole r = c.getRole();
        r.accept(this);
    }
}

