/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLKB;
import com.clarkparsia.owlgres.abox.DLLABox;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.StoreFormatter;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.impl.ABoxAdditionProcessor;
import com.clarkparsia.owlgres.store.impl.TBoxReader;
import com.clarkparsia.owlgres.store.impl.TBoxWriter;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.TermFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreBase
implements Store {
    protected StoreConnection storeConnection;
    protected StoreFormatter storeFormatter;
    protected TBoxReader tboxReader;
    protected TBoxWriter tboxWriter;
    protected DLLKB kb;
    protected Map<DLLAtomic, Integer> atomicIds;
    protected Map<DLLDataRole, Integer> dataRoleIds;
    protected Map<DLLBasicObjectRole, Integer> objectRoleIds;
    protected Map<DLLAnnotationRoleBase, Integer> annotationRoleIds;
    protected Map<Integer, DLLAtomic> idAtomics;
    protected Map<Integer, DLLDataRole> idDataRoles;
    protected Map<Integer, DLLBasicObjectRole> idObjectRoles;
    protected Map<Integer, DLLAnnotationRoleBase> idAnnotationRoles;
    private WeakHashMap<DLLIndividual, Integer> individualIds;
    private ABoxAdditionProcessor additionProcessor;
    public static final short CLASS_TYPE = 1;
    public static final short OBJECT_ROLE_TYPE = 2;
    public static final short DATA_ROLE_TYPE = 3;
    public static final short ANNOTATION_ROLE_TYPE = 4;

    public StoreBase(StoreConnection storeConnection) {
        this.storeConnection = storeConnection;
        this.storeFormatter = storeConnection.getStoreFormatter();
        this.additionProcessor = storeConnection.getABoxAdditionProcessor();
        this.idAtomics = new HashMap<Integer, DLLAtomic>();
        this.idDataRoles = new HashMap<Integer, DLLDataRole>();
        this.idObjectRoles = new HashMap<Integer, DLLBasicObjectRole>();
        this.idAnnotationRoles = new HashMap<Integer, DLLAnnotationRoleBase>();
        this.atomicIds = new HashMap<DLLAtomic, Integer>();
        this.dataRoleIds = new HashMap<DLLDataRole, Integer>();
        this.objectRoleIds = new HashMap<DLLBasicObjectRole, Integer>();
        this.individualIds = new WeakHashMap();
        this.annotationRoleIds = new HashMap<DLLAnnotationRoleBase, Integer>();
        this.tboxReader = new TBoxReader(storeConnection, this);
        this.tboxWriter = new TBoxWriter(storeConnection, this);
        this.kb = new DLLKB(this);
    }

    public StoreBase(StoreConnection storeConnection, DLLTBox tbox) {
        this(storeConnection);
        this.kb.setTBox(tbox);
    }

    @Override
    public void load(DLLTBox tbox) {
        this.tboxWriter.write(tbox);
        this.kb.setTBox(tbox);
    }

    @Override
    public void read() {
        this.kb.setTBox(this.tboxReader.read());
    }

    public void updateStatistics() {
        this.storeConnection.updateStatistics(this);
    }

    @Override
    public void format() {
        this.storeFormatter.format();
    }

    @Override
    public DLLKB getKB() {
        return this.kb;
    }

    public DLLTBox getTBox() {
        return this.kb.getTBox();
    }

    public DLLABox getABox() {
        return this.kb.getABox();
    }

    public void addAssertion(DLLABoxAssertion assertion) {
        if (assertion == null) {
            throw new NullPointerException();
        }
        this.addAssertions(Collections.singleton(assertion));
    }

    public void addAssertions(Collection<? extends DLLABoxAssertion> assertions) {
        if (assertions == null) {
            throw new NullPointerException();
        }
        for (DLLABoxAssertion dLLABoxAssertion : assertions) {
            this.additionProcessor.add(dLLABoxAssertion, this);
        }
    }

    public QueryResultSet query(Query query, Collection<Variable> resultVars) {
        return this.storeConnection.query(query, resultVars, this);
    }

    public StoreConnection getStoreConnection() {
        return this.storeConnection;
    }

    public StoreFormatter getStoreFormatter() {
        return this.storeFormatter;
    }

    public ABoxAdditionProcessor getAdditionProcessor() {
        return this.additionProcessor;
    }

    public TBoxReader getTBoxReader() {
        return this.tboxReader;
    }

    public TBoxWriter getTBoxWriter() {
        return this.tboxWriter;
    }

    @Override
    public void clear() {
        this.clearABox();
        this.clearTBox();
    }

    public void clearTBox() {
        this.idAtomics.clear();
        this.idDataRoles.clear();
        this.idObjectRoles.clear();
        this.idAnnotationRoles.clear();
        this.atomicIds.clear();
        this.dataRoleIds.clear();
        this.objectRoleIds.clear();
        this.annotationRoleIds.clear();
        this.storeConnection.clearTBox();
    }

    public void clearABox() {
        this.individualIds.clear();
        this.storeConnection.clearABox();
    }

    public long sizeABox() {
        return this.storeConnection.sizeABox();
    }

    @Override
    public void close() {
        this.storeConnection.close();
    }

    public void write(DLLTBox tbox) {
        this.tboxWriter.write(tbox);
        this.kb.setTBox(tbox);
    }

    public Map<Integer, DLLAtomic> getIdAtomics() {
        return this.idAtomics;
    }

    public Map<Integer, DLLDataRole> getIdDataRoles() {
        return this.idDataRoles;
    }

    public Map<Integer, DLLBasicObjectRole> getIdObjectRoles() {
        return this.idObjectRoles;
    }

    public Map<Integer, DLLAnnotationRoleBase> getIdBasicAnnotationRoles() {
        return this.idAnnotationRoles;
    }

    public Map<DLLAtomic, Integer> getAtomicIds() {
        return this.atomicIds;
    }

    public Map<DLLDataRole, Integer> getDataRoleIds() {
        return this.dataRoleIds;
    }

    public Map<DLLBasicObjectRole, Integer> getObjectRoleIds() {
        return this.objectRoleIds;
    }

    public Map<DLLAnnotationRoleBase, Integer> getAnnotationRoleIds() {
        return this.annotationRoleIds;
    }

    public WeakHashMap<DLLIndividual, Integer> getIndividualIds() {
        return this.individualIds;
    }

    public DLLBasicConcept getConceptFromInclusionId(int id) {
        boolean negative = id < 0;
        int abs = negative ? -id : id;
        DLLAtomic atomic = this.idAtomics.get(abs);
        if (atomic != null) {
            if (negative) {
                throw new RuntimeException("Negated atomic in inclusion relation unexpected");
            }
            return atomic;
        }
        DLLBasicObjectRole objectRole = this.idObjectRoles.get(abs);
        if (objectRole != null) {
            return negative ? TermFactory.existential(TermFactory.inverseOf(objectRole)) : TermFactory.existential(objectRole);
        }
        DLLDataRole dataRole = this.idDataRoles.get(abs);
        if (dataRole != null) {
            if (negative) {
                throw new RuntimeException("Negated data role in inclusion relation unexpected");
            }
            return TermFactory.existential(dataRole);
        }
        throw new RuntimeException();
    }

    public DLLDataRole getDataRoleFromInclusionId(int id) {
        assert (id > 0) : "Non-positive data role id unexpected";
        DLLDataRole a = this.idDataRoles.get(id);
        if (a == null) {
            throw new NullPointerException();
        }
        return a;
    }

    public DLLObjectRole getObjectRoleFromInclusionId(int id) {
        boolean negative = id < 0;
        DLLBasicObjectRole r = this.idObjectRoles.get(negative ? -id : id);
        if (r == null) {
            throw new NullPointerException();
        }
        return negative ? TermFactory.inverseOf(r) : r;
    }

    public void setId(DLLAtomic a, int id) {
        this.idAtomics.put(id, a);
        this.atomicIds.put(a, id);
    }

    public void setId(DLLBasicObjectRole r, int id) {
        this.idObjectRoles.put(id, r);
        this.objectRoleIds.put(r, id);
    }

    public void setId(DLLDataRole a, int id) {
        this.idDataRoles.put(id, a);
        this.dataRoleIds.put(a, id);
    }

    public void setId(DLLAnnotationRoleBase a, int id) {
        this.idAnnotationRoles.put(id, a);
        this.annotationRoleIds.put(a, id);
    }
}

