/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import com.clarkparsia.owlgres.util.TermFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TBoxReader {
    private StoreBase store;
    private StoreConnection storeConnection;

    public TBoxReader(StoreConnection storeConnection, Store store) {
        this.storeConnection = storeConnection;
        this.store = (StoreBase)store;
    }

    public DLLTBox read() {
        DLLTBox tbox = new DLLTBox();
        StatisticsHandler statistics = tbox.getStatisticsHandler();
        try {
            Object sup;
            String nameSql = "SELECT id, type, auxiliary, frequency, name FROM tbox_name ORDER BY id ASC";
            PreparedStatement nameStmt = this.storeConnection.prepareStatement("SELECT id, type, auxiliary, frequency, name FROM tbox_name ORDER BY id ASC");
            ResultSet nameRset = nameStmt.executeQuery();
            block8: while (nameRset.next()) {
                int id = nameRset.getInt(1);
                short type = nameRset.getShort(2);
                boolean auxiliary = nameRset.getBoolean(3);
                Integer frequency = nameRset.getInt(4);
                String name = nameRset.getString(5);
                switch (type) {
                    case 3: {
                        DLLDataRole a = TermFactory.dataRole(name);
                        this.store.setId(a, id);
                        tbox.addRole(a);
                        statistics.set(a, frequency);
                        continue block8;
                    }
                    case 1: {
                        DLLAtomic c = TermFactory.atomic(name);
                        this.store.setId(c, id);
                        tbox.addAtomic(c);
                        statistics.set(c, frequency);
                        continue block8;
                    }
                    case 2: {
                        DLLBasicObjectRole r = TermFactory.objectRole(name, auxiliary);
                        this.store.setId(r, id);
                        tbox.addRole(r);
                        statistics.set(r, frequency);
                        continue block8;
                    }
                    case 4: {
                        DLLAnnotationRoleBase s = TermFactory.annotationRole(name);
                        this.store.setId(s, id);
                        tbox.addRole(s);
                        statistics.set(s, frequency);
                        continue block8;
                    }
                }
                throw new RuntimeException();
            }
            String conceptSql = "SELECT sub, super, positive FROM tbox_concept_inclusion";
            PreparedStatement conceptStmt = this.storeConnection.prepareStatement("SELECT sub, super, positive FROM tbox_concept_inclusion");
            ResultSet inclusionsRset = conceptStmt.executeQuery();
            while (inclusionsRset.next()) {
                int subId = inclusionsRset.getInt(1);
                int supId = inclusionsRset.getInt(2);
                boolean positive = inclusionsRset.getBoolean(3);
                DLLBasicConcept sub = this.store.getConceptFromInclusionId(subId);
                DLLBasicConcept sup2 = this.store.getConceptFromInclusionId(supId);
                if (positive) {
                    tbox.addInclusion(sub, sup2);
                    continue;
                }
                tbox.addInclusion(sub, TermFactory.negationOf(sup2));
            }
            String roleSql = "SELECT sub, super FROM tbox_object_role_inclusion";
            PreparedStatement roleStmt = this.storeConnection.prepareStatement("SELECT sub, super FROM tbox_object_role_inclusion");
            ResultSet roleRset = roleStmt.executeQuery();
            while (roleRset.next()) {
                int subId = roleRset.getInt(1);
                int supId = roleRset.getInt(2);
                DLLObjectRole sub = this.store.getObjectRoleFromInclusionId(subId);
                sup = this.store.getObjectRoleFromInclusionId(supId);
                tbox.addInclusion(sub, (DLLObjectRole)sup);
            }
            String attrSql = "SELECT sub, super FROM tbox_data_role_inclusion";
            PreparedStatement attrStmt = this.storeConnection.prepareStatement("SELECT sub, super FROM tbox_data_role_inclusion");
            ResultSet attrRset = attrStmt.executeQuery();
            while (attrRset.next()) {
                int subId = attrRset.getInt(1);
                int supId = attrRset.getInt(2);
                DLLDataRole sub = this.store.getDataRoleFromInclusionId(subId);
                sup = this.store.getDataRoleFromInclusionId(supId);
                tbox.addInclusion(sub, (DLLDataRole)sup);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        tbox.prepare();
        return tbox;
    }
}

