/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.store.impl;

import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.impl.InclusionIdConverter;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBoxWriter {
    private StoreBase store;
    private Connection connection;
    private StatisticsHandler statistics;
    private StoreConnection storeConnection;
    private Map<DLLDataRole, Integer> dataRoleIds;
    public static final Log log = LogFactory.getLog(TBoxWriter.class);

    public TBoxWriter(StoreConnection storeConnection, Store store) {
        this.storeConnection = storeConnection;
        this.store = (StoreBase)store;
        this.connection = storeConnection.getSQLConnection();
        this.dataRoleIds = this.store.getDataRoleIds();
    }

    public void write(DLLTBox tbox) {
        if (tbox == null) {
            throw new NullPointerException();
        }
        tbox.prepare();
        this.statistics = tbox.getStatisticsHandler();
        try {
            boolean prevAutoCommit = this.connection.getAutoCommit();
            try {
                this.connection.setAutoCommit(false);
                this.storeNamedEntities(tbox);
                this.storeInclusionAxioms(tbox);
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                throw new RuntimeException(e);
            }
            finally {
                this.connection.setAutoCommit(prevAutoCommit);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void storeNamedEntities(DLLTBox tbox) throws SQLException {
        Integer i;
        int id = 1;
        String sql = "INSERT INTO tbox_name (id, type, auxiliary, frequency, name) VALUES (?,?,?,?,?)";
        PreparedStatement nameStmt = this.storeConnection.prepareStatement("INSERT INTO tbox_name (id, type, auxiliary, frequency, name) VALUES (?,?,?,?,?)");
        for (DLLAtomic dLLAtomic : tbox.getAtomics()) {
            i = id++;
            this.storeAtomic(dLLAtomic, i, nameStmt, this.statistics.selectivity(dLLAtomic));
        }
        for (DLLBasicObjectRole dLLBasicObjectRole : tbox.getObjectRoles()) {
            i = id++;
            this.storeObjectRole(dLLBasicObjectRole, i, nameStmt, this.statistics.selectivity(dLLBasicObjectRole));
        }
        for (DLLDataRole dLLDataRole : tbox.getDataRoles()) {
            i = id++;
            this.storeDataRole(dLLDataRole, i, nameStmt, this.statistics.selectivity(dLLDataRole));
        }
        for (DLLAnnotationRoleBase dLLAnnotationRoleBase : tbox.getBasicAnnotationRoles()) {
            i = id++;
            this.storeBasicAnnotationRole(dLLAnnotationRoleBase, i, nameStmt, this.statistics.selectivity(dLLAnnotationRoleBase));
        }
        nameStmt.close();
    }

    private void storeInclusionAxioms(DLLTBox tbox) throws SQLException {
        InclusionIdConverter converter = new InclusionIdConverter(this.store);
        String conceptSql = "INSERT INTO tbox_concept_inclusion (sub,super,positive) VALUES (?,?,?)";
        PreparedStatement conceptStmt = this.storeConnection.prepareStatement("INSERT INTO tbox_concept_inclusion (sub,super,positive) VALUES (?,?,?)");
        for (Map.Entry<DLLBasicConcept, Set<DLLBasicConcept>> entry : tbox.getPositiveInclusions().entrySet()) {
            this.storePositiveInclusion(entry, converter, conceptStmt);
        }
        for (Map.Entry<DLLBasicConcept, Set<DLLBasicConcept>> entry : tbox.getNegativeInclusions().entrySet()) {
            this.storeNegativeInclusion(entry, converter, conceptStmt);
        }
        String roleSql = "INSERT INTO tbox_object_role_inclusion (sub,super) VALUES (?,?)";
        PreparedStatement roleStmt = this.storeConnection.prepareStatement("INSERT INTO tbox_object_role_inclusion (sub,super) VALUES (?,?)");
        for (Map.Entry<DLLBasicObjectRole, Set<DLLObjectRole>> entry : tbox.getObjectRoleInclusions().entrySet()) {
            this.storeObjectRoleInclusion(entry, converter, roleStmt);
        }
        String attrSql = "INSERT INTO tbox_data_role_inclusion (sub,super) VALUES (?,?)";
        PreparedStatement attrStmt = this.storeConnection.prepareStatement("INSERT INTO tbox_data_role_inclusion (sub,super) VALUES (?,?)");
        for (Map.Entry<DLLDataRole, Set<DLLDataRole>> entry : tbox.getDataRoleInclusions().entrySet()) {
            this.storeDataRoleInclusion(entry, converter, attrStmt);
        }
    }

    private void storeAtomic(DLLAtomic a, Integer id, PreparedStatement stmt, Integer selectivity) throws SQLException {
        String u = a.getName();
        this.store.setId(a, (int)id);
        stmt.setInt(1, id);
        stmt.setShort(2, (short)1);
        stmt.setBoolean(3, false);
        stmt.setInt(4, selectivity);
        stmt.setString(5, u);
        try {
            if (stmt.executeUpdate() != 1) {
                throw new RuntimeException();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to add atomic: " + a), (Throwable)e);
            throw e;
        }
    }

    private void storeObjectRole(DLLBasicObjectRole r, Integer id, PreparedStatement stmt, Integer selectivity) throws SQLException {
        String u = r.getName();
        this.store.setId(r, (int)id);
        stmt.setInt(1, id);
        stmt.setShort(2, (short)2);
        stmt.setBoolean(3, r.isAuxiliary());
        stmt.setInt(4, selectivity);
        stmt.setString(5, u);
        try {
            if (stmt.executeUpdate() != 1) {
                throw new RuntimeException();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to add object role: " + r), (Throwable)e);
            throw e;
        }
    }

    private void storeDataRole(DLLDataRole r, Integer id, PreparedStatement stmt, Integer selectivity) throws SQLException {
        String u = r.getName();
        this.store.setId(r, (int)id);
        stmt.setInt(1, id);
        stmt.setShort(2, (short)3);
        stmt.setBoolean(3, false);
        stmt.setInt(4, selectivity);
        stmt.setString(5, u);
        try {
            if (stmt.executeUpdate() != 1) {
                throw new RuntimeException();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to add data role: " + r), (Throwable)e);
            throw e;
        }
    }

    private void storeBasicAnnotationRole(DLLAnnotationRoleBase r, Integer id, PreparedStatement stmt, Integer selectivity) throws SQLException {
        String u = r.getName();
        this.store.setId(r, (int)id);
        stmt.setInt(1, id);
        stmt.setShort(2, (short)4);
        stmt.setBoolean(3, false);
        stmt.setInt(4, selectivity);
        stmt.setString(5, u);
        try {
            if (stmt.executeUpdate() != 1) {
                throw new RuntimeException();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Unable to add annotation role: " + r), (Throwable)e);
            throw e;
        }
    }

    private void storePositiveInclusion(Map.Entry<DLLBasicConcept, Set<DLLBasicConcept>> entry, InclusionIdConverter converter, PreparedStatement stmt) throws SQLException {
        DLLBasicConcept lftC = entry.getKey();
        int lftId = converter.getId(lftC);
        for (DLLBasicConcept rgtC : entry.getValue()) {
            int rgtId = converter.getId(rgtC);
            stmt.setInt(1, lftId);
            stmt.setInt(2, rgtId);
            stmt.setBoolean(3, true);
            if (stmt.executeUpdate() == 1) continue;
            throw new RuntimeException();
        }
    }

    private void storeNegativeInclusion(Map.Entry<DLLBasicConcept, Set<DLLBasicConcept>> entry, InclusionIdConverter converter, PreparedStatement stmt) throws SQLException {
        DLLBasicConcept lftC = entry.getKey();
        int lftId = converter.getId(lftC);
        for (DLLBasicConcept rgtC : entry.getValue()) {
            int rgtId = converter.getId(rgtC);
            stmt.setInt(1, lftId);
            stmt.setInt(2, rgtId);
            stmt.setBoolean(3, false);
            if (stmt.executeUpdate() == 1) continue;
            throw new RuntimeException();
        }
    }

    private void storeObjectRoleInclusion(Map.Entry<DLLBasicObjectRole, Set<DLLObjectRole>> entry, InclusionIdConverter converter, PreparedStatement stmt) throws SQLException {
        DLLBasicObjectRole lftR = entry.getKey();
        int lftId = converter.getId(lftR);
        for (DLLObjectRole rgtC : entry.getValue()) {
            int rgtId = converter.getId(rgtC);
            stmt.setInt(1, lftId);
            stmt.setInt(2, rgtId);
            if (stmt.executeUpdate() == 1) continue;
            throw new RuntimeException();
        }
    }

    private void storeDataRoleInclusion(Map.Entry<DLLDataRole, Set<DLLDataRole>> entry, InclusionIdConverter converter, PreparedStatement stmt) throws SQLException {
        DLLDataRole lftA = entry.getKey();
        int lftId = this.dataRoleIds.get(lftA);
        for (DLLDataRole rgtA : entry.getValue()) {
            int rgtId = this.dataRoleIds.get(rgtA);
            stmt.setInt(1, lftId);
            stmt.setInt(2, rgtId);
            if (stmt.executeUpdate() == 1) continue;
            throw new RuntimeException();
        }
    }
}

