/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.tbox;

import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLGeneralConcept;
import com.clarkparsia.owlgres.concept.DLLGeneralConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLNot;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import com.clarkparsia.owlgres.tbox.StatisticsHandler;
import com.clarkparsia.owlgres.util.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLLTBox {
    private static final DLLAtomic TOP_CONCEPT = TermFactory.atomic("http://www.w3.org/2002/07/owl#Thing");
    private Map<DLLDataRole, Set<DLLDataRole>> dataRoleInclusions;
    private Map<String, DLLAtomic> nameToAtomic = new HashMap<String, DLLAtomic>();
    private Map<String, DLLDataRole> nameToDataRole;
    private Map<String, DLLBasicObjectRole> nameToObjectRole = new HashMap<String, DLLBasicObjectRole>();
    private Map<String, DLLAnnotationRoleBase> nameToAnnotationRole;
    private Map<DLLBasicConcept, Set<DLLBasicConcept>> negative;
    private boolean niClosed = true;
    private Map<DLLBasicObjectRole, Set<DLLObjectRole>> objectRoleInclusions;
    private Map<DLLBasicConcept, Set<DLLBasicConcept>> positive;
    private Map<DLLDataRole, Set<DLLDataRole>> revDataRole;
    private Map<DLLBasicConcept, Set<DLLBasicConcept>> revNegative;
    private Map<DLLBasicObjectRole, Set<DLLObjectRole>> revObjectRole;
    private Map<DLLBasicConcept, Set<DLLBasicConcept>> revPositive;
    private ConceptInclusionAdditionProcessor subclassAddProcessor;
    private ObjectRoleInclusionAdditionProcessor subroleAddProcessor;
    private StatisticsHandler statistics;

    public static DLLAtomic getTopConcept() {
        return TOP_CONCEPT;
    }

    public DLLTBox() {
        this.nameToDataRole = new HashMap<String, DLLDataRole>();
        this.nameToAnnotationRole = new HashMap<String, DLLAnnotationRoleBase>();
        this.positive = new HashMap<DLLBasicConcept, Set<DLLBasicConcept>>();
        this.negative = new HashMap<DLLBasicConcept, Set<DLLBasicConcept>>();
        this.revPositive = new HashMap<DLLBasicConcept, Set<DLLBasicConcept>>();
        this.revNegative = new HashMap<DLLBasicConcept, Set<DLLBasicConcept>>();
        this.objectRoleInclusions = new HashMap<DLLBasicObjectRole, Set<DLLObjectRole>>();
        this.dataRoleInclusions = new HashMap<DLLDataRole, Set<DLLDataRole>>();
        this.revObjectRole = new HashMap<DLLBasicObjectRole, Set<DLLObjectRole>>();
        this.revDataRole = new HashMap<DLLDataRole, Set<DLLDataRole>>();
        this.subclassAddProcessor = new ConceptInclusionAdditionProcessor();
        this.subroleAddProcessor = new ObjectRoleInclusionAdditionProcessor();
        this.statistics = new StatisticsHandler();
    }

    public boolean addAtomic(DLLAtomic a) {
        if (a == null) {
            throw new NullPointerException();
        }
        DLLAtomic old = this.nameToAtomic.put(a.getName(), a);
        if (old == null) {
            return true;
        }
        if (old.equals(a)) {
            return false;
        }
        throw new RuntimeException("Existing atomic with matching name");
    }

    public boolean addInclusion(DLLBasicConcept lft, DLLGeneralConcept rgt) {
        if (lft == null) {
            throw new NullPointerException();
        }
        if (rgt == null) {
            throw new NullPointerException();
        }
        return this.subclassAddProcessor.process(lft, rgt);
    }

    public boolean addInclusion(DLLDataRole lft, DLLDataRole rgt) {
        if (lft == null) {
            throw new NullPointerException();
        }
        if (rgt == null) {
            throw new NullPointerException();
        }
        return this.multiValueMapAdd(lft, rgt, this.dataRoleInclusions, this.revDataRole);
    }

    public boolean addInclusion(DLLObjectRole lft, DLLObjectRole rgt) {
        if (lft == null) {
            throw new NullPointerException();
        }
        if (rgt == null) {
            throw new NullPointerException();
        }
        return this.subroleAddProcessor.process(lft, rgt);
    }

    public boolean addRole(DLLBasicObjectRole r) {
        if (r == null) {
            throw new NullPointerException();
        }
        DLLBasicObjectRole old = this.nameToObjectRole.put(r.getName(), r);
        if (old == null) {
            return true;
        }
        if (old.equals(r)) {
            return false;
        }
        throw new RuntimeException("Existing role with matching name");
    }

    public boolean addRole(DLLDataRole r) {
        if (r == null) {
            throw new NullPointerException();
        }
        DLLDataRole old = this.nameToDataRole.put(r.getName(), r);
        if (old == null) {
            return true;
        }
        if (old.equals(r)) {
            return false;
        }
        throw new RuntimeException("Existing role with matching name");
    }

    public boolean addRole(DLLAnnotationRoleBase r) {
        if (r == null) {
            throw new NullPointerException();
        }
        DLLAnnotationRoleBase old = this.nameToAnnotationRole.put(r.getName(), r);
        if (old == null) {
            return true;
        }
        if (old.equals(r)) {
            return false;
        }
        throw new RuntimeException("Existing role with matching name");
    }

    public StatisticsHandler getStatisticsHandler() {
        return this.statistics;
    }

    private void closeNI() {
        boolean changed = true;
        while (changed) {
            changed = false;
            ArrayList<DLLBasicConcept> lftlst = new ArrayList<DLLBasicConcept>(this.positive.keySet());
            for (int i = 0; i < lftlst.size(); ++i) {
                DLLBasicConcept lft = (DLLBasicConcept)lftlst.get(i);
                Set<DLLBasicConcept> lftsNegatives = this.negative.get(lft);
                if (lftsNegatives == null) {
                    lftsNegatives = new HashSet<DLLBasicConcept>();
                    this.negative.put(lft, lftsNegatives);
                }
                Set<DLLBasicConcept> lftsPositives = this.positive.get(lft);
                ArrayList<DLLBasicConcept> rgts = new ArrayList<DLLBasicConcept>(lftsPositives);
                for (DLLBasicConcept rgt : rgts) {
                    Set<DLLBasicConcept> supersRevNegs;
                    Set<DLLBasicConcept> supersNegs = this.negative.get(rgt);
                    if (supersNegs != null && this.multiValueMapAddAll(lft, supersNegs, this.negative, this.revNegative)) {
                        changed = true;
                    }
                    if ((supersRevNegs = this.revNegative.get(rgt)) == null || !this.multiValueMapAddAll(lft, supersRevNegs, this.negative, this.revNegative)) continue;
                    changed = true;
                }
            }
        }
        this.niClosed = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DLLTBox) {
            DLLTBox other = (DLLTBox)obj;
            if (!((Object)this.nameToAtomic).equals(other.nameToAtomic)) {
                return false;
            }
            if (!((Object)this.nameToDataRole).equals(other.nameToDataRole)) {
                return false;
            }
            if (!((Object)this.nameToObjectRole).equals(other.nameToObjectRole)) {
                return false;
            }
            if (!((Object)this.nameToAnnotationRole).equals(other.nameToAnnotationRole)) {
                return false;
            }
            if (!((Object)this.positive).equals(other.positive)) {
                return false;
            }
            if (!((Object)this.negative).equals(other.negative)) {
                return false;
            }
            if (!((Object)this.dataRoleInclusions).equals(other.dataRoleInclusions)) {
                return false;
            }
            return ((Object)this.objectRoleInclusions).equals(other.objectRoleInclusions);
        }
        return false;
    }

    public DLLAtomic getAtomic(String name) {
        return this.nameToAtomic.get(name);
    }

    public Set<DLLAtomic> getAtomics() {
        return new CopyOnWriteArraySet<DLLAtomic>(this.nameToAtomic.values());
    }

    public DLLDataRole getDataRole(String name) {
        return this.nameToDataRole.get(name);
    }

    public Map<DLLDataRole, Set<DLLDataRole>> getDataRoleInclusions() {
        return Collections.unmodifiableMap(this.dataRoleInclusions);
    }

    public Set<DLLDataRole> getDataRoles() {
        return new CopyOnWriteArraySet<DLLDataRole>(this.nameToDataRole.values());
    }

    public Set<DLLAnnotationRoleBase> getBasicAnnotationRoles() {
        return new CopyOnWriteArraySet<DLLAnnotationRoleBase>(this.nameToAnnotationRole.values());
    }

    public DLLAnnotationRoleBase getAnnotationRole(String name) {
        return this.nameToAnnotationRole.get(name);
    }

    public Map<DLLBasicConcept, Set<DLLBasicConcept>> getNegativeInclusions() {
        return Collections.unmodifiableMap(this.negative);
    }

    public DLLBasicObjectRole getObjectRole(String name) {
        return this.nameToObjectRole.get(name);
    }

    public Map<DLLBasicObjectRole, Set<DLLObjectRole>> getObjectRoleInclusions() {
        return Collections.unmodifiableMap(this.objectRoleInclusions);
    }

    public Set<DLLBasicObjectRole> getObjectRoles() {
        return new CopyOnWriteArraySet<DLLBasicObjectRole>(this.nameToObjectRole.values());
    }

    public Map<DLLBasicConcept, Set<DLLBasicConcept>> getPositiveInclusions() {
        return Collections.unmodifiableMap(this.positive);
    }

    public Set<DLLBasicConcept> getPositiveInclusions(DLLBasicConcept c) {
        Set<DLLBasicConcept> ret = this.positive.get(c);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<DLLBasicConcept> getReverseInclusions(DLLBasicConcept c) {
        Set<DLLBasicConcept> ret = this.revPositive.get(c);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<DLLObjectRole> getReverseInclusions(DLLBasicObjectRole r) {
        Set<DLLObjectRole> ret = this.revObjectRole.get(r);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public Set<DLLDataRole> getReverseInclusions(DLLDataRole r) {
        Set<DLLDataRole> ret = this.revDataRole.get(r);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }

    public int size() {
        int size = 0;
        size += this.positive.size();
        size += this.negative.size();
        size += this.objectRoleInclusions.size();
        return size += this.dataRoleInclusions.size();
    }

    private <T, U> boolean multiValueMapAdd(T key, U value, Map<T, Set<U>> multiValueMap) {
        Set<U> existing = multiValueMap.get(key);
        if (existing == null) {
            existing = new HashSet<U>();
            multiValueMap.put(key, existing);
        }
        return existing.add(value);
    }

    private <T, U> boolean multiValueMapAdd(T key, U value, Map<T, Set<U>> multiValueMap, Map<U, Set<T>> reverse) {
        boolean ret = this.multiValueMapAdd(key, value, multiValueMap);
        if (ret) {
            this.multiValueMapAdd(value, key, reverse);
        }
        return ret;
    }

    private <T, U> boolean multiValueMapAddAll(T key, Collection<? extends U> values, Map<T, Set<U>> multiValueMap) {
        Set<U> existing = multiValueMap.get(key);
        if (existing == null) {
            existing = new HashSet<U>();
            multiValueMap.put(key, existing);
        }
        return existing.addAll(values);
    }

    private <T, U> boolean multiValueMapAddAll(T key, Collection<? extends U> values, Map<T, Set<U>> multiValueMap, Map<U, Set<T>> reverse) {
        boolean ret = this.multiValueMapAddAll(key, values, multiValueMap);
        if (ret) {
            for (U u : values) {
                this.multiValueMapAdd(u, key, reverse);
            }
        }
        return ret;
    }

    public void prepare() {
        if (!this.niClosed) {
            this.closeNI();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Atomics:\n\t");
        buf.append(this.getAtomics());
        buf.append("\nObject Roles:\n\t");
        buf.append(this.getObjectRoles());
        buf.append("\nData Roles:\n\t");
        buf.append(this.getDataRoles());
        buf.append("\nBasic Annotation Roles:\n\t");
        buf.append(this.getBasicAnnotationRoles());
        buf.append("\nPositive:\n\t");
        buf.append(this.positive.toString());
        buf.append("\nNegative:\n\t");
        buf.append(this.negative.toString());
        buf.append("\nObject Role Inclusions:\n\t");
        buf.append(this.objectRoleInclusions.toString());
        buf.append("\nData Role Inclusions:\n\t");
        buf.append(this.dataRoleInclusions.toString());
        buf.append("\n");
        return buf.toString();
    }

    private class ObjectRoleInclusionAdditionProcessor
    implements DLLObjectRoleVisitor {
        private boolean invert;
        private boolean isLeft;
        private DLLBasicObjectRole lft;
        private boolean ret;

        private ObjectRoleInclusionAdditionProcessor() {
        }

        public boolean process(DLLObjectRole lft, DLLObjectRole rgt) {
            this.isLeft = true;
            lft.accept(this);
            this.isLeft = false;
            rgt.accept(this);
            return this.ret;
        }

        public void visit(DLLBasicObjectRole r) {
            if (this.isLeft) {
                this.invert = false;
                this.lft = r;
            } else if (this.invert) {
                this.ret = DLLTBox.this.multiValueMapAdd(this.lft, TermFactory.inverseOf(r), DLLTBox.this.objectRoleInclusions);
                if (this.ret) {
                    DLLTBox.this.multiValueMapAdd(r, TermFactory.inverseOf(this.lft), DLLTBox.this.revObjectRole);
                }
            } else {
                this.ret = DLLTBox.this.multiValueMapAdd(this.lft, r, DLLTBox.this.objectRoleInclusions);
                if (this.ret) {
                    DLLTBox.this.multiValueMapAdd(r, this.lft, DLLTBox.this.revObjectRole);
                }
            }
        }

        public void visit(DLLInverseObjectRole r) {
            if (this.isLeft) {
                this.invert = true;
                this.lft = r.getBasicRole();
            } else if (this.invert) {
                this.ret = DLLTBox.this.multiValueMapAdd(this.lft, r.getBasicRole(), DLLTBox.this.objectRoleInclusions);
                if (this.ret) {
                    DLLTBox.this.multiValueMapAdd(r.getBasicRole(), this.lft, DLLTBox.this.revObjectRole);
                }
            } else {
                this.ret = DLLTBox.this.multiValueMapAdd(this.lft, r, DLLTBox.this.objectRoleInclusions);
                if (this.ret) {
                    DLLTBox.this.multiValueMapAdd(r.getBasicRole(), TermFactory.inverseOf(this.lft), DLLTBox.this.revObjectRole);
                }
            }
        }
    }

    private class ConceptInclusionAdditionProcessor
    implements DLLGeneralConceptVisitor {
        private DLLBasicConcept lft;
        private boolean ret;

        private ConceptInclusionAdditionProcessor() {
        }

        public boolean process(DLLBasicConcept lft, DLLGeneralConcept rgt) {
            this.lft = lft;
            rgt.accept(this);
            return this.ret;
        }

        public void visit(DLLBasicConcept c) {
            this.ret = DLLTBox.this.multiValueMapAdd(this.lft, c, DLLTBox.this.positive, DLLTBox.this.revPositive);
        }

        public void visit(DLLNot c) {
            this.ret = DLLTBox.this.multiValueMapAdd(this.lft, c.getBasicConcept(), DLLTBox.this.negative, DLLTBox.this.revNegative);
        }
    }
}

