/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.tbox;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLNamedEntity;
import com.clarkparsia.owlgres.DLLNamedEntityVisitor;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsHandler {
    private Map<DLLNamedEntity, Integer> statistics = new HashMap<DLLNamedEntity, Integer>();

    public void set(DLLNamedEntity e, Integer f) {
        this.statistics.put(e, f);
    }

    public Integer selectivity(DLLNamedEntity e) {
        SelectivityVisitor visitor = new SelectivityVisitor();
        e.accept(visitor);
        return visitor.getSelectivity();
    }

    public boolean hasZeroSelectivity(DLLNamedEntity e) {
        return this.selectivity(e) == 0;
    }

    public void increment(DLLObjectRole r) {
        r.accept(new IncrementObjectRoleVisitor());
    }

    public void increment(DLLNamedEntity e) {
        Integer f = 0;
        if (this.statistics.containsKey(e)) {
            f = this.statistics.get(e);
        }
        f = f + 1;
        this.statistics.put(e, f);
    }

    public Iterator<DLLNamedEntity> entities() {
        return this.statistics.keySet().iterator();
    }

    public String toString() {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        for (DLLNamedEntity e : this.statistics.keySet()) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(e + "=" + this.statistics.get(e));
            first = false;
        }
        buf.append(" }");
        return buf.toString();
    }

    private class SelectivityVisitor
    implements DLLNamedEntityVisitor {
        private Integer selectivity = 0;

        public Integer getSelectivity() {
            return this.selectivity;
        }

        public void visit(DLLAtomic e) {
            if (StatisticsHandler.this.statistics.containsKey(e)) {
                this.selectivity = (Integer)StatisticsHandler.this.statistics.get(e);
            }
        }

        public void visit(DLLIndividual e) {
        }

        public void visit(DLLBasicObjectRole e) {
            if (StatisticsHandler.this.statistics.containsKey(e)) {
                this.selectivity = (Integer)StatisticsHandler.this.statistics.get(e);
            }
        }

        public void visit(DLLDataRole e) {
            if (StatisticsHandler.this.statistics.containsKey(e)) {
                this.selectivity = (Integer)StatisticsHandler.this.statistics.get(e);
            }
        }

        public void visit(DLLAnnotationRoleBase r) {
            if (StatisticsHandler.this.statistics.containsKey(r)) {
                this.selectivity = (Integer)StatisticsHandler.this.statistics.get(r);
            }
        }
    }

    private class IncrementObjectRoleVisitor
    implements DLLObjectRoleVisitor {
        private IncrementObjectRoleVisitor() {
        }

        public void visit(DLLBasicObjectRole r) {
            StatisticsHandler.this.increment(r);
        }

        public void visit(DLLInverseObjectRole r) {
            StatisticsHandler.this.increment(r.getBasicRole());
        }
    }
}

