/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.util;

import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLBasicConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLDataExistential;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAnnotation;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.query.VariableImpl;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactory {
    private static ConceptAtomMaker conceptAtomMaker = new ConceptAtomMaker();
    private static long nonDistMintIndex;
    private static final String nonDistMintPrefix = "ndv";
    private static ObjectRoleAtomMaker roleAtomMaker;
    private static Variable theExistentialVar;

    public static QueryAtom atom(DLLBasicConcept c, QueryIndividual i) {
        return conceptAtomMaker.getAtom(c, i);
    }

    public static DataRoleAtom atom(DLLDataRole a, QueryIndividual i, QueryLiteral v) {
        return new DataRoleAtom(a, i, v);
    }

    public static ObjectRoleAtom atom(DLLObjectRole r, QueryIndividual s, QueryIndividual o) {
        return roleAtomMaker.getAtom(r, s, o);
    }

    public static AnnotationRoleAtom atom(DLLAnnotationRoleBase r, QueryIndividual s, QueryAnnotation o) {
        return new AnnotationRoleAtom(r, s, o);
    }

    public static Variable distVar(String s) {
        return new VariableImpl(s, true);
    }

    public static Variable nonDistVar() {
        return new VariableImpl(nonDistMintPrefix + nonDistMintIndex++, false);
    }

    public static Variable nonDistVar(String s) {
        return new VariableImpl(s, false);
    }

    public static ConjunctiveQuery reformulateQuery(Collection<QueryAtom> atoms) {
        return new ConjunctiveQuery(atoms);
    }

    public static ConjunctiveQuery reformulateQuery(QueryAtom ... atoms) {
        return new ConjunctiveQuery(atoms);
    }

    public static Variable theExistentialVar() {
        if (theExistentialVar == null) {
            theExistentialVar = QueryFactory.nonDistVar("_");
        }
        return theExistentialVar;
    }

    static {
        roleAtomMaker = new ObjectRoleAtomMaker();
        nonDistMintIndex = 0L;
    }

    private static class ObjectRoleAtomMaker
    implements DLLObjectRoleVisitor {
        private ObjectRoleAtom atom;
        private QueryIndividual o;
        private QueryIndividual s;

        private ObjectRoleAtomMaker() {
        }

        public ObjectRoleAtom getAtom(DLLObjectRole role, QueryIndividual s, QueryIndividual o) {
            this.s = s;
            this.o = o;
            role.accept(this);
            return this.atom;
        }

        public void visit(DLLBasicObjectRole r) {
            this.atom = new ObjectRoleAtom(r, this.s, this.o);
        }

        public void visit(DLLInverseObjectRole r) {
            this.atom = new ObjectRoleAtom(r.getBasicRole(), this.o, this.s);
        }
    }

    private static class ConceptAtomMaker
    implements DLLBasicConceptVisitor {
        private QueryAtom atom;
        private QueryIndividual i;

        private ConceptAtomMaker() {
        }

        public QueryAtom getAtom(DLLBasicConcept c, QueryIndividual i) {
            this.i = i;
            c.accept(this);
            return this.atom;
        }

        public void visit(DLLAtomic c) {
            this.atom = new AtomicAtom(c, this.i);
        }

        public void visit(DLLDataExistential c) {
            this.atom = QueryFactory.atom(c.getRole(), this.i, QueryFactory.nonDistVar());
        }

        public void visit(DLLObjectExistential c) {
            this.atom = QueryFactory.atom(c.getRole(), this.i, QueryFactory.nonDistVar());
        }
    }
}

