/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.util;

import com.clarkparsia.owlgres.query.AnnotationRoleAtom;
import com.clarkparsia.owlgres.query.AtomicAtom;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.DataRoleAtom;
import com.clarkparsia.owlgres.query.NegatedAtom;
import com.clarkparsia.owlgres.query.ObjectRoleAtom;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryAtomVisitor;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.util.QueryFactory;
import java.util.Set;

public class QueryUtils {
    private static QueryAtomReplacer atomReplacer = new QueryAtomReplacer();

    public static ConjunctiveQuery replaceAllUnbound(ConjunctiveQuery q) {
        if (q == null) {
            throw new NullPointerException();
        }
        for (Variable v : q.getNonDistinguishedVars().toArray(new Variable[0])) {
            Set<QueryAtom> atoms;
            if (v.equals(QueryFactory.theExistentialVar()) || (atoms = q.getAtoms(v)).size() != 1) continue;
            QueryAtom a = atoms.iterator().next();
            QueryAtom b = atomReplacer.replace(a, v, QueryFactory.theExistentialVar());
            q = QueryUtils.replaceAtom(q, a, b);
        }
        return q;
    }

    public static ConjunctiveQuery replaceAtom(ConjunctiveQuery q, QueryAtom a, QueryAtom b) {
        if (q == null) {
            throw new NullPointerException();
        }
        if (a == null) {
            throw new NullPointerException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        ConjunctiveQuery ret = q.copy();
        if (!ret.remove(a)) {
            throw new RuntimeException("Could not remove " + a + " from " + q);
        }
        ret.add(b);
        return ret;
    }

    private static class QueryAtomReplacer
    implements QueryAtomVisitor {
        private QueryAtom atom;
        private Variable find;
        private Variable replace;

        private QueryAtomReplacer() {
        }

        public QueryAtom replace(QueryAtom atom, Variable find, Variable replace) {
            this.atom = atom;
            this.find = find;
            this.replace = replace;
            atom.accept(this);
            return this.atom;
        }

        public void visit(AtomicAtom a) {
            if (a.getIndividual().equals(this.find)) {
                this.atom = QueryFactory.atom(a.getAtomic(), this.replace);
            }
        }

        public void visit(DataRoleAtom a) {
            boolean change = false;
            QueryIndividual individual = a.getIndividual();
            QueryLiteral value = a.getValue();
            if (individual.equals(this.find)) {
                change = true;
                individual = this.replace;
            }
            if (value.equals(this.find)) {
                change = true;
                value = this.replace;
            }
            if (change) {
                this.atom = QueryFactory.atom(a.getRole(), individual, value);
            }
        }

        public void visit(NegatedAtom a) {
            throw new UnsupportedOperationException();
        }

        public void visit(ObjectRoleAtom a) {
            boolean change = false;
            QueryIndividual subject = a.getSubject();
            QueryIndividual object = a.getObject();
            if (subject.equals(this.find)) {
                change = true;
                subject = this.replace;
            }
            if (object.equals(this.find)) {
                change = true;
                object = this.replace;
            }
            if (change) {
                this.atom = QueryFactory.atom(a.getRole(), subject, object);
            }
        }

        public void visit(AnnotationRoleAtom a) {
        }
    }
}

