/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.util;

import com.clarkparsia.owlgres.DLLAnnotation;
import com.clarkparsia.owlgres.DLLAnnotationIndividual;
import com.clarkparsia.owlgres.DLLAnnotationLiteral;
import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.abox.DLLConceptAssertion;
import com.clarkparsia.owlgres.abox.DLLConstantAnnotationAssertion;
import com.clarkparsia.owlgres.abox.DLLDataRoleAssertion;
import com.clarkparsia.owlgres.abox.DLLObjectAnnotationAssertion;
import com.clarkparsia.owlgres.abox.DLLObjectRoleAssertion;
import com.clarkparsia.owlgres.abox.DLLSameIndividualAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLDataExistential;
import com.clarkparsia.owlgres.concept.DLLGeneralConcept;
import com.clarkparsia.owlgres.concept.DLLGeneralConceptVisitor;
import com.clarkparsia.owlgres.concept.DLLNot;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLInverseObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.role.DLLObjectRoleVisitor;
import java.util.WeakHashMap;

public class TermFactory {
    private static WeakHashMap<String, DLLIndividual> individualMap = new WeakHashMap();
    private static NegatingConceptVisitor conceptNegator;
    private static ObjectRoleAssertionMaker roleAssertionMaker;
    private static InvertingRoleVisitor roleInverter;

    public static DLLConceptAssertion assertion(DLLAtomic atomic, DLLIndividual individual) {
        return new DLLConceptAssertion(atomic, individual);
    }

    public static DLLDataRoleAssertion assertion(DLLDataRole role, DLLIndividual subject, String object) {
        return TermFactory.assertion(role, subject, TermFactory.literal(object));
    }

    public static DLLDataRoleAssertion assertion(DLLDataRole role, DLLIndividual subject, DLLLiteral object) {
        return new DLLDataRoleAssertion(role, subject, object);
    }

    public static DLLSameIndividualAssertion assertionSameAs(DLLIndividual subject, DLLIndividual object) {
        return new DLLSameIndividualAssertion(subject, object);
    }

    public static DLLObjectRoleAssertion assertion(DLLObjectRole role, DLLIndividual subject, DLLIndividual object) {
        if (roleAssertionMaker == null) {
            roleAssertionMaker = new ObjectRoleAssertionMaker();
        }
        return roleAssertionMaker.makeAssertion(role, subject, object);
    }

    public static DLLObjectAnnotationAssertion objectAnnotationAssertion(DLLAnnotationRoleBase role, DLLIndividual subject, DLLIndividual object) {
        return new DLLObjectAnnotationAssertion(role, subject, object);
    }

    public static DLLConstantAnnotationAssertion constantAnnotationAssertion(DLLAnnotationRoleBase role, DLLIndividual subject, DLLLiteral object) {
        return new DLLConstantAnnotationAssertion(role, subject, object);
    }

    public static DLLConstantAnnotationAssertion constantAnnotationAssertion(DLLAnnotationRoleBase role, DLLIndividual subject, String object) {
        return new DLLConstantAnnotationAssertion(role, subject, TermFactory.literal(object));
    }

    public static DLLAtomic atomic(String name) {
        return new DLLAtomic(name);
    }

    public static DLLDataRole dataRole(String name) {
        return new DLLDataRole(name);
    }

    public static DLLAnnotationRoleBase annotationRole(String name) {
        return new DLLAnnotationRoleBase(name);
    }

    public static DLLDataExistential existential(DLLDataRole role) {
        return new DLLDataExistential(role);
    }

    public static DLLObjectExistential existential(DLLObjectRole role) {
        return new DLLObjectExistential(role);
    }

    public static DLLIndividual individual(String name) {
        DLLIndividual i = individualMap.get(name);
        if (i == null) {
            i = new DLLIndividual(name);
            individualMap.put(name, i);
        }
        return i;
    }

    public static DLLAnnotation annotation(String name) {
        return new DLLAnnotationIndividual(name);
    }

    public static DLLAnnotation annotation(String value, Datatype datatype) {
        return new DLLAnnotationLiteral(value, datatype);
    }

    public static DLLAnnotation annotation(String value, String language) {
        return new DLLAnnotationLiteral(value, language);
    }

    public static DLLAnnotation annotation(DLLLiteral literal) {
        return new DLLAnnotationLiteral(literal);
    }

    public static DLLObjectRole inverseOf(DLLObjectRole role) {
        if (roleInverter == null) {
            roleInverter = new InvertingRoleVisitor();
        }
        return roleInverter.getInverse(role);
    }

    public static DLLGeneralConcept negationOf(DLLGeneralConcept concept) {
        if (conceptNegator == null) {
            conceptNegator = new NegatingConceptVisitor();
        }
        return conceptNegator.getNegation(concept);
    }

    public static DLLBasicObjectRole objectRole(String name) {
        return TermFactory.objectRole(name, false);
    }

    public static DLLBasicObjectRole objectRole(String name, boolean auxiliary) {
        return new DLLBasicObjectRole(name, auxiliary);
    }

    public static DLLLiteral literal(String name) {
        return TermFactory.plainLiteral(name);
    }

    public static DLLLiteral literal(String name, String language) {
        return TermFactory.plainLiteral(name, language);
    }

    public static DLLLiteral literal(String name, Datatype datatype) {
        return TermFactory.typedLiteral(name, datatype);
    }

    public static DLLLiteral plainLiteral(String name) {
        return new DLLPlainLiteral(name);
    }

    public static DLLLiteral plainLiteral(String name, String language) {
        return new DLLPlainLiteral(name, language);
    }

    public static DLLLiteral typedLiteral(String name, Datatype datatype) {
        return new DLLTypedLiteral(name, datatype);
    }

    private static class ObjectRoleAssertionMaker
    implements DLLObjectRoleVisitor {
        private DLLObjectRoleAssertion assertion;
        private DLLIndividual object;
        private DLLIndividual subject;

        private ObjectRoleAssertionMaker() {
        }

        public DLLObjectRoleAssertion makeAssertion(DLLObjectRole role, DLLIndividual subject, DLLIndividual object) {
            this.subject = subject;
            this.object = object;
            role.accept(this);
            return this.assertion;
        }

        public void visit(DLLBasicObjectRole r) {
            this.assertion = new DLLObjectRoleAssertion(r, this.subject, this.object);
        }

        public void visit(DLLInverseObjectRole r) {
            this.assertion = new DLLObjectRoleAssertion(r.getBasicRole(), this.object, this.subject);
        }
    }

    private static class NegatingConceptVisitor
    implements DLLGeneralConceptVisitor {
        private DLLGeneralConcept negation;

        private NegatingConceptVisitor() {
        }

        public DLLGeneralConcept getNegation(DLLGeneralConcept concept) {
            concept.accept(this);
            return this.negation;
        }

        public void visit(DLLBasicConcept c) {
            this.negation = new DLLNot(c);
        }

        public void visit(DLLNot c) {
            this.negation = c.getBasicConcept();
        }
    }

    private static class InvertingRoleVisitor
    implements DLLObjectRoleVisitor {
        private DLLObjectRole inverse;

        private InvertingRoleVisitor() {
        }

        public DLLObjectRole getInverse(DLLObjectRole r) {
            r.accept(this);
            return this.inverse;
        }

        public void visit(DLLBasicObjectRole r) {
            this.inverse = new DLLInverseObjectRole(r);
        }

        public void visit(DLLInverseObjectRole r) {
            this.inverse = r.getBasicRole();
        }
    }
}

