/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.jena;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLKB;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DLLPlainLiteral;
import com.clarkparsia.owlgres.DLLTypedLiteral;
import com.clarkparsia.owlgres.jena.QueryConverter;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryResultSet;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLLQueryExecution
implements QueryExecution {
    public static final Log log = LogFactory.getLog(DLLQueryExecution.class);
    private StoreBase store;
    private DLLKB kb;
    private DLLTBox tbox;
    private Query query;
    private Collection<Variable> resultVars;
    private Collection<Expr> unconvertedConstraints;

    public DLLQueryExecution(DLLKB kb, Query query, Collection<Variable> resultVars, Collection<Expr> unconvertedConstraints) {
        if (kb == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            throw new NullPointerException();
        }
        if (resultVars == null) {
            throw new NullPointerException();
        }
        if (unconvertedConstraints == null) {
            throw new NullPointerException();
        }
        this.kb = kb;
        this.query = query;
        this.resultVars = resultVars;
        this.unconvertedConstraints = unconvertedConstraints;
    }

    public DLLQueryExecution(Store store, com.hp.hpl.jena.query.Query query) {
        if (store == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            throw new NullPointerException();
        }
        this.store = (StoreBase)store;
        this.kb = this.store.getKB();
        this.tbox = this.store.getTBox();
        this.resultVars = new HashSet<Variable>();
        this.unconvertedConstraints = new LinkedHashSet<Expr>();
        QueryConverter converter = new QueryConverter(this.tbox);
        this.query = converter.convert(query, this.resultVars, this.unconvertedConstraints);
    }

    public void abort() {
    }

    public void close() {
    }

    public boolean execAsk() {
        log.warn((Object)"ASK query unsupported");
        throw new UnsupportedOperationException();
    }

    public Model execConstruct() {
        log.warn((Object)"CONSTRUCT query unsupported");
        throw new UnsupportedOperationException();
    }

    public Model execConstruct(Model model) {
        log.warn((Object)"CONSTRUCT query unsupported");
        throw new UnsupportedOperationException();
    }

    public Model execDescribe() {
        log.warn((Object)"DESCRIBE query unsupported");
        throw new UnsupportedOperationException();
    }

    public Model execDescribe(Model model) {
        log.warn((Object)"DESCRIBE query unsupported");
        throw new UnsupportedOperationException();
    }

    public ResultSet execSelect() {
        QueryResultSet result;
        log.debug((Object)("SELECT query: " + this.query.toString()));
        try {
            result = this.kb.query(this.query, this.resultVars);
        }
        catch (RuntimeException e) {
            log.error((Object)"Query failed, exception caught", (Throwable)e);
            throw e;
        }
        return new MyResultSet(result, this.query, this.unconvertedConstraints);
    }

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException();
    }

    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException();
    }

    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyResultSet
    implements ResultSet {
        private int index;
        private List<String> vars;
        private Collection<Expr> filters;
        private List<Binding> bindings;
        private Iterator<Binding> iterator;

        public MyResultSet(QueryResultSet res, Query query, Collection<Expr> filters) {
            if (res == null) {
                throw new NullPointerException();
            }
            if (query == null) {
                throw new NullPointerException();
            }
            if (filters == null) {
                throw new NullPointerException();
            }
            this.filters = filters;
            this.bindings = new ArrayList<Binding>();
            this.index = -1;
            this.vars = res.isEmpty() ? Collections.emptyList() : res.getColums();
            while (res.hasNext()) {
                MyBinding binding = new MyBinding(res.next());
                if (!this.isSatisfied(binding)) continue;
                this.bindings.add(binding);
            }
            this.iterator = this.bindings.iterator();
        }

        public List<String> getResultVars() {
            return this.vars;
        }

        public int getRowNumber() {
            return this.index;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean isOrdered() {
            return false;
        }

        public Object next() {
            return this.nextBinding();
        }

        public Binding nextBinding() {
            return this.iterator.next();
        }

        public QuerySolution nextSolution() {
            return new ResultBinding(null, this.nextBinding());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean isSatisfied(Binding binding) {
            boolean ret = true;
            for (Expr e : this.filters) {
                ret = e.isSatisfied(binding, null);
            }
            return ret;
        }
    }

    private class MyBinding
    implements Binding {
        private Map<Var, Object> bind;

        public MyBinding(com.clarkparsia.owlgres.query.QuerySolution solution) {
            if (solution == null) {
                throw new NullPointerException();
            }
            this.bind = new HashMap<Var, Object>();
            for (Variable v : solution.getVariables()) {
                this.bind.put(Var.alloc((String)Var.canonical((String)v.toString())), solution.get(v));
            }
        }

        public void add(Var var, Node node) {
            throw new UnsupportedOperationException();
        }

        public void addAll(Binding key) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Var var) {
            return this.bind.containsKey(var);
        }

        public Node get(Var var) {
            Object o = this.bind.get(var);
            if (o == null) {
                return null;
            }
            if (o instanceof DLLIndividual) {
                DLLIndividual i = (DLLIndividual)o;
                return Node.createURI((String)i.getName());
            }
            if (o instanceof DLLLiteral) {
                DLLLiteral i = (DLLLiteral)o;
                if (i.isTyped()) {
                    Datatype datatype = ((DLLTypedLiteral)i).getDatatype();
                    XSDDatatype xsd = new XSDDatatype(datatype.getURI().toASCIIString());
                    Node node = Node.createLiteral((String)i.getValue(), null, (RDFDatatype)xsd);
                    return node;
                }
                String language = ((DLLPlainLiteral)i).getLanguage();
                Node node = Node.createLiteral((String)i.getValue(), (String)language, null);
                return node;
            }
            log.error((Object)"Unexpected variable binding");
            throw new RuntimeException();
        }

        public Binding getParent() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.bind.isEmpty();
        }

        public int size() {
            return this.bind.size();
        }

        public Iterator vars() {
            return Collections.unmodifiableSet(this.bind.keySet()).iterator();
        }
    }
}

