/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.jena;

import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.query.ConjunctiveQuery;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.query.OrderCondition;
import com.clarkparsia.owlgres.query.Query;
import com.clarkparsia.owlgres.query.QueryAnnotation;
import com.clarkparsia.owlgres.query.QueryAtom;
import com.clarkparsia.owlgres.query.QueryIndividual;
import com.clarkparsia.owlgres.query.QueryLiteral;
import com.clarkparsia.owlgres.query.Variable;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.QueryFactory;
import com.clarkparsia.owlgres.util.TermFactory;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementUnsaid;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryConverter {
    private DLLTBox tbox;
    private Map<String, Variable> vars;

    public QueryConverter(DLLTBox tbox) {
        if (tbox == null) {
            throw new NullPointerException();
        }
        this.tbox = tbox;
    }

    public Query convert(com.hp.hpl.jena.query.Query query, Collection<Variable> resultVars, Collection<Expr> unconvertedConstraints) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (resultVars == null) {
            throw new NullPointerException();
        }
        if (!resultVars.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (unconvertedConstraints == null) {
            throw new NullPointerException();
        }
        if (!unconvertedConstraints.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ConvertingElementVisitor converter = new ConvertingElementVisitor();
        if (query.isAskType()) {
            throw new UnsupportedOperationException();
        }
        if (query.isConstructType()) {
            throw new UnsupportedOperationException();
        }
        if (query.isDescribeType()) {
            throw new UnsupportedOperationException();
        }
        if (query.isUnknownType()) {
            throw new UnsupportedOperationException();
        }
        List resVars = query.getResultVars();
        this.vars = new HashMap<String, Variable>(resVars.size());
        for (String name : resVars) {
            Variable v = QueryFactory.distVar((String)name);
            this.vars.put(name, v);
            resultVars.add(v);
        }
        Element pattern = query.getQueryPattern();
        Set<QueryAtom> qas = converter.getAtoms(pattern);
        unconvertedConstraints.addAll(converter.getFilters(pattern));
        ConjunctiveQuery rq = QueryFactory.reformulateQuery(qas);
        Query q = new Query(rq);
        q.setLimit(query.getLimit());
        q.setOffset(query.getOffset());
        q.setDistinct(query.isDistinct());
        if (query.hasOrderBy()) {
            ArrayList<OrderCondition> orderBy = new ArrayList<OrderCondition>();
            for (SortCondition condition : query.getOrderBy()) {
                Expr expr = condition.getExpression();
                int direction = condition.getDirection();
                if (!expr.isVariable()) continue;
                Variable v = this.vars.get(expr.getVarName());
                if (direction == -1) {
                    orderBy.add(new OrderCondition(v, "DESC"));
                    continue;
                }
                orderBy.add(new OrderCondition(v, "ASC"));
            }
            q.setOrderBy(orderBy);
        }
        return q;
    }

    private Variable getVariable(String name, boolean distinguished) {
        Variable v = this.vars.get(name);
        if (v == null) {
            v = distinguished ? QueryFactory.distVar((String)name) : QueryFactory.nonDistVar((String)name);
            this.vars.put(name, v);
        }
        return v;
    }

    public DLLLiteral getLiteral(String literal, String type, String language) {
        if (type != null) {
            return TermFactory.literal((String)literal, (Datatype)new Datatype(type));
        }
        if (language != null) {
            return TermFactory.literal((String)literal, (String)language);
        }
        return TermFactory.literal((String)literal);
    }

    private DLLAtomic nodeToAtomic(Node n) {
        if (!n.isURI()) {
            throw new UnsupportedOperationException();
        }
        String clsUri = n.getURI();
        DLLAtomic atomic = this.tbox.getAtomic(clsUri);
        if (atomic == null) {
            throw new NullPointerException();
        }
        return atomic;
    }

    private DLLDataRole nodeToDataRole(Node n) {
        if (!n.isURI()) {
            throw new UnsupportedOperationException();
        }
        return this.tbox.getDataRole(n.getURI());
    }

    private DLLBasicObjectRole nodeToObjectRole(Node n) {
        if (!n.isURI()) {
            throw new UnsupportedOperationException();
        }
        return this.tbox.getObjectRole(n.getURI());
    }

    private DLLAnnotationRoleBase nodeToAnnotationRole(Node n) {
        if (!n.isURI()) {
            throw new UnsupportedOperationException();
        }
        return this.tbox.getAnnotationRole(n.getURI());
    }

    private QueryIndividual nodeToQueryIndividual(Node n) {
        Variable individual;
        if (n.isVariable()) {
            individual = this.getVariable(n.getName(), true);
        } else if (n.isBlank()) {
            individual = this.getVariable(n.getBlankNodeLabel(), false);
        } else if (n.isURI()) {
            individual = TermFactory.individual((String)n.getURI());
        } else {
            throw new UnsupportedOperationException();
        }
        return individual;
    }

    private QueryLiteral nodeToQueryLiteral(Node n) {
        Variable literal;
        if (n.isVariable()) {
            literal = this.getVariable(n.getName(), true);
        } else if (n.isBlank()) {
            literal = this.getVariable(n.getBlankNodeLabel(), false);
        } else if (n.isLiteral()) {
            literal = this.getLiteral(n.getLiteralLexicalForm(), n.getLiteralDatatypeURI(), n.getLiteralLanguage());
        } else {
            throw new UnsupportedOperationException();
        }
        return literal;
    }

    private QueryAnnotation nodeToQueryAnnotation(Node n) {
        Variable annotation;
        if (n.isVariable()) {
            annotation = this.getVariable(n.getName(), true);
        } else if (n.isBlank()) {
            annotation = this.getVariable(n.getBlankNodeLabel(), false);
        } else if (n.isLiteral()) {
            annotation = TermFactory.annotation((DLLLiteral)this.getLiteral(n.getLiteralLexicalForm(), n.getLiteralDatatypeURI(), n.getLiteralLanguage()));
        } else if (n.isURI()) {
            annotation = TermFactory.annotation((String)n.getURI());
        } else {
            throw new UnsupportedOperationException();
        }
        return annotation;
    }

    private QueryAtom tripleToAtom(Triple t) {
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        if (p.equals((Object)RDF.type.asNode())) {
            DLLAtomic atomic = this.nodeToAtomic(o);
            QueryIndividual individual = this.nodeToQueryIndividual(s);
            return QueryFactory.atom((DLLBasicConcept)atomic, (QueryIndividual)individual);
        }
        DLLBasicObjectRole or = this.nodeToObjectRole(p);
        if (or != null) {
            QueryIndividual subject = this.nodeToQueryIndividual(s);
            QueryIndividual object = this.nodeToQueryIndividual(o);
            return QueryFactory.atom((DLLObjectRole)or, (QueryIndividual)subject, (QueryIndividual)object);
        }
        DLLDataRole dr = this.nodeToDataRole(p);
        if (dr != null) {
            QueryIndividual individual = this.nodeToQueryIndividual(s);
            QueryLiteral value = this.nodeToQueryLiteral(o);
            return QueryFactory.atom((DLLDataRole)dr, (QueryIndividual)individual, (QueryLiteral)value);
        }
        DLLAnnotationRoleBase ar = this.nodeToAnnotationRole(p);
        if (ar != null) {
            QueryIndividual individual = this.nodeToQueryIndividual(s);
            QueryAnnotation annotation = this.nodeToQueryAnnotation(o);
            return QueryFactory.atom((DLLAnnotationRoleBase)ar, (QueryIndividual)individual, (QueryAnnotation)annotation);
        }
        throw new NullPointerException("Unable to find type of property: " + p);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertingElementVisitor
    implements ElementVisitor {
        private Set<QueryAtom> atoms;
        private Set<Expr> filters;

        private ConvertingElementVisitor() {
        }

        public Set<QueryAtom> getAtoms(Element e) {
            this.atoms = new HashSet<QueryAtom>();
            e.visit((ElementVisitor)this);
            return this.atoms;
        }

        public Set<Expr> getFilters(Element e) {
            this.filters = new HashSet<Expr>();
            e.visit((ElementVisitor)this);
            return this.filters;
        }

        public void visit(ElementDataset el) {
            throw new UnsupportedOperationException();
        }

        public void visit(ElementFilter el) {
            if (this.filters != null) {
                this.filters.add(el.getExpr());
            }
        }

        public void visit(ElementGroup el) {
            List l = el.getElements();
            for (Element e : l) {
                e.visit((ElementVisitor)this);
            }
        }

        public void visit(ElementNamedGraph el) {
            throw new UnsupportedOperationException();
        }

        public void visit(ElementOptional el) {
            throw new UnsupportedOperationException();
        }

        public void visit(ElementTriplesBlock el) {
            Iterator i = el.triples();
            while (i.hasNext()) {
                Triple t = (Triple)i.next();
                QueryAtom q = QueryConverter.this.tripleToAtom(t);
                this.atoms.add(q);
            }
        }

        public void visit(ElementUnion el) {
            throw new UnsupportedOperationException();
        }

        public void visit(ElementUnsaid el) {
            throw new UnsupportedOperationException();
        }
    }
}

