/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.joseki;

import com.clarkparsia.owlgres.DLLKB;
import com.clarkparsia.owlgres.jena.DLLQueryExecution;
import com.clarkparsia.owlgres.jena.QueryConverter;
import com.clarkparsia.owlgres.query.Variable;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.sparql.expr.Expr;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joseki.processors.SPARQL;

public class DLLJosekiProcessor
extends SPARQL {
    private static DLLKB kb;
    public static final Log log;
    private QueryConverter converter;

    public static void setKB(DLLKB kb) {
        if (kb == null) {
            throw new NullPointerException();
        }
        DLLJosekiProcessor.kb = kb;
    }

    public DLLJosekiProcessor() {
        if (kb == null) {
            throw new NullPointerException();
        }
        this.converter = new QueryConverter(kb.getTBox());
    }

    protected QueryExecution getQueryExecution(Query query, Dataset dataset) {
        com.clarkparsia.owlgres.query.Query qprime;
        HashSet<Variable> resultVars = new HashSet<Variable>();
        LinkedHashSet<Expr> unconvertedConstraints = new LinkedHashSet<Expr>();
        try {
            qprime = this.converter.convert(query, resultVars, unconvertedConstraints);
        }
        catch (RuntimeException e) {
            log.error((Object)"Failure converting query", (Throwable)e);
            throw e;
        }
        return new DLLQueryExecution(kb, qprime, resultVars, unconvertedConstraints);
    }

    static {
        log = LogFactory.getLog(DLLJosekiProcessor.class);
    }
}

