/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres;

import com.clarkparsia.owlgres.ABoxOnlyConsumer;
import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLKB;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.DefaultAxiomVisitor;
import com.clarkparsia.owlgres.DefaultDescriptionVisitor;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.store.Store;
import com.clarkparsia.owlgres.store.connection.StoreConnection;
import com.clarkparsia.owlgres.store.impl.StoreBase;
import com.clarkparsia.owlgres.util.TermFactory;
import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ABoxLoader {
    public static final Log log = LogFactory.getLog(ABoxLoader.class);
    private ABoxAxiomProcessor axiomProcessor;
    private DescriptionConverter descConverter;
    private ObjectRoleConverter roleConverter;
    private StoreConnection storeConnection;
    private StoreBase store;
    private DLLKB kb;
    private boolean isConsistent;

    public ABoxLoader(Store store) {
        this.store = (StoreBase)store;
        this.storeConnection = this.store.getStoreConnection();
        this.kb = this.store.getKB();
        this.isConsistent = false;
    }

    public static ABoxLoader get(Store store) {
        return new ABoxLoader(store);
    }

    public boolean load(String aboxURI) {
        return this.load(aboxURI, true);
    }

    public boolean load(String aboxURI, boolean checkConsistency) {
        RDFParser parser = new RDFParser();
        ABoxOnlyConsumer consumer = new ABoxOnlyConsumer(this.kb);
        try {
            if (!aboxURI.startsWith("file://")) {
                aboxURI = "file://" + aboxURI;
            }
            InputSource source = new InputSource(new FileInputStream(aboxURI.substring(7)));
            source.setSystemId(aboxURI);
            try {
                this.storeConnection.beginTransaction();
                parser.parse(source, (RDFConsumer)consumer);
                if (checkConsistency) {
                    this.isConsistent = this.kb.isConsistent();
                    if (this.isConsistent) {
                        this.storeConnection.endTransaction();
                    } else {
                        this.storeConnection.rollbackTransaction();
                    }
                } else {
                    this.isConsistent = true;
                    this.storeConnection.endTransaction();
                }
                if (this.isConsistent) {
                    this.store.updateStatistics();
                }
            }
            catch (SAXException e) {
                System.err.println("Failure for file, skipping: " + aboxURI);
                e.printStackTrace();
                this.storeConnection.rollbackTransaction();
            }
            catch (IOException e) {
                System.err.println("IOException for file, skipping: " + aboxURI);
                e.printStackTrace();
                this.storeConnection.rollbackTransaction();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found, skipping: " + aboxURI);
        }
        return this.isConsistent;
    }

    public void addABoxAxioms(OWLOntology ontology) {
        for (OWLIndividualAxiom a : ontology.getIndividualAxioms()) {
            try {
                this.axiomProcessor.process(a);
            }
            catch (RuntimeException e) {
                log.error((Object)("Runtime exception while processing axiom: " + a));
                throw e;
            }
        }
        this.kb.addAssertions(this.axiomProcessor.getAssertions());
    }

    private DLLAtomic getAtomic(OWLDescription desc) {
        return this.descConverter.convert(desc);
    }

    private DLLDataRole getDataRole(OWLDataProperty p) {
        DLLDataRole a = this.kb.getTBox().getDataRole(p.getURI().toString());
        if (a == null) {
            throw new NullPointerException("Data role not found: " + p);
        }
        return a;
    }

    private DLLObjectRole getGeneralObjectRole(OWLObjectPropertyExpression p) {
        return this.roleConverter.convert(p);
    }

    private DLLIndividual getIndividual(OWLIndividual i) {
        if (i.isAnonymous()) {
            throw new IllegalArgumentException();
        }
        return TermFactory.individual((String)i.getURI().toString());
    }

    private class ObjectRoleConverter
    implements OWLPropertyExpressionVisitor {
        private boolean invert = false;
        private OWLObjectProperty p;

        private ObjectRoleConverter() {
        }

        public DLLObjectRole convert(OWLObjectPropertyExpression pe) {
            this.p = null;
            this.invert = false;
            pe.accept((OWLPropertyExpressionVisitor)this);
            if (this.p == null) {
                throw new NullPointerException();
            }
            DLLBasicObjectRole r = ABoxLoader.this.kb.getTBox().getObjectRole(this.p.getURI().toString());
            if (r == null) {
                throw new NullPointerException("Object role not found: " + this.p);
            }
            if (this.invert) {
                return TermFactory.inverseOf((DLLObjectRole)r);
            }
            return r;
        }

        public void visit(OWLDataProperty property) {
            throw new IllegalStateException();
        }

        public void visit(OWLObjectProperty property) {
            this.p = property;
        }

        public void visit(OWLObjectPropertyInverse property) {
            this.invert = !this.invert;
            property.getInverse().accept((OWLPropertyExpressionVisitor)this);
        }
    }

    private class DescriptionConverter
    extends DefaultDescriptionVisitor {
        DLLAtomic atomic;

        private DescriptionConverter() {
        }

        public DLLAtomic convert(OWLDescription desc) {
            this.atomic = null;
            desc.accept((OWLDescriptionVisitor)this);
            if (this.atomic == null) {
                throw new NullPointerException();
            }
            return this.atomic;
        }

        public void defaultDescriptionVisit() {
            throw new UnsupportedOperationException();
        }

        public void visit(OWLClass desc) {
            this.atomic = ABoxLoader.this.kb.getTBox().getAtomic(desc.getURI().toString());
            if (this.atomic == null) {
                throw new NullPointerException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ABoxAxiomProcessor
    extends DefaultAxiomVisitor {
        private Collection<DLLABoxAssertion> assertions = new ArrayList<DLLABoxAssertion>();

        public void clear() {
            this.assertions.clear();
        }

        @Override
        public void defaultAxiomVisit() {
            throw new UnsupportedOperationException();
        }

        public Collection<DLLABoxAssertion> getAssertions() {
            return this.assertions;
        }

        public void process(OWLIndividualAxiom a) {
            a.accept((OWLAxiomVisitor)this);
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            DLLAtomic a = ABoxLoader.this.getAtomic(axiom.getDescription());
            DLLIndividual i = ABoxLoader.this.getIndividual(axiom.getIndividual());
            this.assertions.add((DLLABoxAssertion)TermFactory.assertion((DLLAtomic)a, (DLLIndividual)i));
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            DLLLiteral l;
            OWLDataPropertyExpression pe = (OWLDataPropertyExpression)axiom.getProperty();
            if (pe.isAnonymous()) {
                throw new UnsupportedOperationException();
            }
            DLLDataRole r = ABoxLoader.this.getDataRole(pe.asOWLDataProperty());
            DLLIndividual i = ABoxLoader.this.getIndividual(axiom.getSubject());
            OWLConstant o = (OWLConstant)axiom.getObject();
            String s = o.getLiteral();
            if (o.isTyped()) {
                Datatype datatype = new Datatype(o.asOWLTypedConstant().getDataType().getURI().toASCIIString());
                l = TermFactory.typedLiteral((String)s, (Datatype)datatype);
            } else {
                l = TermFactory.literal((String)s);
            }
            this.assertions.add((DLLABoxAssertion)TermFactory.assertion((DLLDataRole)r, (DLLIndividual)i, (DLLLiteral)l));
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)axiom.getProperty();
            DLLObjectRole r = ABoxLoader.this.getGeneralObjectRole(p);
            DLLIndividual s = ABoxLoader.this.getIndividual(axiom.getSubject());
            DLLIndividual o = ABoxLoader.this.getIndividual((OWLIndividual)axiom.getObject());
            this.assertions.add((DLLABoxAssertion)TermFactory.assertion((DLLObjectRole)r, (DLLIndividual)s, (DLLIndividual)o));
        }
    }
}

