/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres;

import com.clarkparsia.owlgres.DLLIndividual;
import com.clarkparsia.owlgres.DLLKB;
import com.clarkparsia.owlgres.DLLLiteral;
import com.clarkparsia.owlgres.abox.DLLABoxAssertion;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.query.Datatype;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.TermFactory;
import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.xml.sax.SAXException;

public class ABoxOnlyConsumer
implements RDFConsumer {
    public static final int ASSERTION_BUFFER_SIZE = 10000;
    public static final Log log = LogFactory.getLog(ABoxOnlyConsumer.class);
    private DLLKB kb;
    private DLLTBox tbox;
    private List<DLLABoxAssertion> buffer;
    private long stmtCount;
    private Map<String, Integer> ignoreCount;

    public ABoxOnlyConsumer(DLLKB kb) {
        if (kb == null) {
            throw new NullPointerException();
        }
        this.kb = kb;
        this.tbox = kb.getTBox();
        this.buffer = new ArrayList<DLLABoxAssertion>(10000);
        this.ignoreCount = new HashMap<String, Integer>();
    }

    public void addModelAttribte(String key, String value) throws SAXException {
    }

    public void endModel() throws SAXException {
        this.flush();
    }

    public void includeModel(String logicalURI, String physicalURI) throws SAXException {
    }

    public void logicalURI(String logicalURI) throws SAXException {
    }

    private void save(DLLABoxAssertion assertion) {
        this.buffer.add(assertion);
        if (this.buffer.size() >= 10000) {
            this.flush();
        }
    }

    private void flush() {
        log.debug((Object)"Flushing ABox assertion buffer to kb");
        this.kb.addAssertions(this.buffer);
        this.buffer.clear();
    }

    public void startModel(String physicalURI) throws SAXException {
    }

    public void statementWithLiteralValue(String subject, String predicate, String object, String language, String datatype) throws SAXException {
        this.logCount();
        DLLLiteral l = datatype != null ? TermFactory.literal((String)object, (Datatype)new Datatype(datatype)) : (language != null ? TermFactory.literal((String)object, (String)language) : TermFactory.literal((String)object));
        DLLDataRole r = this.tbox.getDataRole(predicate);
        if (r != null) {
            this.save((DLLABoxAssertion)TermFactory.assertion((DLLDataRole)r, (DLLIndividual)TermFactory.individual((String)subject), (DLLLiteral)l));
            return;
        }
        DLLAnnotationRoleBase a = this.tbox.getAnnotationRole(predicate);
        if (a != null) {
            this.save((DLLABoxAssertion)TermFactory.constantAnnotationAssertion((DLLAnnotationRoleBase)TermFactory.annotationRole((String)a.getName()), (DLLIndividual)TermFactory.individual((String)subject), (DLLLiteral)l));
            return;
        }
        Integer count = this.ignoreCount.get(predicate);
        if (count == null) {
            count = 0;
            log.warn((Object)("Ignoring statement with unknown predicate (lit): [" + subject + ", " + predicate + ", " + object + "]"));
        }
        this.ignoreCount.put(predicate, count + 1);
    }

    private void logCount() {
        if (++this.stmtCount % 10000L == 0L) {
            log.info((Object)(this.stmtCount + " statements read"));
        }
    }

    public void statementWithResourceValue(String subject, String predicate, String object) throws SAXException {
        this.logCount();
        DLLIndividual subjectIndividual = TermFactory.individual((String)subject);
        if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.getURI().toASCIIString())) {
            if (object.equals(OWLRDFVocabulary.OWL_ONTOLOGY.getURI().toASCIIString())) {
                return;
            }
            DLLAtomic a = this.tbox.getAtomic(object);
            if (a == null) {
                log.error((Object)("Attempt to add instance of unknown class: " + object));
            }
            this.save((DLLABoxAssertion)TermFactory.assertion((DLLAtomic)a, (DLLIndividual)subjectIndividual));
            return;
        }
        if (predicate.equals(OWLRDFVocabulary.OWL_SAME_AS.getURI().toASCIIString())) {
            this.save((DLLABoxAssertion)TermFactory.assertionSameAs((DLLIndividual)subjectIndividual, (DLLIndividual)TermFactory.individual((String)object)));
            return;
        }
        DLLBasicObjectRole r = this.tbox.getObjectRole(predicate);
        if (r != null) {
            this.save((DLLABoxAssertion)TermFactory.assertion((DLLObjectRole)r, (DLLIndividual)subjectIndividual, (DLLIndividual)TermFactory.individual((String)object)));
            return;
        }
        DLLAnnotationRoleBase a = this.tbox.getAnnotationRole(predicate);
        if (a != null) {
            this.save((DLLABoxAssertion)TermFactory.objectAnnotationAssertion((DLLAnnotationRoleBase)TermFactory.annotationRole((String)a.getName()), (DLLIndividual)subjectIndividual, (DLLIndividual)TermFactory.individual((String)object)));
            return;
        }
        Integer count = this.ignoreCount.get(predicate);
        if (count == null) {
            count = 0;
            log.warn((Object)("Ignoring statement with unknown predicate (res): [" + subject + ", " + predicate + ", " + object + "]"));
        }
        this.ignoreCount.put(predicate, count + 1);
    }
}

