/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres;

import com.clarkparsia.owlgres.DLLException;
import com.clarkparsia.owlgres.DefaultAnnotationVisitor;
import com.clarkparsia.owlgres.DefaultAxiomVisitor;
import com.clarkparsia.owlgres.DefaultDescriptionVisitor;
import com.clarkparsia.owlgres.concept.DLLAtomic;
import com.clarkparsia.owlgres.concept.DLLBasicConcept;
import com.clarkparsia.owlgres.concept.DLLGeneralConcept;
import com.clarkparsia.owlgres.concept.DLLObjectExistential;
import com.clarkparsia.owlgres.role.DLLAnnotationRoleBase;
import com.clarkparsia.owlgres.role.DLLBasicObjectRole;
import com.clarkparsia.owlgres.role.DLLDataRole;
import com.clarkparsia.owlgres.role.DLLObjectRole;
import com.clarkparsia.owlgres.tbox.DLLTBox;
import com.clarkparsia.owlgres.util.TermFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationVisitor;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.util.OWLEntityCollector;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBoxLoader {
    private static Set<DLLAnnotationRoleBase> defaultAnnotationRoles = new HashSet<DLLAnnotationRoleBase>();
    private static final String fakePropertyBase = "tag:clarkparsia.com,2007:owlgres:artificial-role:";
    public static final Log log;
    private NormalizingDescriptionVisitor conceptMaker;
    private NormalizingAnnotationVisitor annotationVisitor;
    private EntityRecorder entityRecorder;
    private OWLEntityCollector entityCollector;
    private OWLDataFactory factory = OWLManager.createOWLOntologyManager().getOWLDataFactory();
    private int fakePropertyIndex = 0;
    private DLLTBox tbox;

    public TBoxLoader() {
        this.conceptMaker = new NormalizingDescriptionVisitor();
        this.annotationVisitor = new NormalizingAnnotationVisitor();
        this.entityRecorder = new EntityRecorder();
        this.entityCollector = new OWLEntityCollector();
        this.entityCollector.setCollectClasses(true);
        this.entityCollector.setCollectDataProperties(true);
        this.entityCollector.setCollectObjectProperties(true);
        this.entityCollector.setCollectDataTypes(false);
        this.entityCollector.setCollectIndividuals(false);
    }

    public DLLTBox load(String tboxURI) {
        OWLOntology ontology;
        URI ontologyURI = URI.create(tboxURI);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        try {
            ontology = manager.loadOntologyFromPhysicalURI(ontologyURI);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return null;
        }
        return this.getTBox(ontology);
    }

    public static TBoxLoader get() {
        return new TBoxLoader();
    }

    private void addDisjoints(Set<DLLGeneralConcept> lfts, Set<DLLGeneralConcept> rgts) {
        if (lfts.size() != 1) {
            throw new UnsupportedOperationException();
        }
        DLLGeneralConcept lft = lfts.iterator().next();
        if (lft instanceof DLLBasicConcept) {
            DLLBasicConcept bl = (DLLBasicConcept)lft;
            for (DLLGeneralConcept rgt : rgts) {
                this.tbox.addInclusion(bl, TermFactory.negationOf((DLLGeneralConcept)rgt));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addInclusions(Set<DLLGeneralConcept> lfts, Set<DLLGeneralConcept> rgts) {
        if (lfts.size() != 1) {
            throw new UnsupportedOperationException();
        }
        DLLGeneralConcept lft = lfts.iterator().next();
        if (lft instanceof DLLBasicConcept) {
            DLLBasicConcept bl = (DLLBasicConcept)lft;
            for (DLLGeneralConcept rgt : rgts) {
                this.tbox.addInclusion(bl, rgt);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addRoleInclusion(DLLObjectRole r, DLLObjectRole s) {
        this.tbox.addInclusion(r, s);
    }

    private DLLBasicObjectRole getAuxRole(OWLObjectPropertyExpression p) {
        String core = p.isAnonymous() ? "anon" : p.asOWLObjectProperty().getURI().toString();
        return this.conceptMaker.getObjectRole(this.factory.getOWLObjectProperty(URI.create(fakePropertyBase + core + "-" + this.fakePropertyIndex++)), true);
    }

    public DLLTBox getTBox(OWLOntology ontology) {
        this.tbox = new DLLTBox();
        Iterator<DLLAnnotationRoleBase> iter = defaultAnnotationRoles.iterator();
        while (iter.hasNext()) {
            this.tbox.addRole(iter.next());
        }
        NormalizingAxiomVisitor v = new NormalizingAxiomVisitor();
        this.entityCollector.reset();
        for (OWLAxiom a : ontology.getAxioms()) {
            try {
                a.accept((OWLAxiomVisitor)v);
            }
            catch (DLLException e) {
                log.error((Object)("Runtime exception while processing axiom: " + a));
            }
        }
        this.entityRecorder.record(this.entityCollector.getObjects());
        return this.tbox;
    }

    static {
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.OWL_PRIOR_VERSION.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.OWL_VERSION_INFO.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.RDFS_COMMENT.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.RDFS_IS_DEFINED_BY.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.RDFS_LABEL.toString()));
        defaultAnnotationRoles.add(new DLLAnnotationRoleBase(OWLRDFVocabulary.RDFS_SEE_ALSO.toString()));
        log = LogFactory.getLog(TBoxLoader.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NormalizingDescriptionVisitor
    extends DefaultDescriptionVisitor {
        private Set<DLLGeneralConcept> conjuncts;
        private boolean left;
        private boolean negated;

        private NormalizingDescriptionVisitor() {
        }

        public void addAtomic(String name) {
            this.getAtomic(name);
        }

        public void addDataRole(OWLDataProperty p) {
            this.getDataRole((OWLDataPropertyExpression)p);
        }

        public void addRole(OWLObjectProperty p) {
            this.getObjectRole(p);
        }

        @Override
        public void defaultDescriptionVisit() {
            throw new UnsupportedOperationException();
        }

        private DLLAtomic getAtomic(String name) {
            DLLAtomic a = TBoxLoader.this.tbox.getAtomic(name);
            if (a == null) {
                a = TermFactory.atomic((String)name);
                TBoxLoader.this.tbox.addAtomic(a);
            }
            return a;
        }

        public Set<DLLGeneralConcept> getConjuncts(OWLDescription desc, boolean left) {
            this.conjuncts = new HashSet<DLLGeneralConcept>();
            this.negated = false;
            this.left = left;
            desc.accept((OWLDescriptionVisitor)this);
            return this.conjuncts;
        }

        public DLLDataRole getDataRole(OWLDataPropertyExpression p) {
            if (p.isAnonymous()) {
                throw new RuntimeException();
            }
            OWLDataProperty q = p.asOWLDataProperty();
            DLLDataRole r = TBoxLoader.this.tbox.getDataRole(q.getURI().toString());
            if (r == null) {
                r = TermFactory.dataRole((String)q.getURI().toString());
                TBoxLoader.this.tbox.addRole(r);
            }
            return r;
        }

        public DLLObjectRole getGeneralObjectRole(OWLObjectPropertyExpression p, boolean invert) {
            if (!p.isAnonymous()) {
                DLLBasicObjectRole r = this.getObjectRole(p.asOWLObjectProperty());
                return invert ? TermFactory.inverseOf((DLLObjectRole)r) : r;
            }
            if (p instanceof OWLObjectPropertyInverse) {
                OWLObjectPropertyInverse inv = (OWLObjectPropertyInverse)p;
                return this.getGeneralObjectRole(inv.getInverse(), !invert);
            }
            throw new RuntimeException();
        }

        private DLLBasicObjectRole getObjectRole(OWLObjectProperty p) {
            return this.getObjectRole(p, false);
        }

        private DLLBasicObjectRole getObjectRole(OWLObjectProperty p, boolean auxiliary) {
            String name = p.getURI().toString();
            DLLBasicObjectRole r = TBoxLoader.this.tbox.getObjectRole(name);
            if (r == null) {
                r = TermFactory.objectRole((String)name, (boolean)auxiliary);
                TBoxLoader.this.tbox.addRole(r);
            }
            return r;
        }

        protected void invertNegation() {
            this.negated = !this.negated;
        }

        protected boolean isNegated() {
            return this.negated;
        }

        protected void setNegated(boolean negated) {
            this.negated = negated;
        }

        @Override
        public void visit(OWLClass desc) {
            DLLAtomic a = this.getAtomic(desc.getURI().toString());
            if (this.isNegated()) {
                if (this.left) {
                    throw new UnsupportedOperationException();
                }
                this.conjuncts.add(TermFactory.negationOf((DLLGeneralConcept)a));
            } else {
                this.conjuncts.add((DLLGeneralConcept)a);
            }
        }

        @Override
        public void visit(OWLDataSomeRestriction desc) {
            OWLDataRange filler = (OWLDataRange)desc.getFiller();
            if (!filler.equals(TBoxLoader.this.factory.getTopDataType())) {
                throw new UnsupportedOperationException();
            }
            OWLDataPropertyExpression dp = (OWLDataPropertyExpression)desc.getProperty();
            if (dp.isAnonymous()) {
                throw new RuntimeException();
            }
            if (this.isNegated()) {
                if (this.left) {
                    throw new UnsupportedOperationException();
                }
                this.conjuncts.add(TermFactory.negationOf((DLLGeneralConcept)TermFactory.existential((DLLDataRole)this.getDataRole((OWLDataPropertyExpression)dp.asOWLDataProperty()))));
            } else {
                this.conjuncts.add((DLLGeneralConcept)TermFactory.existential((DLLDataRole)this.getDataRole((OWLDataPropertyExpression)dp.asOWLDataProperty())));
            }
        }

        @Override
        public void visit(OWLObjectComplementOf desc) {
            this.invertNegation();
            desc.accept((OWLDescriptionVisitor)this);
        }

        @Override
        public void visit(OWLObjectIntersectionOf desc) {
            if (this.isNegated()) {
                throw new UnsupportedOperationException();
            }
            for (OWLDescription d : desc.getOperands()) {
                boolean b = this.isNegated();
                d.accept((OWLDescriptionVisitor)this);
                this.setNegated(b);
            }
        }

        @Override
        public void visit(OWLObjectSomeRestriction desc) {
            DLLObjectExistential e;
            if (this.negated && this.left) {
                throw new UnsupportedOperationException();
            }
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)desc.getProperty();
            DLLObjectRole r = this.getGeneralObjectRole(p, false);
            OWLDescription d = (OWLDescription)desc.getFiller();
            if (d.equals(TBoxLoader.this.factory.getOWLThing())) {
                e = TermFactory.existential((DLLObjectRole)r);
            } else {
                if (this.left) {
                    throw new UnsupportedOperationException("The description is part of a conjunction on the left side of an inclusion axiom " + desc.toString());
                }
                NormalizingDescriptionVisitor other = new NormalizingDescriptionVisitor();
                Set<DLLGeneralConcept> qs = other.getConjuncts(d, false);
                DLLBasicObjectRole rAux = TBoxLoader.this.getAuxRole(p);
                e = TermFactory.existential((DLLObjectRole)rAux);
                TBoxLoader.this.addRoleInclusion((DLLObjectRole)rAux, r);
                TBoxLoader.this.addInclusions(Collections.singleton(TermFactory.existential((DLLObjectRole)TermFactory.inverseOf((DLLObjectRole)rAux))), qs);
            }
            this.conjuncts.add((DLLGeneralConcept)(this.negated ? TermFactory.negationOf((DLLGeneralConcept)e) : e));
        }
    }

    private class NormalizingAxiomVisitor
    extends DefaultAxiomVisitor {
        private final OWLClass deprecatedClass;
        private final OWLClass deprecatedProperty;

        private NormalizingAxiomVisitor() {
            this.deprecatedClass = TBoxLoader.this.factory.getOWLClass(OWLRDFVocabulary.OWL_DEPRECATED_CLASS.getURI());
            this.deprecatedProperty = TBoxLoader.this.factory.getOWLClass(OWLRDFVocabulary.OWL_DEPRECATED_PROPERTY.getURI());
        }

        public void defaultAxiomVisit() {
            throw new UnsupportedOperationException();
        }

        public void visit(OWLAxiomAnnotationAxiom axiom) {
            axiom.accept((OWLObjectVisitor)TBoxLoader.this.entityCollector);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            OWLDescription desc = axiom.getDescription();
            if (!desc.equals(this.deprecatedClass) && !desc.equals(this.deprecatedProperty)) {
                throw new UnsupportedOperationException();
            }
            axiom.getIndividual().accept((OWLObjectVisitor)TBoxLoader.this.entityCollector);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            TBoxLoader.this.factory.getOWLSubClassAxiom((OWLDescription)TBoxLoader.this.factory.getOWLDataSomeRestriction((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)TBoxLoader.this.factory.getTopDataType()), axiom.getDomain()).accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (((OWLDataRange)axiom.getRange()).equals(TBoxLoader.this.factory.getTopDataType())) {
                OWLDataPropertyExpression pe = (OWLDataPropertyExpression)axiom.getProperty();
                if (pe.isAnonymous()) {
                    throw new UnsupportedOperationException();
                }
            } else {
                throw new UnsupportedOperationException();
            }
            axiom.accept((OWLObjectVisitor)TBoxLoader.this.entityCollector);
        }

        public void visit(OWLDataSubPropertyAxiom axiom) {
            DLLDataRole r = TBoxLoader.this.conceptMaker.getDataRole((OWLDataPropertyExpression)axiom.getSubProperty());
            DLLDataRole s = TBoxLoader.this.conceptMaker.getDataRole((OWLDataPropertyExpression)axiom.getSuperProperty());
            TBoxLoader.this.tbox.addInclusion(r, s);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            axiom.accept((OWLObjectVisitor)TBoxLoader.this.entityCollector);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            ArrayList clses = new ArrayList(axiom.getDescriptions());
            for (int i = 0; i < clses.size() - 1; ++i) {
                Set<DLLGeneralConcept> lfts = TBoxLoader.this.conceptMaker.getConjuncts((OWLDescription)clses.get(i), true);
                for (int j = i + 1; j < clses.size(); ++j) {
                    Set<DLLGeneralConcept> rgts = TBoxLoader.this.conceptMaker.getConjuncts((OWLDescription)clses.get(j), true);
                    TBoxLoader.this.addDisjoints(lfts, rgts);
                }
            }
        }

        public void visit(OWLEntityAnnotationAxiom axiom) {
            axiom.accept((OWLObjectVisitor)TBoxLoader.this.entityCollector);
            TBoxLoader.this.annotationVisitor.processAnnotationRole(axiom.getAnnotation());
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            ArrayList clses = new ArrayList(axiom.getDescriptions());
            for (int i = 0; i < clses.size() - 1; ++i) {
                Set<DLLGeneralConcept> lfts = TBoxLoader.this.conceptMaker.getConjuncts((OWLDescription)clses.get(i), true);
                for (int j = i + 1; j < clses.size(); ++j) {
                    Set<DLLGeneralConcept> rgts = TBoxLoader.this.conceptMaker.getConjuncts((OWLDescription)clses.get(j), true);
                    TBoxLoader.this.addInclusions(lfts, rgts);
                    TBoxLoader.this.addInclusions(rgts, lfts);
                }
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            DLLObjectRole r = TBoxLoader.this.conceptMaker.getGeneralObjectRole(axiom.getFirstProperty(), false);
            DLLObjectRole s = TBoxLoader.this.conceptMaker.getGeneralObjectRole(axiom.getSecondProperty(), true);
            TBoxLoader.this.addRoleInclusion(r, s);
            TBoxLoader.this.addRoleInclusion(s, r);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            TBoxLoader.this.factory.getOWLSubClassAxiom((OWLDescription)TBoxLoader.this.factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)axiom.getProperty(), (OWLDescription)TBoxLoader.this.factory.getOWLThing()), axiom.getDomain()).accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            TBoxLoader.this.factory.getOWLSubClassAxiom((OWLDescription)TBoxLoader.this.factory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)TBoxLoader.this.factory.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)axiom.getProperty()), (OWLDescription)TBoxLoader.this.factory.getOWLThing()), (OWLDescription)axiom.getRange()).accept((OWLAxiomVisitor)this);
        }

        public void visit(OWLObjectSubPropertyAxiom axiom) {
            DLLObjectRole r = TBoxLoader.this.conceptMaker.getGeneralObjectRole((OWLObjectPropertyExpression)axiom.getSubProperty(), false);
            DLLObjectRole s = TBoxLoader.this.conceptMaker.getGeneralObjectRole((OWLObjectPropertyExpression)axiom.getSuperProperty(), false);
            TBoxLoader.this.addRoleInclusion(r, s);
        }

        public void visit(OWLOntologyAnnotationAxiom axiom) {
        }

        public void visit(OWLSubClassAxiom axiom) {
            Set<DLLGeneralConcept> lfts = TBoxLoader.this.conceptMaker.getConjuncts(axiom.getSubClass(), true);
            Set<DLLGeneralConcept> rgts = TBoxLoader.this.conceptMaker.getConjuncts(axiom.getSuperClass(), false);
            TBoxLoader.this.addInclusions(lfts, rgts);
        }
    }

    private class NormalizingAnnotationVisitor
    extends DefaultAnnotationVisitor {
        private NormalizingAnnotationVisitor() {
        }

        public void defaultAnnotationVisit() {
            throw new UnsupportedOperationException();
        }

        public void visit(OWLObjectAnnotation a) {
            TBoxLoader.this.tbox.addRole(new DLLAnnotationRoleBase(a.getAnnotationURI().toASCIIString()));
        }

        public void visit(OWLConstantAnnotation a) {
            TBoxLoader.this.tbox.addRole(new DLLAnnotationRoleBase(a.getAnnotationURI().toASCIIString()));
        }

        public void processAnnotationRole(OWLAnnotation a) {
            a.accept((OWLAnnotationVisitor)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntityRecorder
    implements OWLEntityVisitor {
        private EntityRecorder() {
        }

        public void record(OWLEntity ... entities) {
            this.record(Arrays.asList(entities));
        }

        public void record(Collection<OWLEntity> entities) {
            for (OWLEntity e : entities) {
                e.accept((OWLEntityVisitor)this);
            }
        }

        public void visit(OWLClass cls) {
            TBoxLoader.this.tbox.addAtomic(TermFactory.atomic((String)cls.getURI().toString()));
        }

        public void visit(OWLDataProperty property) {
            TBoxLoader.this.tbox.addRole(TermFactory.dataRole((String)property.getURI().toString()));
        }

        public void visit(OWLDataType dataType) {
            throw new UnsupportedOperationException();
        }

        public void visit(OWLIndividual individual) {
            throw new UnsupportedOperationException();
        }

        public void visit(OWLObjectProperty property) {
            TBoxLoader.this.tbox.addRole(TermFactory.objectRole((String)property.getURI().toString()));
        }
    }
}

