/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.expchk;

import com.clarkparsia.owlgres.expchk.Explanation;
import com.clarkparsia.owlgres.expchk.Fragment;
import com.clarkparsia.owlgres.expchk.FragmentBase;
import java.util.List;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class ExpressivityChecker {
    private int level;
    private Fragment fragment;
    private StringBuffer explanation;

    public ExpressivityChecker(Fragment fragment) {
        this(fragment, 2);
    }

    public ExpressivityChecker(Fragment fragment, int level) {
        this.fragment = fragment;
        this.level = level;
        this.explanation = new StringBuffer();
    }

    public boolean check(OWLOntology ontology) {
        FragmentBase fb = (FragmentBase)this.fragment;
        for (OWLAxiom a : ontology.getAxioms()) {
            fb.setAxiom(a);
            a.accept((OWLAxiomVisitor)fb);
        }
        List<Explanation> explanations = this.fragment.getExplanations();
        for (Explanation e : explanations) {
            if (e.getLevel() < this.level) continue;
            this.explanation.append(e.toString() + "\n");
        }
        return this.fragment.status();
    }

    public String explain() {
        return this.explanation.toString();
    }
}

