/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlgres.expchk;

import com.clarkparsia.owlgres.expchk.FragmentBase;
import com.clarkparsia.owlgres.expchk.explanation.AnonymousProperty;
import com.clarkparsia.owlgres.expchk.explanation.DescriptionLeftInAxiom;
import com.clarkparsia.owlgres.expchk.explanation.IgnoredInOwlgres;
import com.clarkparsia.owlgres.expchk.explanation.NegatedDescriptionLeftInAxiom;
import com.clarkparsia.owlgres.expchk.explanation.NoSupportForAxiom;
import com.clarkparsia.owlgres.expchk.explanation.NoSupportInOwlgres;
import java.util.ArrayList;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

public class FragmentDLL
extends FragmentBase {
    private DeclarationAxiomChecker declarationChecker;
    private OWLDataFactory f = OWLManager.createOWLOntologyManager().getOWLDataFactory();
    private boolean left;
    private boolean negated;
    private final OWLClass deprecatedClass = this.f.getOWLClass(OWLRDFVocabulary.OWL_DEPRECATED_CLASS.getURI());
    private final OWLClass deprecatedProperty = this.f.getOWLClass(OWLRDFVocabulary.OWL_DEPRECATED_PROPERTY.getURI());

    public FragmentDLL() {
        this.declarationChecker = new DeclarationAxiomChecker();
    }

    public void visit(OWLAxiomAnnotationAxiom a) {
        this.add(new NoSupportInOwlgres(a), true);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        OWLDescription desc = axiom.getDescription();
        if (desc.equals(this.deprecatedClass) || desc.equals(this.deprecatedProperty)) {
            this.add(new IgnoredInOwlgres("Class and property deprecation are ignored in Owlgres"), true);
        } else {
            this.add(new NoSupportForAxiom("OWLClassAssertionAxiom"), false);
        }
    }

    public void visit(OWLDeclarationAxiom a) {
        this.declarationChecker.check(a);
    }

    public void visit(OWLEntityAnnotationAxiom a) {
        this.add(new IgnoredInOwlgres(a), true);
    }

    public void visit(OWLOntologyAnnotationAxiom a) {
        this.add(new IgnoredInOwlgres(a), true);
    }

    public void visit(OWLObjectPropertyDomainAxiom a) {
        this.f.getOWLSubClassAxiom((OWLDescription)this.f.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)a.getProperty(), (OWLDescription)this.f.getOWLThing()), a.getDomain()).accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLObjectPropertyRangeAxiom a) {
        this.f.getOWLSubClassAxiom((OWLDescription)this.f.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)this.f.getOWLObjectPropertyInverse((OWLObjectPropertyExpression)a.getProperty()), (OWLDescription)this.f.getOWLThing()), (OWLDescription)a.getRange()).accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLDataPropertyDomainAxiom a) {
        this.f.getOWLSubClassAxiom((OWLDescription)this.f.getOWLDataSomeRestriction((OWLDataPropertyExpression)a.getProperty(), (OWLDataRange)this.f.getTopDataType()), a.getDomain()).accept((OWLAxiomVisitor)this);
    }

    public void visit(OWLObjectSubPropertyAxiom a) {
        this.check((OWLObjectPropertyExpression)a.getSubProperty());
        this.check((OWLObjectPropertyExpression)a.getSuperProperty());
    }

    public void visit(OWLDataSubPropertyAxiom a) {
        this.check((OWLDataPropertyExpression)a.getSubProperty());
        this.check((OWLDataPropertyExpression)a.getSuperProperty());
    }

    public void visit(OWLDataPropertyRangeAxiom a) {
        this.check((OWLDataPropertyExpression)a.getProperty());
        this.check((OWLDataRange)a.getRange());
    }

    public void visit(OWLDisjointClassesAxiom a) {
        ArrayList clses = new ArrayList(a.getDescriptions());
        for (int i = 0; i < clses.size() - 1; ++i) {
            this.check((OWLDescription)clses.get(i), true);
            for (int j = i + 1; j < clses.size(); ++j) {
                this.check((OWLDescription)clses.get(j), true);
            }
        }
    }

    public void visit(OWLEquivalentClassesAxiom a) {
        ArrayList clses = new ArrayList(a.getDescriptions());
        for (int i = 0; i < clses.size() - 1; ++i) {
            this.check((OWLDescription)clses.get(i), true);
            for (int j = i + 1; j < clses.size(); ++j) {
                this.check((OWLDescription)clses.get(j), true);
            }
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom a) {
        this.check(a.getFirstProperty());
        this.check(a.getSecondProperty());
    }

    public void visit(OWLSubClassAxiom a) {
        this.check(a.getSubClass(), true);
        this.check(a.getSuperClass(), false);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom a) {
        this.add(new NoSupportInOwlgres(a), true);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom a) {
        this.add(new NoSupportInOwlgres(a), true);
    }

    public void visit(OWLSymmetricObjectPropertyAxiom a) {
        this.add(new NoSupportInOwlgres(a), true);
    }

    public void visit(OWLClass c) {
        if (this.negated && this.left) {
            this.add(new NegatedDescriptionLeftInAxiom(c), false);
        }
    }

    public void visit(OWLDataSomeRestriction p) {
        this.check((OWLDataPropertyExpression)p.getProperty());
        this.check((OWLDataRange)p.getFiller());
        if (this.left) {
            if (this.negated) {
                this.add(new NegatedDescriptionLeftInAxiom(p), false);
            }
            if (!((OWLDataRange)p.getFiller()).equals(this.f.getTopDataType())) {
                this.add(new DescriptionLeftInAxiom(p), false);
            }
        }
    }

    public void visit(OWLObjectComplementOf d) {
        this.invertNegation();
        d.accept((OWLDescriptionVisitor)this);
    }

    public void visit(OWLObjectIntersectionOf i) {
        if (this.negated) {
            this.add(new NegatedDescriptionLeftInAxiom(i), false);
        }
        for (OWLDescription d : i.getOperands()) {
            boolean b = this.negated;
            d.accept((OWLDescriptionVisitor)this);
            this.negated = b;
        }
    }

    public void visit(OWLObjectSomeRestriction d) {
        if (this.negated && this.left) {
            this.add(new NegatedDescriptionLeftInAxiom(d), false);
        }
        if (!((OWLDescription)d.getFiller()).isOWLThing() && this.left) {
            this.add(new DescriptionLeftInAxiom(d), false);
        }
        this.check((OWLObjectPropertyExpression)d.getProperty());
    }

    private void check(OWLObjectPropertyExpression p) {
        if (p instanceof OWLObjectPropertyInverse) {
            this.check(((OWLObjectPropertyInverse)p).getInverse());
        } else if (p.isAnonymous()) {
            this.add(new AnonymousProperty(p), false);
        }
    }

    private void check(OWLDataPropertyExpression p) {
        if (p.isAnonymous()) {
            this.add(new AnonymousProperty(p), false);
        }
    }

    private void check(OWLDataRange r) {
        if (!r.equals(this.f.getTopDataType())) {
            this.add(new NoSupportInOwlgres(r), false);
        }
    }

    private void check(OWLDescription d, boolean left) {
        this.left = left;
        this.negated = false;
        d.accept((OWLDescriptionVisitor)this);
    }

    private void invertNegation() {
        this.negated = !this.negated;
    }

    private class DeclarationAxiomChecker
    implements OWLEntityVisitor {
        private OWLDeclarationAxiom axiom;

        private DeclarationAxiomChecker() {
        }

        public void check(OWLDeclarationAxiom axiom) {
            this.axiom = axiom;
        }

        public void visit(OWLClass cls) {
        }

        public void visit(OWLDataProperty property) {
        }

        public void visit(OWLDataType dataType) {
            if (!dataType.equals(FragmentDLL.this.f.getTopDataType())) {
                FragmentDLL.this.add(new NoSupportInOwlgres((OWLDataRange)dataType), true);
            }
        }

        public void visit(OWLIndividual individual) {
            FragmentDLL.this.add(new NoSupportInOwlgres(this.axiom), true);
        }

        public void visit(OWLObjectProperty property) {
        }
    }
}

